'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_004_.inc,v $
'*
'*  $Revision: 1.16 $
'*
'*  last change: $Author: jsi $ $Date: 2008/02/18 14:33:21 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Check all resources for menuitem Insert - Part 1
'*
'*************************************************************************************************
'*
' #1 C_004_ ' Inital routine
' #1 tInsertManualBreakRowBreak
' #1 tInsertManualBreakColumnBreak
' #1 tInsertCells
' #1 tInsertRows
' #1 tInsertColumns
' #1 tInsertSheet
' #1 tInsertSheetFromFile
' #1 tInsertLinkToExternalData
' #1 tInsertFunction
' #1 tInsertFunctionList 
' #1 tInsertNamesDefine
' #1 tInsertNamesInsert
' #1 tInsertNamesCreate
' #1 tInsertNamesLabels
' #1 tInsertNote
' #1 tInsertSpecialCharacter
' #1 tInsertHyperlink
' #1 tInsertGraphicFromFile
' #1 tInsertMovieAndSound
' #1 tInsertChart
' #1 tInsertFormula
' #1 tInsertFrame
' #1 tInsertObjectOLE
' #1 tInsertObjectPlugin
' #0 sInsertHyperlink    'Routine for switching the tab pages inside the Hyperlink dialog
'*
'\************************************************************************************************

sub C_004_

Printlog "----------------------- C_004_ (Insert menu) ------------------------"

    call ExitRestartTheOffice
    Call tInsertManualBreakRowBreak
    Call tInsertManualBreakColumnBreak
    Call tInsertCells
    Call tInsertRows
    Call tInsertColumns
    Call tInsertSheet
    Call tInsertLinkToExternalData
    call tInsertSheetFromFile
    Call tInsertFunction
    Call tInsertFunctionList 
    Call tInsertNamesDefine
    Call tInsertNamesInsert
    Call tInsertNamesCreate
    Call tInsertNamesLabels
    Call tInsertNote
    Call tInsertSpecialCharacter
    call tInsertHyperlink
    call tInsertGraphicFromFile
    call tInsertMovieAndSound
    Call tInsertChart
    Call tInsertFormula
    Call tInsertFrame
    Call tInsertObjectOLE
    Call tInsertObjectPlugin

end sub

'
'-----------------------------------------------------------
'
testcase tInsertManualBreakRowBreak
'///<u><b>Insert / Manual Break / RowBreak</b></u>
    '/// Create a new spreadsheet document
    Call hNewDocument
    '/// Move three rows down
    DocumentCalc.Typekeys "<Down><Down><Down>"
    '/// Insert / Manual Break / RowBreak
    InsertManuelBreakRowBreak
    wait 50
    '/// Edit / Delete Manual Break / Row Break
    EditRemoveManualBreakRowBreak
    wait 50
    '/// Close document
    Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tInsertManualBreakColumnBreak
'///<u><b>Insert / Manual Break / ColumnBreak</b></u>
    '/// Create a new spreadsheet document
    Call hNewDocument
    '/// Move three columns right
    DocumentCalc.Typekeys "<Right><Right><Right>"
    '/// Insert / Manual Break / ColumnBreak
    InsertManuelBreakColumnBreak
    wait 50
    '/// Edit / Delete Manual Break / Column Break
    EditRemoveManualBreakColumnBreak
    '/// Close document
    Call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertCells
'///<u><b>Insert / Cells...</b></u>
    '/// Create a new spreadsheet document
    Call hNewDocument
    '/// Insert / Cells...
    InsertCells
    Kontext "ZellenEinfuegen"
    '/// Check dialog 'Insert Cells'
    Call DialogTest ( ZellenEinfuegen )
    '/// Quit dialog
    ZellenEinfuegen.Cancel
    '/// Close document
    call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tInsertRows
'///<u><b>Insert / Rows...</b></u>
    '/// Create a new spreadsheet document
    Call hNewDocument
    '/// Insert / Rows<br>Note: In an empty nothing special happens
    InsertRowsCalc
    Kontext
    DocumentCalc.TypeKeys "<Return>"
    '/// Close document
    Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tInsertColumns
'///<u><b>Insert / Columns...</b></u>
    '/// Create a new spreadsheet document
    Call hNewDocument
    '/// Insert / Columns<br>Note: In an empty nothing special happens
    InsertColumnsCalc
    Kontext
    DocumentCalc.TypeKeys "<Return>"
    '/// Close document
    Call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertSheet
'///<u><b>Insert / Sheet...</b></u>
    '/// Create a new spreadsheet document
    Call hNewDocument
    '/// Insert / Sheet...
    InsertSheetCalc
    Kontext "TabelleEinfuegenCalc"
    '/// Check first state of 'Insert Sheet' dialog
    DialogTest2 ( TabelleEinfuegenCalc, 1  )
    AusDateiErstellen.Check
    '/// Check second state of 'Insert Sheet' dialog
    DialogTest2 ( TabelleEinfuegenCalc, 2  )
    Neuerstellen.check
    '/// Quit dialog
    TabelleEinfuegenCalc.Cancel
    '/// Close document
    Call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertSheetFromFile
'///<u><b>Insert / Sheet...</b></u>
    Dim sInsertThisFile as STRING
        sInsertThisFile = convertpath ( gTesttoolPath & "calc/update/input/c_001/all_features.sxc" )
    '/// Create a new spreadsheet document
    Call hNewDocument
    '/// Insert / Sheet from file
    InsertSheetFromFile
    '/// Test 'File Open' dialog, don't close it at the end
    subTestFileOpenDialog ( FALSE )
    sleep (2)
    '/// Set file name <i>.../calc/update/input/c_001/all_features.sxc</i>
    Dateiname.setText ( sInsertThisFile )
    '/// Click 'Insert'
    Oeffnen.Click
    sleep (5)
    Kontext "TabelleEinfuegenCalc"
    call DialogTest ( TabelleEinfuegenCalc )
    '/// Check if the selected file has 44 sheets
    if Auswahl.getItemCount <> 44 then
        warnlog "Unexpected number of of sheets detected in selected file -> Check this out!"
    else
        printlog "Number of detected sheet in slected file is OK."
    end if
    '/// Exit dialog with CANCEL button
    TabelleEinfuegenCalc.Cancel
    '/// Close document
    call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertLinkToExternalData
    '/// Create a new spreadsheet document 
    call hNewDocument
    '/// Insert / Link to external data
    InsertLinkToExternalData
    Kontext "ExternalData"
    call Dialogtest (ExternalData)
    '/// Click Choos file button 
    FileChoose.Click
    Kontext "OeffnenDlg"        
    call Dialogtest (OeffnenDlg)
    '/// Close file open dialog
    OeffnenDlg.close
    Kontext "ExternalData"
    '/// Close external data dialog
    ExternalData.close
    call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertFunction
Dim ifunctionCount as integer
Dim ifunctionIndex as integer

'/// Create new spreadsheet document
Call hNewDocument
    '/// Insert / Function
    InsertFunction
    Kontext "Funktionsautopilot"
    '/// Select each entry of the function assistant
    ifunctionCount = Funktion.getItemCount      
    for ifunctionIndex = 1 To ifunctionCount
        Kategorie.Select(2)
        Funktion.Select(ifunctionIndex)
        sleep(1)
        call DialogTest2 ( Funktionsautopilot,1 )
    next ifunctionIndex
    
    for ifunctionIndex = 1 To ifunctionCount
        Kategorie.Select(2)
        Funktion.Select(ifunctionIndex)
        Weiter.Click
        call DialogTest2 (Funktionsautopilot,2)
        Formel.typekeys "<MOD1 A><DELETE>", true
    next ifunctionIndex
    '/// Toggle to the structure tab page
    Kontext "FunktionsautopilotTabControl"
    FunktionsautopilotTabControl.setpage TabFunktionsautopilotStruktur
    Kontext "Funktionsautopilot"
    call DialogTest2 ( FunktionsAutopilot,3 )
    Funktionsautopilot.Cancel
    '/// Leave function assistant with cancel
Call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertFunctionList
Dim categoryCount as Integer
Dim categoryIndex as Integer
Dim listLength as Integer
Dim listIndex as Integer

call hNewDocument
    Kontext "FunctionsCalc"
    if FunctionsCalc.Exists(2) then
        printlog "Functions List was already open"
    else
        InsertFunctionList
        printlog "Functions list will now be invoked"
    end if 
    Kontext "FunctionsCalc"  
    if FunctionsCalc.IsDocked then
        printlog "Found Functions docked - now undocking"
        FunctionsCalc.Undock
        sleep(2)
    else
        printlog "Functions was already undocked"
    end if    
    categoryCount = Category.GetItemCount
    printlog "Categories: " & categoryCount     
    for categoryIndex = 1 to categoryCount
        Category.Select(categoryIndex)
        listlength = FunctionList.GetItemCount
        printlog "There are: " & listLength & " Items in category: " & Category.GetSelText
        for listIndex = 1 to listlength
            FunctionList.Select(listIndex)
            call Dialogtest ( FunctionsCalc )
        next listIndex
    next categoryIndex     
    FunctionsCalc.Dock
    InsertFunctionList
call hCloseDocument
endcase   
'
'---------------------------------------------------------------------------
'
testcase tInsertNamesDefine
  Call hNewDocument
      InsertNamesDefine
      Kontext "NamenFestlegen"
      Zusaetze.Click
      DialogTest ( NamenFestlegen )
      NamenFestlegen.Cancel
  Call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertNamesInsert
Call hNewDocument
    InsertNamesInsert
    Kontext "NamenEinfuegen"
    Call DialogTest ( NamenEinfuegen )
    NamenEinfuegen.Cancel
Call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertNamesCreate
Call hNewDocument
    InsertNameCreate
    Kontext "NamenErzeugen"
    DialogTest ( NamenErzeugen )
    NamenErzeugen.Cancel
Call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertNamesLabels
Call hNewDocument
    InsertNamesLabels
    Kontext "BeschriftungsbereichFestlegen"
    DialogTest ( BeschriftungsbereichFestlegen )
    BeschriftungsbereichFestlegen.Cancel
Call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertNote
Call hNewDocument
    InsertNoteCalc
    Kontext
    DocumentCalc.TypeKeys "Energie"
    DocumentCalc.MouseDoubleClick 50,50
Call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertSpecialCharacter
Call hNewDocument
    printlog "*** If the test crashes by calling the menuitem 'InsertSpecialCharacterCalc', it is bug:98975"
    InsertSpecialCharacterCalc
    Kontext "Sonderzeichen"
    DialogTest ( Sonderzeichen )
    Sonderzeichen.Cancel
Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tInsertHyperlink
Dim i as integer
printlog "- Insert / Hyperlink"
Call hNewDocument
    '/// Create a new spreadsheet document
    printlog "-  Internet"
    '/// Insert / Hyperlink
    InsertHyperlink
    '///  In 'Hyperlink' dialog step through all pages
    Call sInsertHyperlink(1)
    Call DialogTest(TabHyperlinkInternet)
    Kontext "Hyperlink"
    printlog "-  Mail & News"
    Call sInsertHyperlink(2)
    wait 500
    Call DialogTest(TabHyperlinkMailUndNews)
    Kontext "Hyperlink"
    printlog "-  Document"
    Call sInsertHyperlink(3)
    wait 500
    Call DialogTest(TabHyperlinkDokument)
    if gUseSysDlg = False then
        DateiOeffnen.Click
        sleep(1)
        Kontext "OeffnenDlg"
        OeffnenDlg.Cancel
        sleep(1)
    end if
    Kontext "Hyperlink"
    printlog "-  New Document"
    Call sInsertHyperlink(4)
    wait 500
    Call DialogTest(TabHyperlinkNeuesDokument)
    if gUseSysDlg = False then
        Pfad.Click
        sleep(1)
        Kontext "OeffnenDlg"
        OeffnenDlg.Cancel
    end if
    Kontext "TabHyperlinkNeuesDokument"
    '/// Close 'Hyperlink' dialog
    TabHyperlinkNeuesDokument.Cancel    
'/// Close the document    
Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tInsertGraphicFromFile
Call hNewDocument
    InsertGraphicsFromFile
    Kontext "GrafikEinfuegenDlg"
    Link.Check
    Preview.Check
    Dateiname.Settext convertpath(gTesttoolpath + "global\input\graf_inp\krokodil.wmf")
    Oeffnen.click
Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tInsertMovieAndSound
'///<u><b>Insert / Movie and Sound...</b></u>
'/// Create a new spreadsheet document
Call hNewDocument
    '/// Insert / Movie and Sound...
    InsertMovieAndSound
    '/// Check file open dialog and Close it (TRUE)
    call subTestFileOpenDialog ( TRUE )
    '/// Close document
Call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertChart
'/// File / New / Spreadsheet
Call hNewDocument
    '/// Insert / Chart
    InsertChart
    '/// The test case has been passed if the chart wizard dialog occours and...
    Kontext "ChartWizard"
    if ChartWizard.Exists(1) then
        Call Dialogtest(ChartWizard)
        '/// ...after clicking on OK button the chart is being embedded into the spreadsheet.
        ChartWizard.OK
    else
        warnlog "Chart wizard did not occour!"
        Call hCloseDocument
        goto endsub
    endif
'/// File / Close and discard the changes.    
Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tInsertFormula
Call hNewDocument
    InsertObjectFormulaCalc
    Kontext "DocumentCalc"
    DocumentCalc.MouseDoubleClick(50,50)
Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tInsertFrame
Call hNewDocument
    InsertFloatingFrame
    Kontext "TabEigenschaften"
    Dialogtest (TabEigenschaften)
    TabEigenschaften.Cancel
Call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertObjectOLE
call hNewDocument
    InsertObjectOLEObject
    Kontext "OLEObjektEinfuegen"
    if Objekttyp.getitemcount < 0 then warnlog "There are no OLE-Objects in the listbox"
    NeuErstellen.Check
    Call DialogTest2 (OLEObjektEinfuegen, 1)
    AusDateierstellen.Check
    Call DialogTest2 (OLEObjektEinfuegen, 2)
    OLEObjektEinfuegen.Cancel
call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertObjectPlugin
call hNewDocument
    InsertObjectPlugIn
    Kontext "PlugInEinfuegen"
    Call DialogTest (PlugInEinfuegen)
    DurchSuchen.Click
    Kontext "OeffnenDLG"
    OeffnenDlg.Cancel
    Kontext "PluginEinfuegen"
    PlugInEinfuegen.Cancel
call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
sub sInsertHyperlink(iWhichPage as integer)
'/// Sub routine for selecting the different
'///+ tab pages inside the Hyperlink dialog.
    Kontext "Hyperlink"
    Auswahl.MouseDown(2,2)
    Auswahl.MouseUp(2,2)
    wait 500
    Auswahl.TypeKeys("<DOWN>",1)
    wait 500
    Auswahl.TypeKeys("<UP>",4)
    sleep(1)
    select case iWhichPage
        case 1:
                '/// Internet tab page
                Kontext "TabHyperlinkInternet"
        case 2:
                '/// Mail & News Tab page
                Auswahl.TypeKeys("<DOWN>",1)
                Kontext "TabHyperlinkMailUndNews"
        case 3:
                '/// Document tab page
                Auswahl.TypeKeys("<DOWN>",2)
                Kontext "TabHyperlinkDokument"
        case 4:
                '/// New document tab page
                Auswahl.TypeKeys("<DOWN>",3)
                Kontext "TabHyperlinkNeuesDokument"
    end select
end sub

