'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: validity.bas,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: jsi $ $Date: 2007/12/05 13:47:00 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'**
'** owner : joerg.sievers@Sun.COM
'**
'** short description : extensive test for the validity functionality
'**
'\***********************************************************************

sub main
    dim iOldSecLevel as integer
    
    PrintLog "---------------------------------------------------------------------"
    Printlog "-----                    Calc test validity                     -----"
    PrintLog "---------------------------------------------------------------------"

    use "calc\special\inc\caco3\validity.inc"
    use "calc\tools\c_select_tools.inc"
    use "calc\special\inc\caco3\validity_tools.inc"
    
    'Get the security level and set it lower
    iOldSecLevel = fGetSetMacroSecurityUNO(1)
    if iOldSecLevel <> -1 then 
        printlog "The current Macro security level of " & iOldSecLevel & " will be restored after the test has been finished."
    else
        warnlog "Setting the macro security level failed. Aborting!"
        exit sub
    end if
    Call hStatusIn("Calc", "Validity.bas", "Test for data validity")
        call tValidity_Check_Message
        call tValidity_Check_Excel        
    Call hStatusOut
    if fGetSetMacroSecurityUNO(iOldSecLevel) <> -1 then
        printlog "Old macro security level has been restored."
    else
        warnlog "Old macro security level could not be set back!"
    end if
end sub
'
'-------------------------------------------------------------------------------
'
sub LoadIncludeFiles
    use "global\system\inc\master.inc"
    use "global\system\inc\gvariabl.inc"
    gApplication   = "Calc"
    Call GetUseFiles
end sub
