'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_chinesetranslate2.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/13 11:40:36 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Chinese Dictionary test
'*
'************************************************************************
'*
' #1 tChineseTranslate_6         'Chinese dictionary : S Chinese to T Chinese
' #1 tChineseTranslate_7         'Chinese dictionary : T Chinese to S Chinese
' #1 tChineseTranslate_8         'Chinese dictionary : Reverse mapping
' #1 tChineseTranslate_9         'Chinese dictionary : Add
' #1 tChineseTranslate_10        'Chinese dictionary : Modify
' #1 tChineseTranslate_11        'Chinese dictionary : Delete
' #1 tUndoRedo                   'Undo/Redo
'*
'\***********************************************************************

testcase tChineseTranslate_6

  Dim sTerm , sMapping as  String

  sTerm    = "蓝国"
  sMapping = "紙間"

  printlog "Chinese dictionary , S Chinese to T Chinese"
 '/// <b>  Chinese dictionary , S Chinese to T Chinese </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(86))

  '/// Input a test term
   Kontext "DocumentCalc"
   DocumentCalc.typeKeys sTerm

  '/// Tools/language / Chinese translation ,
  '/// Check "Simplified Chinese to Traditional Chinese"
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     SChineseToTChinese.Check

  '/// Check "Translate Common Terms"
     TranslateCommonTerms.Check

  '/// Press 'Edit Terms' button
     EditTerms.Click
     Kontext "ChineseDictionary"

    '/// Click radiobutton 'Simplified Chinese to Tradtional Chinese'
       SChineseToTChinese.Check

    '/// Add test word in Term and Mapping
       Term.SetText    sTerm
       Mapping.SetText sMapping
       Add.Click
     ChineseDictionary.OK
     Sleep 4
   Kontext "ChineseTranslation"
   ChineseTranslation.OK

  '/// Check if the result is correct
   if cZellwert("A1")  <> sMapping then  warnlog "#118246# A1 isn't right !"

  'Recover to default
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     EditTerms.Click
     Kontext "ChineseDictionary"
       SChineseToTChinese.Check
       SToTMappingContent.Select SToTMappingContent.GetItemCount
       sleep(1)
       Delete.Click
     ChineseDictionary.OK
     sleep(2)
   Kontext "ChineseTranslation"
   ChineseTranslation.Cancel

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tChineseTranslate_7

  Dim sTerm , sMapping as  String

  sTerm    = "紙間"
  sMapping = "蓝国"

  printlog "Chinese dictionary , T Chinese to S Chinese"
 '/// <b> Chinese dictionary , T Chinese to S Chinese </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(88))

  '/// Input a test term
   Kontext "DocumentCalc"
   DocumentCalc.typeKeys sTerm

  '/// Tools/language / Chinese translation ,
  '/// Check "Traditional Chinese to Simplified Chinese"
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     TChineseToSChinese.Check

  '/// Check "Translate Common Terms"
     TranslateCommonTerms.Check

  '/// Press 'Edit Terms' button
     EditTerms.Click
     Kontext "ChineseDictionary"

    '/// Click radiobutton 'Tradtional Chinese to Simplified Chinese'
       TChineseToSChinese.Check

    '/// Add test word in Term and Mapping
       Term.SetText    sTerm
       Mapping.SetText sMapping
       Add.Click
     ChineseDictionary.OK
     Sleep 4
   Kontext "ChineseTranslation"
   ChineseTranslation.OK

  '/// Check if the result is correct
   if cZellwert("A1")  <> sMapping then  warnlog "#118246# A1 isn't right !"

  'Recover to default
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     EditTerms.Click
     Kontext "ChineseDictionary"
       TChineseToSChinese.Check
       TToSMappingContent.Select TToSMappingContent.GetItemCount
       sleep(1)
       Delete.Click
     ChineseDictionary.OK
     sleep(2)
   Kontext "ChineseTranslation"
   ChineseTranslation.Cancel

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tChineseTranslate_8

  Dim sTerm , sMapping as  String

  sTerm    = "蓝国"
  sMapping = "紙間"

  printlog "Chinese dictionary , Reverse mapping"
 '/// <b> Chinese dictionary , Reverse mapping </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(88))

  '/// Input a test term
   Kontext "DocumentCalc"
   DocumentCalc.typeKeys sMapping

  '/// Tools/language / Chinese translation ,
  '/// Check "Traditional Chinese to Simplified Chinese"
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     TChineseToSChinese.Check

  '/// Check "Translate Common Terms"
     TranslateCommonTerms.Check

  '/// Press 'Edit Terms' button
     EditTerms.Click
     Kontext "ChineseDictionary"

    '/// Click radiobutton 'Simplified Chinese to Tradtional Chinese'
       SChineseToTChinese.Check

    '/// Check 'Reverse Mapping'
       ReverseMapping.Check

    '/// Add test word in Term and Mapping
       Term.SetText    sTerm
       Mapping.SetText sMapping
       Add.Click
     ChineseDictionary.OK
     Sleep 4
   Kontext "ChineseTranslation"
   ChineseTranslation.OK

  '/// Check if the result is correct
   if cZellwert("A1")  <> sTerm then  warnlog "#118246# A1 isn't right !"

  'Recover to default
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     EditTerms.Click
     Kontext "ChineseDictionary"
       TChineseToSChinese.Check
       ReverseMapping.Check
'       SToTMappingContent.Select SToTMappingContent.GetItemCount
       sleep(1)
       Delete.Click
     ChineseDictionary.OK
     sleep(2)
   Kontext "ChineseTranslation"
   ChineseTranslation.Cancel

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tChineseTranslate_9

  Dim sTerm1 , sMapping1 , sMapping2 as  String
  Dim i                              as  Integer

  sTerm1    = "Term1"
  sMapping1 = "Mapping1" :  sMapping2 = "Mapping2"

  printlog "Chinese dictionary : Add"
 '/// <b> Chinese dictionary : Add </b>

  Call hNewDocument

  '/// Tools/language / Chinese translation ,
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"

  '/// Press 'Edit Terms' button
     EditTerms.Click
     Kontext "ChineseDictionary"
       TChineseToSChinese.Check

    '/// Check if term is empty , Add button should be inactive
       try
           Add.Click
           warnlog "- term is empty , Add button should be inactive !"
       catch
       endcatch

    '/// Input test word in Term(A) and Mapping(B) , press Add
       Term.SetText    sTerm1
       Mapping.SetText sMapping1
       Add.Click

    '/// Input test word in Term(A) and Mapping(C) , press Add
       Term.SetText    sTerm1
       Mapping.SetText sMapping2

    '/// Check if term text is unaltered , Add button should be inactive
       try
           Add.Click
           warnlog "- term text is unaltered , Add button should be inactive !"
       catch
       endcatch

     ChineseDictionary.Cancel
   Kontext "ChineseTranslation"
   ChineseTranslation.Cancel

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tChineseTranslate_10

  Dim sTerm1 , sMapping1 , sMapping2 as  String
  Dim i                              as  Integer

  sTerm1    = "Term1"
  sMapping1 = "Mapping1" :  sMapping2 = "Mapping2"

  printlog "Chinese dictionary : Modify"
 '/// <b> Chinese dictionary : Modify </b>

  Call hNewDocument

  '/// Tools/language / Chinese translation ,
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"

  '/// Press 'Edit Terms' button
     EditTerms.Click
     Kontext "ChineseDictionary"
       TChineseToSChinese.Check

    '/// Input test word in Term(A) and Mapping(B) , press Add
       Term.SetText    sTerm1
       Mapping.SetText sMapping1
       Add.Click

    '/// Input test word in Mapping(C) and select another property ,
    '/// + then press Modify
       Mapping.SetText sMapping2
       Property.Select 3
       sleep(1)
       Modify.Click

    '/// Check if modification is correct
       TToSMappingContent.Select TToSMappingContent.GetItemCount
       if Term.GetText <> sTerm1 then
           warnlog "Should get " & sTerm1 & " but get " & Term.GetText
       end if
       if Mapping.GetText <> sMapping2 then
           warnlog "Should get " & sMapping2 & " but get " & Mapping.GetText
       end if
       if Property.GetSelIndex <> 3 then
           warnlog "Property is NOT correct!"
       end if
     ChineseDictionary.Cancel
   Kontext "ChineseTranslation"
   ChineseTranslation.Cancel

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tChineseTranslate_11

  Dim sTerm1 , sMapping1 , sTerm2 as  String
  Dim i                           as  Integer

  sTerm1    = "Term1"    : sTerm2 = "Term2"
  sMapping1 = "Mapping1"

  printlog "Chinese dictionary : Delete"
 '/// <b> Chinese dictionary : Delete </b>

  Call hNewDocument

  '/// Tools/language / Chinese translation ,
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"

  '/// Press 'Edit Terms' button
     EditTerms.Click
     Kontext "ChineseDictionary"
       TChineseToSChinese.Check

    '/// Input test word in Term(A) and Mapping(B) , press Add
       Term.SetText    sTerm1
       Mapping.SetText sMapping1
       Add.Click

    '/// Input test word in Term(C), check if Delete button is active
       Term.SetText sTerm2
       try
           Delete.Click
           warnlog "Delete button should be inactive !"
       catch
       endcatch
     ChineseDictionary.Cancel

   Kontext "ChineseTranslation"
   ChineseTranslation.Cancel

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tUndoRedo

  Dim sChinese1 , sExpect1  as  String
  Dim sChinese2 , sExpect2  as  String

  sChinese1 = "红上"  :  sChinese2 = "蓝国" 
  sExpect1  = "紅上"  :  sExpect2  = "藍國"  

  printlog "Undo/Redo"
 '/// <b> Undo/Redo </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(86))

  '/// Input some simplified chinese
   Kontext "DocumentCalc"
   DocumentCalc.typeKeys sChinese1
   DocumentCalc.typeKeys "<Right>"
   DocumentCalc.typeKeys sChinese2

  '/// Tools/language / Chinese translation , check
  '/// + "Simplified Chinese to Traditional Chinese" , press OK
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     SChineseToTChinese.Check
   ChineseTranslation.OK

  '/// Edit/Undo
   printlog "Undo"
   EditUndo
   if cZellwert("A1")  <> sChinese1 then  warnlog "#i34769#  A1 isn't right ! " & cZellwert("A1")
   if cZellwert("B1")  <> sChinese2 then  warnlog "#i34769#  B1 isn't right !"  & cZellwert("B1")

   printlog "Redo"
  '/// Edit/Redo
   EditRedo
   if cZellwert("A1")  <> sExpect1 then  warnlog "#i34769#  A1 isn't right ! "  & cZellwert("A1")
   if cZellwert("B1")  <> sExpect2 then  warnlog "#i34769#  B1 isn't right ! "  & cZellwert("B1") 

  Call hCloseDocument

endcase

'-----------------------------------------------------------------
