'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: fkt_test.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: jsi $ $Date: 2007/07/23 05:52:05 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description : Test for all 'classical SO 5.2' functions
'*
'************************************************************************
'*
' #1 tAllFunctions    ' Check if all functions deliver correct results
' #1 tInsertFunction  ' Create one function with the autopilot
'*
'\***********************************************************************

testcase tAllFunctions
'/// This testcase load the documents: (gTesttoolpath & "input\calc\functions\functions.sxc"),
'/// (gTesttoolpath & "input\calc\functions\addin_german.sdc"), (gTesttoolpath & "input\calc\functions\addin_other.sdc")
'/// which contains the results from all functions in starcalc. ///
'/// This results are compare with reference values ///

    Dim i as integer
    Dim sFunction_file as string 
    Dim sCell as string

    sFunction_file = convertpath(gTesttoolpath & "calc\special\input\functions.sxc")
    
    Call hDateioeffnen(sFunction_file)
        Kontext
        if Active.exists(2) then 
            Active.Yes
        endif
        printlog "Execute hard Recalc..."
        DocumentCalc.typekeys "<MOD1 SHIFT F9>"
        printlog "... and look, if all values are zero"
        Kontext
        Kontext "DocumentCalc"
        if cgotocell("D1") <> 0 then
            warnlog "Traveling to D1 failed! Exiting test!"
            goto endsub
        end if
        i = 0
        For i = 2 to 261
            if i = 29 AND iSystemsprache <> 01 then
               QAErrorLog "Cell D29 will only be tested on locales en_US"
               i = i + 1
            end if
            sCell = "D" & i
            call checkcellwert(sCell, 0)
        next i
        printlog " There has been " + i + " functions checked"
    Call hCloseDocument
endcase
'
'-------------------------------------------------------------------------------
'
testcase tAddinOld
    Dim sAddin_german 
    Dim sAddin_Other as string 
    Dim sCell as string

    sAddin_german = convertpath(gTesttoolpath & "calc\special\input\addin_german.sdc")
    sAddin_Other = convertpath(gTesttoolpath & "calc\special\input\addin_other.sdc")

    printlog "* Checking the addins *"

    If iSystemSprache <> 49 then
        hDateiOeffnen(sAddin_Other)
    else
        hDateiOeffnen(sAddin_german)
    end if
        Printlog "Execute hard recalc ..."
        Kontext "DocumentCalc"    
        DocumentCalc.typekeys "<MOD1 SHIFT F9>"
        sleep(2)
        printlog "... and look, if the values are zero"
        Kontext
        For i = 2 to 9
                    sCell = "D" & i
                    call checkcellwert(sCell, 0)
        Next i
    call hCloseDocument    
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertFunction
'/// This testcase checks if the function "coth(1,2)" has as result '1,2'. ///
'/// The function is created with the formula autopilot. ///
    dim sFktName as string
    dim sDecimalTestString as string
     
    printlog "* Insert Function"
    select case iSprache
        case 01   : sFktName = "COTH"
        case 03   : sFktName = "COTH"
        case 07   : sFktName = "COTH"
        case 31   : sFktName = "COTH"
        case 33   : sFktName = "COTH"
        case 34   : sFktName = "COTH"
        case 39   : sFktName = "COTH"
        case 45   : sFktName = "COTH"
        case 46   : sFktName = "COTH"
        case 48   : sFktName = "COTH"
        case 49   : sFktName = "COTHYP"
        case 55   : sFktName = "COTH"
        case 81   : sFktName = "COTH"
        case 82   : sFktName = "COTH"
        case 86   : sFktName = "COTH"
        case 88   : sFktName = "COTH" 'Chinese traditional
        case else : QAErrorLog "No Case for Language Code " & iSprache & " defined"
                    goto endsub
    end select
    Call  hNewDocument()
        sDecimalTestString = "1" & getDecimalSeperator & "2"
        Kontext "RechenleisteCalc"
        if RechenleisteCalc.isvisible <> FALSE then            
            ViewToolbarsFormulaBar
        end if
        InsertFunction
        Kontext "FunktionsAutoPilot"        
        printlog "Systemlanguage :" & iSystemsprache
        Kategorie.Select(8)
        Funktion.Select(sFktName)
        weiter.Click
        Kontext "FunktionsAutoPilot"
        Funktionsbutton1.Click
        Kontext "FunktionsAutoPilot"
        Kategorie.Select(8)
        Funktion.Select(sFktName)
        weiter.Click
        Kontext "FunktionsAutoPilot"
        Editfeld1.settext(sDecimalTestString)
        FunktionsAutoPilot.Ok
        if cZellwert ("A1") = sDecimalTestString then
            printlog "Functionresult with the autopilot OK"
        else
            warnlog "Autopilot doesn't work"
        end if
        Kontext "DocumentCalc"
        if cgotocell("A1") <> 0 then
            warnlog "Traveling to A1 failed! Exiting test!"
            goto endsub
        end if
        InsertFunction
        Kontext "FunktionsAutoPilot"
        if FunktionsAutoPilot.Exists then
            if Editfeld1.gettext = sFktName & "(" & sDecimalTestString & ")" then
                Weiter.Click
                if Editfeld1.gettext = sDecimalTestString then
                    printlog " The function autopilot shows the correct nested formula"
                    FunktionsAutoPilot.Ok
                else
                    warnlog " The second editfield of the nested formula has false contents "
                    FunktionsAutoPilot.Cancel
                end if
            else
                warnlog " The editfield has a false content"
                FunktionsAutoPilot.Cancel
            end if
        else
            warnlog " Autopilot hasn't started"
        end if
    Call hCloseDocument
endcase

