'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: b_lvl1_Addressbook_Mozilla.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: msc $ $Date: 2007/09/28 12:57:49 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : marc.neumann@sun.com
'*
'* short description : Address book mozilla
'*
'************************************************************************
'*
' #1 b_lvl1_Addressbook_Mozilla
' #1 tQueryAddressbook
' #1 tSortAddressbook
'*
'\***********************************************************************
sub b_lvl1_Addressbook_Mozilla

    ' Information for this test under
    ' http://wiki.services.openoffice.org/wiki/Database_Automatic_Testing#Testing_the_mozilla_Address_book

    if fCreateMozillaAddressbookDatasource(gOfficePath + ConvertPath("user/work/TT_Mozilla.odb")) then
        
        tQueryAddressbook(gOfficePath + ConvertPath("user/work/TT_Mozilla.odb"))
        tSortAddressbook(gOfficePath + ConvertPath("user/work/TT_Mozilla.odb"))
        
    endif
    
end sub
'-------------------------------------------------------------------------
testcase tQueryAddressbook( sFileName )
    
    if ( not fOpenDatabase(sFileName) ) then        
        warnlog "Database can't be open"
        printlog "May be you find a solution under http://wiki.services.openoffice.org/wiki/Database_Automatic_Testing#Testing_the_mozilla_Address_book"
        goto endsub
    endif
    
    fOpenNewQueryDesign
        
    Kontext "AddTables"    
        TableName.Select 1        
        '/// Add database table to Query.
        AddTable.Click
        sleep(2) 
        if AddTables.exists(2) then 
            CloseDlg.Click ' When the AddTables dialog still exists then close him
        endif
        sleep(1)        
    Kontext "QueryDesignCriterion"                           
        Field.Select(1)
        sleep(1)                
    Kontext "Toolbar"
        '/// Executing query
        printlog "- Executing query"
        ExecuteBtn.Click
        sleep(5)
    Kontext "TableView"
        if NOT DataWindow.Exists(3) then
            warnlog "Execution of a query failed!"
        end if

    call fCloseQueryDesign()

    call fCloseDatabase()
    
endcase
'-------------------------------------------------------------------------
testcase tSortAddressbook( sFileName )
    
    Dim sRecordCount as String
    
    '/// open the database file created in the bas file
    printlog "open the database file created in the bas file"
    
    if ( not fOpenDatabase(sFileName) ) then        
        warnlog "Database can't be open"
        goto endsub
    endif
    
    '/// open the first table
    printlog "open the first table"    
    Kontext "ContainerView"
        ViewTables
        TableTree.select(1)
        OpenTable ' uno-Slot .uno:DB/Open
    
    sleep(2)

    '/// count the records in the table
    printlog "count the records in the table"
    Kontext "TableView"
        LastRecord.Click
        sRecordCount = AllRecords.caption()
    
    '/// sort the table
    printlog "sort the table"
    Kontext "Toolbar"
        SortAscending.Click
        sleep(1)
    
    '/// count the table again and check if there are the same count of records then before sorting
    printlog "count the table again and check if there are the same count of records then before sorting"        
    Kontext "TableView"
        LastRecord.Click
        if (sRecordCount <> AllRecords.caption() ) then
            warnlog "issue i61611 occur. The records are double after sorting."
        endif

    '/// close the table
    printlog "close the table"    
    call fCloseTableView()
    
    '/// close the database
    printlog "close the database"
    call fCloseDatabase()

endcase
