// $Id: openmsx.hh 6787 2007-08-04 11:34:21Z m9710797 $

#ifndef OPENMSX_HH
#define OPENMSX_HH

// don't just always include this, saves about 1 minute build time!!
#ifdef DEBUG
#include <iostream>
#endif

/// Namespace of the openMSX emulation core.
/** openMSX: the MSX emulator that aims for perfection
  *
  * Copyrights: see AUTHORS file.
  * License: GPL.
  */
namespace openmsx {

/** 4 bit integer */
typedef unsigned char nibble;

/** 8 bit signed integer */
typedef signed char signed_byte;
/** 8 bit unsigned integer */
typedef unsigned char byte;

/** 16 bit signed integer */
typedef short signed_word;
/** 16 bit unsigned integer */
typedef unsigned short word;

/** 32 bit signed integer */
typedef int int32;
/** 32 bit unsigned integer */
typedef unsigned uint32;

/** 64 bit signed integer */
typedef long long int64;
/** 64 bit unsigned integer */
typedef unsigned long long uint64;

#ifdef DEBUG

#define PRT_DEBUG(mes)				\
	do {					\
		std::cout << mes << std::endl;	\
	} while (0)

#else

#define PRT_DEBUG(mes)

#endif

} // namespace openmsx

#endif
