.\" Copyright (c)  2000, Amnon BARAK (amnon@cs.huji.ac.il)
.\" All rights reserved.
.\"
.\"	MOSIX $Id: mosctl.man,v 1.7 2001/03/06 01:32:57 amnons Exp $
.\"
.\" Permission to use, copy and distribute this software is hereby granted
.\" under the terms of version 2 or any later version of the GNU General
.\" Public License, as published by the Free Software Foundation.
.\"
.\" THIS MANUAL IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY
.\" WHATSOEVER. NO LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING
.\" FROM THE USE OF THIS MANUAL WILL BE ACCEPTED.
.\"
.Dd May 16, 1999
.Dt MOSCTL 1
.ds vT MOSIX Reference Manual
.Os MOSIX
.Sh NAME
.Nm \&mosctl
.Nd MOSIX system administrator's tools
.Sh SYNOPSIS
.Nm \&mosctl
{
.Pa stay
|
.Pa nostay
|
.Pa lstay
|
.Pa nolstay
|
.Pa block
|
.Pa noblock
|
.Pa quiet
|
.Pa "       "noquiet
|
.Pa nomfs
|
.Pa mfs
|
.Pa expel
|
.Pa bring
|
.Pa gettune
|
.Pa getyard
|
.Pa getdecay
}
.Nm \&mosctl
.Pa whois
[
.Pa MOSIX-ID
|
.Pa IP-address
|
.Pa hostname
]
.Nm \&mosctl
{
.Pa getload
|
.Pa getspeed
|
.Pa status
|
.Pa isup
|
.Pa getmem
|
.Pa getfree
|
.Pa getutil
}
[
.Pa MOSIX-ID
]
.Nm \&mosctl
.Pa setyard
[
.Pa processor-type
|
.Pa number
|
.Pa this
]
.Nm \&mosctl
.Pa setspeed numeric-value
.Nm \&mosctl
.Pa setdecay interval slow fast
.Sh DESCRIPTION
.Nm \&Mosctl
provides a variety of MOSIX system-administration and information tools.
.Pp
.Pa stay
prevents automatic migration of processes out from the current node.
.Pa nostay
or
.Pa -stay
cancels the effect of
.Pa stay.
.Pp
.Pa lstay
prevents only local processes from migrating away automatically, but still
allows remote/guest processes to do so.
.Pa nolstay
or
.Pa -lstay
cancels the effect of
.Pa lstay.
.Pp
.Pa block
prevents remote/guest processes from arriving in.
.Pa noblock
or
.Pa -block
cancels the effect of
.Pa block.
.Pp
.Pa quiet
stops the background activity of the node providing other nodes
with its load-information.
.Pa noquiet
or
.Pa -quiet
cancels the effect of
.Pa quiet.
.Pp
.Pa nomfs
disables access to this node's files via the MFS file-system (if configured).
.Pa mfs
re-enables access to this node's files via MFS.
.Pp
.Pa expel
sends away all remote/guest processes.  It does not return until all
remote/guest processes were evacuated (or until interrupted).
It also acts as
.Pa block,
preventing new remote/guest processes from arriving.
.Pp
.Pa bring
brings back to the node all processes that are running away from it.
It does not return until all processes were brought back (or until interrupted).
It also acts as
.Pa lstay
in preventing local processes from migrating away automatically.
.Pp
.Pa getdecay
displays the current decay parameters, which control the gradual decay of
old process-statistics for the use of load-balancing.
Every given number of seconds, only a given portion of the statistics is kept.
That portion is different for slow-decaying (the default) and for fast-decaying
processes.
.sp
.Pa setdecay
loads a new set of decay parameters:

* Interval in seconds.
.br
* How much out of 1000 to keep for slow-decaying processes.
.br
* How much out of 1000 to keep for fast-decaying processes.

The
.Pa interval
must be within the range of 1-65535, the
.Pa slow
and
.Pa fast
parameters must be in the range of 0-1000 and the
.Pa slow
parameter must be greater or equal than the
.Pa fast
parameter.
.Pp
.Pa gettune
displays the overhead parameters used by the kernel to estimate the "I/O factor"
in its load-balancing.  These paramters are:
.Bl -tag -width sigignore -compact

.It * Deputy overhead in processing a demand-page
.It * Remote overhead in processing a demand-page
.It * Deputy overhead in processing a system call
.It * Remote overhead in processing a system call
.It * Basic deputy overhead for reading data
.It * Deputy overhead per 1KB read
.It * Basic remote overhead for reading data
.It * Remote overhead per 1KB read
.It * Basic deputy overhead for writing data
.It * Deputy overhead per 1KB written
.It * Basic remote overhead for writing data
.It * Remote overhead per 1KB written
.It * Migration time of an empty process
.It * Extra migration time per dirty page
.El

All integers express microseconds.
.Pp
.Pa getyard
displays the
.Pa yardstick
in use.  This is the processor-speed of the most typical MOSIX node.
By default, it is 10000 speed-units, representing a Pentium-III at 1GHz.
.Pa setyard
sets the
.Pa yardstick
according to the argument, which can be either numeric (speed-units), the word
"this", implying the node's own processor-speed, or the name of a
recognised processor, such as:
.Br
386/33, 486/66, Pentium/133 (or p/133), ppro/200, pII/300 (or Pentium2/300),
pIII/1000, PIV/1400.
.Pp
the processor names are case-insensitive and the '/' may also be replaced
by '-' or '_'.
.Pp
.Pa whois
converts MOSIX-ID numbers to current IP addresses and vice-versa (See
.Pa setpe(1)).
If given an integer, it assumes a MOSIX-ID and displays the corresponding
IP-address.  If given an IP address (a.b.c.d), it converts it to a MOSIX-ID.
If given a hostname that is either listed in
.Pa /etc/hosts
or deteceted by named(8), it finds its IP addresses and converts it to a
MOSIX-ID.  Without a second argument, the local node's MOSIX-ID is
displayed.
.Pp
.Pa getload
displays the load on the given
.Pa MOSIX-ID
(or the current node if the second argument is missing).  Although the
load is a rather complex function, under normal conditions, a load of 100
represents one process, constantly requiring the CPU on a node with a
.Pa yardstick
processor-speed.  On faster processors, the load caused by a similar process
would be less than 100 and accordingly, on slower processors it would be more
than 100.
.Pp
.Pa getspeed
displays the processor speed of the given
.Pa MOSIX-ID
(or the current node if the second argument is missing).  The speed
is relative to a Pentium-III at 1GHz being 10000 units.
.Pp
.Pa getmem
(or
.Pa memory
or
.Pa mem)
displays the logically-free and total memory on the given
.Pa MOSIX-ID
(or the current node if the second argument is missing).  The free
memory may not necessarily correspond with "vmstat(8)", as it also takes other
factors into account.
.Pp
.Pa getfree
(or
.Pa getrawmem
or
.Pa rawfree)
displays the raw free and total memory on the given
.Pa MOSIX-ID
(or the current node if the second argument is missing).  The free
memory should correspond with "vmstat(8)".
.Pp
.Pa getutil
displays the processor utilizability percentage on the given
.Pa MOSIX-ID
(or the current node if the second argument is missing).
This means how much of the time
either the node is serving some process, or there are no processes
on that node waiting for swapped-pages.  Under normal operating
conditions on a single-processor node, utilizability should be 100%,
dropping only when the memory is being pressured.  On SMPs, the
utilizability should be 100% times the number of processors.
.Pp
.Pa status
(or
.Pa stat)
displays whether the given
.Pa MOSIX-ID
node (or the current node if the second argument is missing) is
up and connected, and whether any of the following conditions described above
is set on that node: "stay", "lstay", "block" or "quiet".
.Pp
.Pa isup
responds whether the node specified by
.Pa MOSIX-ID
is running and connected or not.
.Pp
.Pa setspeed
overrides the node's idea of its own speed.  The speed must still be
defined so that a Pentium-III at 1GHz yields 10000 units, but this option
is provided to allow for systems that always run the same (or very similar)
computation-intensive application, for which the ratio of the speeds between
different processors is other than with the mixed benchmark used by MOSIX.
.Sh SEE ALSO
.Xr mosix 7 ,
.Xr setpe 1 ,
.Xr tune 1 ,
.Xr mon 1 ,
.Xr mosrun 1 ,
.Xr migrate 1 .
.Sh HISTORY
.Pa mosctl
is a MOSIX utility.  It was previously known under the name of "dist".
