;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 2001 Clozure Associates
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;

;;; "Generic" syscall sypport.

(in-package "CCL")

(defstruct syscall
  (idx 0 :type fixnum)
  (arg-specs () :type list)
  (result-spec nil :type symbol)
  (min-args 0 :type fixnum))

(defmacro define-syscall (name idx (&rest arg-specs) result-spec
			       &key (min-args (length arg-specs)))
  `(progn
    (setf (gethash ',name (ftd-syscalls *target-ftd*))
     (make-syscall :idx ,idx
      :arg-specs ',arg-specs :result-spec ',result-spec :min-args ,min-args))
    ',name))

(defmacro syscall (name &rest args)
  (let* ((info (or (gethash name (ftd-syscalls *target-ftd*))
		   (error "Unknown system call: ~s" name)))
	 (idx (syscall-idx info))
	 (arg-specs (syscall-arg-specs info))
	 (n-argspecs (length arg-specs))
	 (n-args (length args))
	 (min-args (syscall-min-args info))
	 (result (syscall-result-spec info)))
    (unless (and (>= n-args min-args) (<= n-args n-argspecs))
      (error "wrong number of args in ~s" args))
    (do* ((call ())
	  (specs arg-specs (cdr specs))
	  (args args (cdr args)))
	 ((null args)
	  `(%syscall ,idx ,@(nreverse (cons result call))))
      (push (car specs) call)
      (push (car args) call))))
