;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;

;; prepare-mcl-environment.lisp
;; Load this into a PPCCL to make it into an MCL-PPC for shipping


(in-package :ccl)

; enable redefine-kernel-function's error checking
(setq *warn-if-redefine-kernel* t)

; Set the frozen bits so that redefine-kernel-function
; will error if a builtin function is redefined.
(do-all-symbols (s)
  (when (fboundp s)
    (%symbol-bits s (bitset $sym_fbit_frozen (%symbol-bits s)))))

; Set the top-level *package* to the CL-USER package
#+ppc-target
(do-db-links (db var)
  (when (eq var '*package*)
    (setf (%fixnum-ref db 8) (find-package :cl-user))))

#-ppc-target
(defun make-all-methods-kernel ()
  (%map-lfuns #'(lambda (f)
                  (when (typep f 'generic-function)
                    (let ((smc *standard-method-class*))
                      (dolist (method (generic-function-methods f))
                        (when (eq (class-of method) smc)
                          (let ((f (%method-function method)))
                            (lfun-attributes f
                                             (bitset $lfatr-kernel-bit
                                                     (lfun-attributes f)))))))))))



; Force an error if a kernel method is redefined.
(make-all-methods-kernel)



