;;-*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;

;(in-package "CCL")

(eval-when (:compile-toplevel :execute)
  (require "SPARC-ARCH")
  (require "SPARC-LAPMACROS"))

;;; %BIGNUM-REF needs to access bignums as obviously as possible, and it needs
;;; to be able to return 32 bits somewhere no one looks for real objects.
;;;
;;; The easiest thing to do is to store the 32 raw bits in two fixnums
;;; and return multiple values.

(defsparclapfunction %bignum-ref ((bignum %arg_y) (i %arg_z))
  (vref32 bignum i %imm1 %imm0)
  (digit-h %imm0 %temp0)
  (digit-l %imm0 %temp1)
  (vpush %temp0)
  (vpush %temp1)
  (add %vsp 8 %temp0)                      
  (jump-subprim .SPvalues)
    (set-nargs 2))

(defsparclapfunction %bignum-ref-hi ((bignum %arg_y) (i %arg_z))
  (add i arch::misc-data-offset %imm1)
  (lduh (bignum %imm1) %imm0)
  (retl)
    (box-fixnum %imm0 %arg_z))

(defsparclapfunction %bignum-set ((bignum 0)
				  (i %arg_x)
				  (high %arg_y)
				  (low %arg_z))
  (compose-digit high low %imm0)
  (ld (%vsp bignum) %arg_z)
  (vset32 %imm0 %arg_z i %imm1)
  (retl)
    (add %vsp 4 %vsp))

;;; %ADD-WITH-CARRY -- Internal.
;;;
;;; This should be in assembler, and should not cons intermediate results.  It
;;; returns a 32bit digit (split in half) and a carry resulting from adding 
;;; together the a, b, and an incoming carry.
;;;



; this is silly 
(defsparclapfunction %add-the-carry ((b-h %arg_x) (b-l %arg_y) (carry-in %arg_z))
  (let ((a %imm0)
        (b %imm1)
        (temp %imm2)
        (c %imm3))    
    (compose-digit b-h b-l b)
    (unbox-fixnum carry-in c)
    (add b c b)
    (digit-h b %temp0)
    (digit-l b %temp1)
    (vpush %temp0)
    (vpush %temp1)
    (add %vsp 8 %temp0)
    (jump-subprim .SPvalues)
      (set-nargs 2)))

(defsparclapfunction %subtract-one ((a-h %arg_y)(a-l %arg_z))
  (let ((a %imm0))
    (compose-digit a-h a-l a)
    (sub a 1 a)
    (digit-h a %temp0)
    (vpush %temp0)
    (digit-l a %temp0)
    (vpush %temp0)
    (add %vsp 8 %temp0)
    (jump-subprim .spvalues)
      (set-nargs 2)))

;;; %MULTIPLY -- Internal.
;;;
;;; This multiplies two digit-size (32-bit) numbers, returning a 64-bit result
;;; split into two 32-bit quantities.
;;; Or, as fate would have it, into 4 16-bit quantities
;;;


; given 2 fixnums, returns product as 4 16 bit dohickies
(defsparclapfunction %multiply-signed-fixnums ((x %arg_y)(y %arg_z))
  (let ((x-un %imm0)
        (y-un %imm1)
        (res-h %imm2)
        (res-l %imm3))
    (unbox-fixnum x x-un)
    (unbox-fixnum y y-un)
    (smul x-un y-un res-l)
    (digit-h res-l %temp2)
    (digit-l res-l %temp3)
    (rdy res-h)
    (digit-h res-h %temp0)
    (digit-l res-h %temp1)
    (vpush %temp0)
    (vpush %temp1)
    (vpush %temp2)
    (vpush %temp3)
    (set-nargs 4)
    (jump-subprim .SPvalues)
      (add %vsp 16 %temp0)))

;;; %MULTIPLY-AND-ADD  --  Internal.
;;;
;;; This multiplies x-digit and y-digit, producing high and low digits
;;; manifesting the result.  Then it adds the low digit, res-digit, and
;;; carry-in-digit.  Any carries (note, you still have to add two digits at a
;;; time possibly producing two carries) from adding these three digits get
;;; added to the high digit from the multiply, producing the next carry digit.
;;; Res-digit is optional since two uses of this primitive multiplies a single
;;; digit bignum by a multiple digit bignum, and in this situation there is no
;;; need for a result buffer accumulating partial results which is where the
;;; res-digit comes from.
;;; [slh] I assume that the returned carry "digit" can only be 0, 1 or 2


(defsparclapfunction %multiply-and-add ((x-high 8)
					(x-low 4)
					(y-high 0)
					(y-low %arg_x)
					(carry-in-high %arg_y)
					(carry-in-low %arg_z))
  (let ((x %imm0)
	(y %imm1)
	(carry-in %imm2)
	(lo %imm3)
	(hi %imm4))
    (compose-digit carry-in-high carry-in-low carry-in)
    (vpop %temp0)
    (compose-digit %temp0 y-low y)
    (vpop %temp0)
    (vpop %temp1)
    (compose-digit %temp1 %temp0 x)
    (umul x y lo)
    (addcc lo carry-in lo)
    (digit-h lo %temp2)
    (digit-l lo %temp3)
    (rdy hi)
    (addx hi 0 hi)
    (digit-h hi %temp0)
    (digit-l hi %temp1)
    (vpush %temp0)
    (vpush %temp1)
    (vpush %temp2)
    (vpush %temp3)
    (set-nargs 4)
    (jump-subprim .SPvalues)
      (add %vsp '4 %temp0)))


; return carry-hi carry-lo (= halves of prod-h) - no don't just store it at len
(defsparclapfunction %multiply-and-add-loop ((Bignum 0)(res %arg_x)(len %arg_y) (x-box %arg_z))
  (let ((x %imm0)
        (idx %imm1)
        (big %temp0)
        ;(res %temp1)
        (count %temp2)
        (prod-h %imm2)
        (prod-l %imm3)
        (y %imm4))
    (unbox-fixnum x-box x)
    (mov arch::misc-data-offset idx)
    (mov 0 count)
    (ld (%vsp bignum) big)
    (mov 0 prod-h) ; init de carry
    @loop
    (ld (big idx) y)               ; get digit
    (umul x y prod-l)             ; times x to prod-l
    (addcc prod-l prod-h prod-l)    ; add last prod-h with carry out
    (nop)
    (nop)
    (rdy prod-h)            ; high times x to prod-h    
    (addx prod-h %rzero prod-h)     ; add carry out to prod-h    
    (st prod-l (res idx))    
    (add count '1 count)
    (cmp count len)
    (bl @loop)
      (add idx '1 idx)
    (st prod-h (res idx))
    (retl)
      (add %vsp 4 %vsp)))


;; multiply i'th digit of x by y and add to result starting at digit i
(defsparclapfunction %multiply-and-add-harder-loop-2 ((x-ptr 4) (y-ptr 0)
                                                    (resptr %arg_x)(residx %arg_y) (count %arg_z))  
  (let ((tem %imm0)
        (y %imm1)
        (prod-h %imm2)
        (prod-l %imm3)
        (x %imm4)
        (xptr %temp2)
        (yidx %temp1)
        (yptr %temp0))
    (ld (%vsp x-ptr) xptr)
    (add residx arch::misc-data-offset tem)
    (ld (xptr tem) x)
    (ld (%vsp y-ptr) yptr)
    (mov 0 yidx) ; init yidx 0 
    (addcc %rzero %rzero prod-h) ; init carry 0, mumble 0
    @loop
    (add yidx arch::misc-data-offset tem)   ; get yidx
    (ld (yptr tem) y)
    (umul x y prod-l)
    (addcc prod-l prod-h prod-l)
    (nop)
    (nop)
    (rdy prod-h)
    (addx prod-h %rzero prod-h)
    (add residx arch::misc-data-offset tem)
    (ld (resptr tem) y)    
    (addcc prod-l y prod-l)
    (addx prod-h %rzero prod-h)
    (st prod-l (resptr tem))    
    (subcc count '1 count)
    (add residx '1 residx)
    (add yidx '1 yidx)
    (bg @loop)
    (add residx arch::misc-data-offset tem)
    (st prod-h (resptr tem))
    (retl)
      (add %vsp 8 %vsp)))



(defsparclapfunction %logcount ((high %arg_y) (low %arg_z))
  (let ((arg %imm0)
        (shift %imm1)
        (temp %imm2))
    (compose-digit high low arg)
    (movcc arg shift)
    (be @done)
      (mov 0 %arg_z)
    @loop
    (add shift -1 temp)
    (andcc shift temp shift)
    (bne @loop)
      (add %arg_z '1 %arg_z)
    @done
    (retl)
      (nop)))

; return res
(defsparclapfunction bignum-add-loop-2 ((aptr %arg_x)(bptr %arg_y) (result %arg_z))
  (let ((idx %imm0)
        (count %imm1)
        (x %imm2)
        (y %imm3)
	(carry %imm4)
        (len-a %temp0)
        (len-b %temp1)
        (tem %temp2))
    (mov arch::misc-data-offset idx)    
    (ld (aptr arch::misc-header-offset) %imm4)
    (header-length %imm4 len-a)
    (ld (bptr arch::misc-header-offset) %imm4)
    (header-length %imm4 len-b)
    ; make a be shorter one
    (cmp len-a len-b)
    (mov 0 count)
    ; initialize carry 0
    (ble @loop)
      (addcc %rzero %rzero carry)
    ; b shorter - swap em
    (mov len-a tem)
    (mov len-b len-a)
    (mov tem len-b)
    (mov aptr tem)
    (mov bptr aptr)
    (mov tem bptr)    
    @loop
    (ld (aptr idx) y)
    (ld (bptr idx) x)    
    (add count '1 count)
    (addcc carry -1 %rzero)
    (addxcc x y x)
    (addx %rzero %rzero carry)
    (cmp count len-a)
    (st x (result idx))
    (bl @loop)
      (add idx '1 idx)

    ;; now propagate carry thru longer (b) using sign of shorter    
    ;;(SUB idx '1 %imm4) ; y has hi order word of a
    ;;(ld (aptr %imm4) y)
    (cmp len-a len-b) 
    (be @l3)  ; unless equal
      (sra y 31 y)
    @loop2
    (ld (bptr idx) x)
    (addcc carry -1 %rzero)
    (addxcc x y x)
    (addx %rzero %rzero carry)
    (st x (result idx))
    (add count '1 count)
    (cmp count len-b)
    (bl @loop2)
      (add idx '1 idx)
    ; y has sign of shorter - get sign of longer to x
    @l3
    (sub idx '1 count)
    (ld (bptr count) x)
    (sra x 31 x) 
    (addcc carry -1 %rzero)
    (addx x y x)
    (retl)
      (st x (result idx))))

;; same as above but with initial a index and finishes
(defsparclapfunction bignum-add-loop-+ ((init-a 0)(aptr %arg_x)(bptr %arg_y)(length %arg_z))
  (let ((idx %imm0)        
        (count %imm1)
        (x %imm2)
        (y %imm3)
        (aidx %imm4))
    (mov arch::misc-data-offset idx)
    (ld (%vsp init-a) aidx)
    (add aidx arch::misc-data-offset aidx)
    (mov 0 count)
    ; initialize carry 0
    (addcc %rzero %rzero x)
    @loop
    (ld (aptr aidx) x)
    (ld (bptr idx) y)
    (addx x y x)
    (st x (aptr aidx))
    (add count '1 count)
    (cmp count length)
    (add idx '1 idx)
    (bl @loop)
      (add aidx '1 aidx)

    (ld (aptr aidx) x)  ; add carry into next one
    (addx x %rzero  x)
    (st x (aptr aidx))
    (retl)
      (add %vsp 4 %vsp)))


(defsparclapfunction %subtract-with-borrow ((a-h 4)
					    (a-l 0)
					    (b-h %arg_x)
					    (b-l %arg_y)
					    (borrow-in %arg_z))
  (let ((a-digit %imm0)
	(b-digit %imm1)
	(borrow %imm3)
	(result-digit %imm4))
    (unbox-fixnum borrow-in borrow)
    (compose-digit b-h b-l b-digit)
    (ld (%vsp a-l) %temp1)
    (ld (%vsp a-h) %temp0)
    (inc '2 %vsp)
    (compose-digit %temp0 %temp1 a-digit)
    (subcc borrow 1 %rzero)
    (subxcc a-digit b-digit result-digit)
    (addx %rzero %rzero borrow)
    (xor borrow 1 borrow)
    (box-fixnum borrow %arg_z)
    (digit-h result-digit %arg_x)
    (digit-l result-digit %arg_y)
    (vpush %arg_x)
    (vpush %arg_y)
    (vpush %arg_z)
    (set-nargs 3)
    (jump-subprim .SPvalues)
      (add %vsp '3 %temp0)))

    



(defsparclapfunction bignum-negate-loop-really ((big %arg_x) (len %arg_y) (result %arg_z))
  (let ((idx %imm0)
        (one %imm1)
        (x %imm2))
    (mov arch::misc-data-offset idx)
    (mov '1 one)
    ; initialize carry 1
    (mov -1 x)
    (addcc x 1 x)
    @loop        
    ;(add count '1 count)    
    ;(cmp count len)
    (subcc len one len)
    (ld (big idx) x)
    (not x x)
    (addx x %rzero x)
    (st x (result idx))    
    (bg @loop)
      (add idx '1 idx)
      
    ; return carry
    (mov 0 x)
    (addx x %rzero  x)
    (retl)
      (box-fixnum x %arg_z)))

;; she do tolerate len = jidx
(defsparclapfunction bignum-shift-left-loop ((nbits 4)(result 0) (bignum %arg_x) (len %arg_y) (jidx %arg_z))
  (let ((y %imm0)
        (idx %imm1)
        (bits %imm2)
        (rbits %imm3)
        (x %imm4)
        (iidx %temp0)
        (resptr %temp1))
    (mov 0 iidx)
    (ld (%vsp nbits) bits)
    (ld (%vsp result) resptr)
    (unbox-fixnum bits bits)
    (mov 32 rbits)
    (sub rbits bits rbits)
    ;(dbg)
    (ld (bignum arch::misc-data-offset) %imm4)
    (sll %imm4 bits %imm4)
    (add jidx (+ arch::misc-data-offset -4) y)  
    (st %imm4 (y resptr)) 
     
    (cmp len jidx)
    (be @done)
      (nop)
    @loop
    (add iidx arch::misc-data-offset idx)
    (ld (bignum idx) x)
    (srl x rbits x)
    (add idx '1 idx)
    (ld (bignum idx) y)
    (sll y bits y)
    (or x y x)
    (add jidx arch::misc-data-offset idx)
    (st x (resptr idx))
    (add jidx '1 jidx)    
    (cmp jidx len)
    (bl @loop)
      (add iidx '1 iidx)    
    @done
    ; do first - lo order
       
    ; do last - hi order    
    (add iidx arch::misc-data-offset idx)
    ;(dbg t)
    (ld (bignum idx) y)
    (sra y rbits y)
    (add len arch::misc-data-offset idx)
    (st y (resptr idx))
    (retl)
      (add %vsp 8 %vsp)))



(defsparclapfunction bignum-shift-right-loop-1 ((nbits 4)(result 0) (bignum %arg_x) (len %arg_y) (iidx %arg_z))
  (let ((y %imm0)
        (idx %imm1)
        (bits %imm2)
        (rbits %imm3)
        (x %imm4)
        (jidx %temp0)
        (resptr %temp1))
    (mov 0 jidx)
    (ld (%vsp nbits) bits)
    (ld (%vsp result) resptr)
    (unbox-fixnum bits bits)
    (cmp jidx len)
    (mov 32 rbits)
    (bge @done)
      (sub rbits bits rbits)
    @loop
    (add iidx arch::misc-data-offset idx)
    (ld (bignum idx) x)
    (srl x bits x)
    (add idx '1 idx)
    (ld (bignum idx) y)
    (sll y rbits y)
    (or x y x)
    (add jidx arch::misc-data-offset idx)
    (st x (resptr idx))
    (add jidx '1 jidx)    
    (cmp jidx len)
    (bl @loop)
      (add iidx '1 iidx)
    @done
    (add iidx arch::misc-data-offset idx)
    (ld (bignum idx) x)
    (sra x bits x)
    (add jidx arch::misc-data-offset idx)
    (st x (resptr idx))
    (retl)
      (add %vsp 8 %vsp)))

(defsparclapfunction bignum-compare-loop ((a %arg_x) (b %arg_y) (len %arg_z))
  (let ((x %imm0)
        (y %imm1)
        (idx %imm2))
    (add len arch::misc-header-offset idx)
    @loop
    (ld (a idx) x)
    (ld (b idx) y)
    (cmp x y)
    (bg @gt)
      (nop)
    (bl @lt)
      (deccc '1 idx)
    (cmp idx arch::misc-data-offset)
    (bge @loop)
      (nop)
    (retl)   ; was all =
      (mov 0 %arg_z)
    @gt
    (retl)
      (mov '1 %arg_z)
    @lt
    (retl)
      (mov '-1 %arg_z)))

;; returns number of bits in digit-hi,digit-lo that are sign bits
;; 32 - digits-sign-bits is integer-length
(defsparclapfunction %digits-sign-bits ((hi %arg_y) (lo %arg_z))
  (unbox-fixnum lo %imm0)
  (sll hi (- 16 arch::fixnumshift) %imm1)
  (or %imm1 %imm0 %imm1)
  (tst %imm1)
  (mov '32 %arg_y)
  (bge @test)
    (clr %arg_z)
  (b @test)
    (not %imm1 %imm1)
  @loop
  (inc '1 %arg_z)
  @test
  (tst %imm1)
  (bne @loop)
    (srl %imm1 1 %imm1)
  (retl)
    (sub %arg_y %arg_z %arg_z))

(defsparclapfunction bignum-logtest-loop ((count %arg_x) (s1 %arg_y) (s2 %arg_z))  
  (add %rzero arch::misc-data-offset %imm1)
  @loop
  (ld (s1 %imm1) %imm2)
  (ld (s2 %imm1) %imm3)
  (andcc %imm2 %imm3 %imm2)  
  (bne @true)
    (add %imm1 4 %imm1)
  (subcc count 4 count)
  (bg  @loop)
    (nop)
  (retl)
    (mov %rnil %arg_z)
  @true
  (retl)
    (add %rnil arch::t-offset %arg_z))

(defsparclapfunction bignum-not-loop ((count %arg_x) (s1 %arg_Y) (dest %arg_z))
  ;(ld (%vsp count) %imm0)
  (add %rzero arch::misc-data-offset %imm1)
  @loop
  (ld (s1 %imm1) %imm2)
  (not %imm2 %imm2)
  (subcc count 4 count)
  (st %imm2 (dest %imm1))
  (bg @loop)
    (add %imm1 4 %imm1)
  @out  
  (retl)
    (nop))

(defsparclapfunction bignum-and-loop ((count 0) (s1 %arg_x) (s2 %arg_y) (dest %arg_z))
  (ld (%vsp count) %imm0)
  (add %rzero arch::misc-data-offset %imm1)
  @loop
  (ld (s1 %imm1) %imm2)
  (ld (s2 %imm1) %imm3)
  (and %imm2 %imm3 %imm2)
  (subcc %imm0 4 %imm0)
  (st %imm2 (dest %imm1))
  (bg @loop)
    (add %imm1 4 %imm1)
  @out
  (retl)
    (add %vsp 4 %vsp))

(defsparclapfunction bignum-andc2-loop ((count 0) (s1 %arg_x) (s2 %arg_y) (dest %arg_z))
  (ld (%vsp count) %imm0)
  (add %rzero arch::misc-data-offset %imm1)
  @loop
  (ld (s1 %imm1) %imm2)
  (ld (s2 %imm1) %imm3)
  (andn %imm2 %imm3 %imm2)
  (subcc %imm0 4 %imm0)
  (st %imm2 (dest %imm1))
  (bg @loop)
    (add %imm1 4 %imm1)
  @out
  (retl)
    (add %vsp 4 %vsp))

(defsparclapfunction bignum-andc1-loop ((count 0) (s1 %arg_x) (s2 %arg_y) (dest %arg_z))
  (ld (%vsp count) %imm0)
  (add %rzero arch::misc-data-offset %imm1)
  @loop
  (ld (s1 %imm1) %imm2)
  (ld (s2 %imm1) %imm3)
  (andn %imm3 %imm2 %imm2)
  (subcc %imm0 4 %imm0)
  (st %imm2 (dest %imm1))
  (bg @loop)
    (add %imm1 4 %imm1)
  @out
  (retl)
    (add %vsp 4 %vsp))

(defsparclapfunction digit-lognot-move ((index %arg_x) (source %arg_y) (dest %arg_z))
  (let ((scaled-index %imm1))
    (vref32 source index scaled-index %imm0) ; %imm1 has c(index) + data-offset
    (not %imm0 %imm0)
    (retl)
      (st %imm0 (dest scaled-index))))

; if dest not nil store unboxed result in dest(0), else return boxed result
(defsparclapfunction fix-digit-logandc2 ((fix %arg_x) (big %arg_y) (dest %arg_z)) ; index 0
  (let ((w1 %imm0)
        (w2 %imm1))
    (unbox-fixnum  fix w1)
    (ld (big arch::misc-data-offset) w2)
    (cmp dest %rnil)
    (bne @store)
      (andn w1 w2 w1)
    (retl)
      (box-fixnum w1 %arg_z)
    @store
    (retl)
      (st w1 (dest arch::misc-data-offset))))

(defsparclapfunction fix-digit-logand ((fix %arg_x) (big %arg_y) (dest %arg_z)) ; index 0
  (let ((w1 %imm0)
        (w2 %imm1))
    (unbox-fixnum  fix w1)
    (ld (big arch::misc-data-offset) w2)
    (cmp dest %rnil)
    (bne @store)
      (and w1 w2 w1)
    (retl)
      (box-fixnum w1 %arg_z)
    @store
    (retl)
      (st w1 (dest arch::misc-data-offset))))

(defsparclapfunction fix-digit-logandc1 ((fix %arg_x) (big %arg_y) (dest %arg_z)) ; index 0
  (let ((w1 %imm0)
        (w2 %imm1))
    (unbox-fixnum  fix w1)
    (ld (big arch::misc-data-offset) w2)
    (cmp dest %rnil)
    (bne @store)
      (andn w2 w1 w1)
    (retl)
      (box-fixnum w1 %arg_z)
    @store
    (retl)
      (st w1 (dest arch::misc-data-offset))))

(defsparclapfunction bignum-ior-loop ((count 0) (s1 %arg_x) (s2 %arg_y) (dest %arg_z))
  (ld (%vsp count) %imm0)
  ;(cmp %imm0 %rzero)
  (add %rzero arch::misc-data-offset %imm1)
  ;(be @out)
  @loop
  (ld (s1 %imm1) %imm2)
  (ld (s2 %imm1) %imm3)
  (or %imm2 %imm3 %imm2)
  (subcc %imm0 4 %imm0)
  (st %imm2 (dest %imm1))
  (bg @loop)
    (add %imm1 4 %imm1)
  @out
  (retl)
    (add %vsp 4 %vsp))

(defsparclapfunction bignum-xor-loop ((count 0) (s1 %arg_x) (s2 %arg_y) (dest %arg_z))
  (ld (%vsp count) %imm0)
  (add %rzero arch::misc-data-offset %imm1)
  @loop
  (ld (s1 %imm1) %imm2)
  (ld (s2 %imm1) %imm3)
  (xor %imm2 %imm3 %imm2)
  (subcc %imm0 4 %imm0)
  (st %imm2 (dest %imm1))
  (bg @loop)
    (add %imm1 4 %imm1)
  @out
  (retl)
    (add %vsp 4 %vsp))



;; x0 is at index, x1 at index-1, x2 at index-2
;; y1 is at index, y2 at index-1
;; this doesnt help much
(defsparclapfunction truncate-guess-loop ((guess-h 8)(guess-l 4)(x 0)
                                        (xidx %arg_x)(yptr %arg_y) (yidx %arg_z))
  (let ((guess %imm0)
        (y1 %imm1)
        (y2 %imm1)
        (gy1-lo %imm2) ; look out below
        (gy1-hi %imm2)
        (gy2-lo %imm2)
        (gy2-hi %imm2)
        (xptr %temp0)
        (m %imm3)
        (tem %imm4)
        (y1-idx 28)
        (y2-idx 24)
        (x0-idx 20)
        (x1-idx 16)
        (x2-idx 12))
    (stwu %tsp -32 %tsp)
    (st %tsp (%tsp 4))
    (ld (%vsp guess-h) y1)
    (ld (%vsp guess-l) tem)
    (compose-digit y1 tem guess)
    (add yidx arch::misc-data-offset tem)
    (ld (yptr tem) y1)
    (st y1 (%tsp y1-idx))
    (sub tem 4 tem)
    (ld (yptr tem) y2)
    (st y2 (%tsp y2-idx))
    (ld (%vsp x) xptr)
    (add xidx arch::misc-data-offset tem)
    (ld (xptr tem) y1) ; its x0
    (st y1 (%tsp x0-idx))
    (sub tem 4 tem)
    (ld (xptr tem) y1)
    (st y1 (%tsp x1-idx))
    (sub tem 4 tem)
    (ld (xptr tem) y1)
    (st y1 (%tsp x2-idx))
    @loop
    (ld (%tsp y1-idx) y1)     ; get y1
    (umul guess y1 gy1-lo)
    (ld (%tsp x1-idx) m)      ; get x1
    (subcc m gy1-lo m)      ; x1 - gy1-lo => m
    (nop)
    (rdy gy1-hi)
    (ld (%tsp x0-idx) tem)    ; get x0
    (subxcc tem gy1-hi tem)      ; - val not used just cr
    (ld (%tsp y2-idx) y2)     ; get y2
    (umul guess y2 %rzero)
    (nop)
    (nop)
    (nop)
    (rdy gy2-hi)   ; does it pay to do this now even tho may not need?
    (bne @done)
      (cmp gy2-hi m)       ; if > or = and foo then more 
    (blu @done)           ; if < done
      (nop)
    (bne @more)           ; if = test lo
      (nop)
    (umul guess y2 gy2-lo)
    (ld (%tsp x2-idx) tem) ; get x2
    (cmp gy2-lo tem)
    (bleu @done)
      (nop)
    @more
    (b @loop)
      (sub guess 1 guess)
    @done
    (digit-h guess %temp0)
    (vpush %temp0)
    (digit-l guess %temp0)
    (vpush %temp0)
    (add %vsp 20 %temp0)
    (ld (%tsp 0) %tsp)
    (jump-subprim .spvalues)
      (set-nargs 2)))

(defsparclapfunction normalize-bignum-loop ((sign %arg_x)
					    (res %arg_y)
					    (len %arg_z))
  (let ((idx %imm0)
        (usign %imm1)
        (val %imm2))      
    (unbox-fixnum sign usign)
    (cmp len 0)
    (be @done)   ; huh - can this ever happen?
      (add len (- arch::misc-data-offset 4) idx)
    @loop
    (ld (res idx) val)
    (cmp  val usign)    
    (bne @neq)
      (sub idx '1 idx)    
    (subcc len '1 len)
    (bg @loop)
      (nop)
    
    ; fall through - its all sign - return 1
    (retl)
      (mov '1 %arg_z)
    @neq
    (srl usign 31 usign)
    (sll usign 31 usign)
    (srl val 31 val)
    (sll val 31 val)
    (cmp usign val)  ; is hi bit = sign, if so then done   
    (bne.a @done)
      (add len '1 len) ; if not, need 1 more
    @done
    (retl)
      (nop)))

(defsparclapfunction %normalize-bignum-2 ((fixp %arg_y)(res %arg_z))
  (let ((idx %imm0)
        (usign %imm1)
        (val %imm2)
        (len %arg_x)
        (oldlen %temp0))
    (ld (res (- arch::fulltag-misc)) %imm4)
    (header-length %imm4 len)
    (cmp len 0)
    (mov len oldlen)
    (be @done)
      (add len (- arch::misc-data-offset 4) idx) ; huh - can this ever happen?
    (ld (res idx) val) ; high order word
    (sra val 31 usign) ; get sign
    @loop
    (ld (res idx) val)
    (cmp  val usign)    
    (bne @neq)
      (sub idx '1 idx)    
    (subcc len '1 len)
    (bg @loop)
      (nop)
    ; fall through - its all sign - return 1
    (mov '1 len)
    (sra usign 31 usign)
    (b @more)
      (sll usign 31 usign) ; preserve hi bit

    @neq
    (sra usign 31 usign)
    (sll usign 31 usign) ; preserve hi bit
    (sra val 31 val)
    (sll val 31 val) ; preserve hi bit
    (cmp usign val)  ; is hi bit = sign, if so then done   
    (be @more)
      (nop)
    (b @big) ; if not, need 1 more
      (add len '1 len)
    @more
    (cmp fixp %rnil)
    (be  @big)  ; dont return fixnum
      (cmp len '1)
    (bg @big)
      (nop)
    ;; stuff for maybe fixnum
    ;(dbg t)
    ;(ta sparc::trap-breakpoint)
    (ld (res arch::misc-data-offset) val)
    (sethi (ash #xe0000000 -10) %imm4)
    (and val %imm4 %imm4)  ; hi 3 bits same? - we assume fixnumshift is 2
    (sra usign 2 usign)
    (cmp usign %imm4)
    (bne @big)
      (nop)
    (retl)
      (box-fixnum val %arg_z)
    @big
    (cmp oldlen len)
    (be @done) ; same length - done
      (nop)
    (sll len (- arch::num-subtag-bits arch::fixnumshift) %imm4)
    (bset arch::subtag-bignum %imm4)
    (st %imm4 (res arch::misc-header-offset))
    ; 0 to tail if negative
    (cmp usign 0)
    (be @done) 
     ; zero from len inclusive to oldlen exclusive
    (add len arch::misc-data-offset idx)
    @loop2
    (st %rzero (idx res))
    (add len '1 len)
    (cmp len oldlen)
    (bl @loop2)
      (add idx '1 idx)
    @done
    (retl)
      (nop)))

