/*
 * 2bit_munger.c --
 *
 *      Munge common image formats down to 2 bpp
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *  Munge common image formats down to 2 bpp
 *
 *  Ian Goldberg
 */

#include "gif2grey.h"
/*#include "jpg2grey.h"*/
#include "ditpic.h"
#include <stdio.h>
#include <string.h>

#define Message(x) fprintf(stderr, "2bit munger: %s\n", (x))


/*#include <stdio.h>
static void dump(u_char *bytes, int len)
{
	static FILE *fp=NULL;
	if (fp==NULL) {
		fp = fopen("tgmb.2bit.dump", "w");
	}
	fwrite(bytes, 1, len, fp);
	fflush(fp);
}*/


void
Init2BitMunger()
{
	gif2grey_init();
	/*jpg2grey_init();*/
}


/*
 * caller must invoke Free2bit(void *data) to free the output buffer
 */
Bool
ConvertTo2Bit(int scalePercent, unsigned char *data, int len,
	      unsigned char **out, int *outLen)
{
	Bool isGif=FALSE;
	Bool status;
	unsigned char *grey, *tbmp;
	int rows, cols;
	int orows, ocols, orsize;

	if (strncmp(data, "GIF", 3)==0) isGif = TRUE;

	/* Convert various input image formats to a greyscale array */
	if (!isGif) {
		/*status = jpg2grey_main(data, len, &grey, &cols, &rows);*/
	} else {
		status = gif2grey_main(data, len, &grey, &cols, &rows);
	}

	if (!status) {
		Message("image conversion failed");
		return status;
	}

	/* Now that we have the greyscale, convert it to a 2-bit Pilot bitmap*/

	/* First get the requested output size; default is full size */
	ocols = (cols * scalePercent)/100;
	orows = (rows * scalePercent)/100;

	/* The number of bytes used for each row (must be even) */
	orsize = ((ocols+7)/8)*2;

	/* Allocate space and write the preamble */
	tbmp = malloc(16 + orows * orsize);
	if (!tbmp) {
		Message("ran out of memory");
		return FALSE;
	}
	*(unsigned short *)(tbmp) = htons((unsigned short) (ocols*2));
	*(unsigned short *)(tbmp+2) = htons((unsigned short) orows);
	*(unsigned short *)(tbmp+4) = htons((unsigned short) orsize);
	*(unsigned short *)(tbmp+6) = 0;
	*(unsigned long *)(tbmp+8) = 0;
	*(unsigned long *)(tbmp+12) = 0;

	ditpic(grey, cols, rows, tbmp+16, ocols, orows, 0.75);

	/* Finish up */
	free(grey);
	*outLen = 16 + orows * orsize;
	*out = tbmp;
	return TRUE;
}


void
Free2Bit(void *data)
{
	free(data);
}
