# tp.tcl --
#
#       Object for spoofing room 405 touch panel pushes (not complete)
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import DpClient

namespace eval TouchPanel {
    variable mappings
}

Class TouchPanel

TouchPanel instproc init {base} {
    $self instvar amx_

    set amx_ [new DpClient htsr.bmrc.berkeley.edu 6901]

    set TouchPanel::mappings(pcToProj) 136
    set TouchPanel::mappings(vcrToProj) 137
    set TouchPanel::mappings(elmoToProj) 138
    set TouchPanel::mappings(laptopToProj) 139
    set TouchPanel::mappings(sgiToProj) 140

    set TouchPanel::mappings(projOn) 150
    set TouchPanel::mappings(projOff) 151
    set TouchPanel::mappings(mute) 141
    set TouchPanel::mappings(volumeUp) 142
    set TouchPanel::mappings(volumeDown) 143
#    set TouchPanel::mappings(


    $self initUI $base
}

TouchPanel instproc initUI {base} {

    frame $base.switch -borderwidth 3
    pack $base.switch -side top -fill x

    set curFrame $base.switch

    button $curFrame.pcToProj -text "pcToProj" -command "$self simulateButtonPush pcToProj"
    pack $curFrame.pcToProj -side top
    button $curFrame.vcrToProj -text "vcrToProj" -command "$self simulateButtonPush vcrToProj"
    pack $curFrame.vcrToProj -side top
    button $curFrame.elmoToProj -text "elmoToProj" -command "$self simulateButtonPush elmoToProj"
    pack $curFrame.elmoToProj -side top
    button $curFrame.laptopToProj -text "laptopToProj" -command "$self simulateButtonPush laptopToProj"
    pack $curFrame.laptopToProj -side top
    button $curFrame.sgiToProj -text "sgiToProj" -command "$self simulateButtonPush sgiToProj"
    pack $curFrame.sgiToProj -side top

    set curFrame $base.projOnOff
    frame $curFrame -borderwidth 3
    pack $curFrame -side top -fill x

    button $curFrame.on -text "Proj On" -command "$self simulateButtonPush projOn"
    pack $curFrame.on -side top
    button $curFrame.off -text "Proj Off" -command "$self simulateButtonPush projOff"
    pack $curFrame.off -side top

    set curFrame $base.volume
    frame $curFrame -borderwidth 3
    pack $curFrame -side top -fill x

    button $curFrame.mute -text "Mute" -command "$self simulateButtonPush mute"
    pack $curFrame.mute -side top

    button $curFrame.up -text "Volume Up" -command "$self simulateButtonPush volumeUp"
    pack $curFrame.up -side top
    button $curFrame.down -text "Volume Down" -command "$self simulateButtonPush volumeUp"
    pack $curFrame.down -side top
}

TouchPanel instproc simulateButtonPush {button} {
    $self instvar amx_

    switch -exact -- $button {
	pcToProj -
	vcrToProj -
	elmoToProj -
	laptopToProj -
	sgiToProj -
	projOn -
	projOff -
	mute -
	volumeUp -
	volumeDown {
	    set device 129
	    set channel $TouchPanel::mappings($button)
	}
	default {
	    return ""
	}
    }

#    puts stdout "device=$device, channel=$channel"

    $amx_ do send-AMX-command 6 $device $channel
    $amx_ do spoofResponse 6 $device $channel ""
    after 300
    $amx_ do send-AMX-command 7 $device $channel
    $amx_ do spoofResponse 7 $device $channel ""
}
