# dcc.tcl --
#
#      Test app for testing DcClient and DC RPC API
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import DpClient DcClient

Class DcClientApp

DcClientApp instproc init {hostname port} {
    $self instvar dcc_

    set dcc_ [new DcClient $hostname $port]

    $self initUI ""
}

DcClientApp instproc initUI {base} {

    wm title . "DC Client"
    wm minsize . 150 0

    button .thumbInfo -text "ThumbInfo" -command "$self getThumbInfo"
    pack .thumbInfo -side top
    button .pvInfo -text "PreviewInfo" -command "$self getPreviewInfo"
    pack .pvInfo -side top
    button .bcInfo -text "BroadcastInfo" -command "$self getBroadcastInfo"
    pack .bcInfo -side top
    button .pvAll -text "PreviewAll" -command "$self previewAll"
    pack .pvAll -side top
    button .bcAll -text "BroadcastAll" -command "$self broadcastAll"
    pack .bcAll -side top
    button .clearAll -text "ClearAll" -command "$self clearAll"
    pack .clearAll -side top

    button .test -text "Test" -command "$self test"
    pack .test -side top

    button .exit -text "Exit" -command "exit"
    pack .exit -side bottom
}

DcClientApp instproc getThumbInfo {} {
    $self instvar dcc_

    set retVal [$dcc_ getThumbnailInfo]
    puts stdout "dcApi_getThumbnailInfo returns $retVal"
}

DcClientApp instproc getPreviewInfo {} {
    $self instvar dcc_

    set retVal [$dcc_ getPreviewInfo]
    puts stdout "dcApi_getPreviewInfo returns $retVal"
}

DcClientApp instproc getBroadcastInfo {} {
    $self instvar dcc_

    set retVal [$dcc_ getBroadcastInfo]
    puts stdout "dcApi_getBroadcastInfo returns $retVal"
}

DcClientApp instproc previewAll {} {
    $self instvar dcc_

    $dcc_ previewAll
}


DcClientApp instproc broadcastAll {} {
    $self instvar dcc_

    $dcc_ broadcastAll
}

DcClientApp instproc clearAll {} {
    $self instvar dcc_

    $dcc_ clearAll
}


DcClientApp instproc test {} {
    $self instvar dcc_

    $dcc_ unbroadcastHost "htsr.bmrc.berkeley.edu"
}


# main program

set hostname "garfield.cs.berkeley.edu"
set port 6907
set dcc [new DcClientApp $hostname $port]



vwait forever
