# application-qm.tcl --
#
#       Creates a QuestionMonitor app.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import Application QuestionMonitor DpClient

namespace eval QuestionMonitorApplication {
    variable self
}

Class QuestionMonitorApplication -superclass Application

QuestionMonitorApplication instproc init { argv } {
    $self instvar qm_ serv_ port_

    $self next "qm"

    set QuestionMonitorApplication::self $self

    $self initArgs
    set options [$self options]
    # parse command line args
    $options parse_args $argv

    set spec [list]
    lappend spec [$options get_option withGui]
    lappend spec [$options get_option mode]
    lappend spec [$options get_option audioAddress]
    lappend spec [$options get_option audioPort]
    lappend spec [$options get_option logOutDir]
    lappend spec [$options get_option logInDir]
    lappend spec [$options get_option speakerThreshold]
    lappend spec [$options get_option audienceLeftThreshold]
    lappend spec [$options get_option audienceCenterThreshold]
    lappend spec [$options get_option audienceRightThreshold]
    # add other spec stuff here

    set withGui [$options get_option withGui]
    if {$withGui} {
        set frm [$self initUI]
    } else {
	set frm ""
	# get rid of the base MASH window
	wm withdraw .
    }

    # args are: baseFrame, spec
    set qm_ [new QuestionMonitor $frm $spec]

    set port_ [$options get_option rpcPort]
    set serv_ [new DpServer $port_]
}

QuestionMonitorApplication instproc initArgs {} {
    set options [$self options]

    # register valid options
    $options register_option -withGui withGui
    $options register_option -mode mode
    $options register_option -aa audioAddress
    $options register_option -ap audioPort
    $options register_option -lodir logOutDir
    $options register_option -lidir logInDir
    $options register_option -st speakerThreshold
    $options register_option -lt audienceLeftThreshold
    $options register_option -ct audienceCenterThreshold
    $options register_option -rt audienceRightThreshold
    $options register_option -port rpcPort

    # set up defaults
    $options add_default withGui 1
    $options add_default mode record
    $options add_default audioAddress 233.0.25.131
    $options add_default audioPort 22446
    $options add_default logOutDir log
    $options add_default logInDir log-input
    $options add_default speakerThreshold 40
    $options add_default audienceLeftThreshold 60
    $options add_default audienceCenterThreshold 60
    $options add_default audienceRightThreshold 60
    $options add_default rpcPort 6903
}

QuestionMonitorApplication instproc initUI {} {
    wm title . "Question Monitor"
    wm minsize . 200 0

    set baseFrame .qmFrame
    frame $baseFrame
    pack $baseFrame -side top

    # make exit button
    button .exit -text "Exit" -command "$self exitApp"
    pack .exit -side bottom

    return $baseFrame
}

QuestionMonitorApplication instproc setOutput {output} {
    $self instvar qm_

    $qm_ setOutput "$output"
}

QuestionMonitorApplication public exitApp {} {
    $self instvar qm_

    set msg "Are you sure you want to exit QM?"
    set result [tk_messageBox -message $msg -default "ok" -type okcancel -title "Question Monitor" -icon "question"]
    if {$result == "ok"} {
	$qm_ destroy
	exit
    }
}

QuestionMonitorApplication instproc enableQM {} {
    $self instvar qm_

    $qm_ enable
}

QuestionMonitorApplication instproc disableQM {} {
    $self instvar qm_

    $qm_ disable
}

QuestionMonitorApplication instproc markQuestionStart {region} {
    $self instvar qm_

    $qm_ markQuestionStart $region
}

QuestionMonitorApplication instproc markQuestionEnd {region} {
    $self instvar qm_

    $qm_ markQuestionEnd $region
}

QuestionMonitorApplication instproc setThreshold {mic threshold} {
    $self instvar qm_
}

proc setOutput {output} {
    $QuestionMonitorApplication::self setOutput $output
}

proc enableQM {} {
    $QuestionMonitorApplication::self enableQM
}

proc disableQM {} {
    $QuestionMonitorApplication::self disableQM
}

proc markQuestionStart {region} {
    $QuestionMonitorApplication::self markQuestionStart $region
}

proc markQuestionEnd {region} {
    $QuestionMonitorApplication::self markQuestionEnd $region
}

proc rqm_killServer {} {
    after 1000 "$QuestionMonitorApplication::self exitApp"
}

# FIXME - this has not been fully implemented
proc rqm_setThreshold {mic threshold} {
    $QuestionMonitorApplication::self setThreshold $mic $threshold
}