# server-ssac.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/ssac/server-ssac.tcl,v 1.17 2002/02/03 04:30:10 lim Exp $


import SessionCatalog ArchiveSession/Play/RTP ArchiveSession/Play/Mediaboard ArchiveSystem/Play

# This class handles parsing, operation of SSAC archive control protocol
# <p> Status: alpha
# <p> Author: Angela Schuett

Class SSACServer


# When this servent is created, the first msg is passed here.  All
# future messages arrive through recv_msg
SSACServer public init {app msg uniqport megactrl} {
	$self instvar app_ scheduled_ session_ uniqport_ ttl_

	set app_ $app
	set scheduled_ ""
	set session_(seqno) 0
	set session_(uniqport) $uniqport

	$self parse $msg
	set ab [new AddressBlock $megactrl]
	set ttl_ [$ab ttl]
	delete $ab
	if { $ttl_=={} } { set ttl_ 15 }
	if { $session_(unicastport) > 0 } { set ttl_ 1 }
	$self begin
	$self init_net
}


# The SSAC Server receives a message if the sequence number has been
# incremented, otherwise it just acts as a keep-alive message and
# doesn't reach this level
SSACServer public recv_msg {msg} {

	$self instvar session_  app_

	$self parse $msg

	#for now, only implement time change
	$self change_time $session_(offset)
	$app_ set_seqno [incr session_(seqno)]
}



# parse the SSD (service specific data) field of AS1, which in this
# service carries the SSAC (soft state archive control) protocol
SSACServer private parse {msg} {
    $self instvar sesslist_ session_ broadcast_


    #puts "MSG: $msg :MSG"
    set lines [split $msg "\n"]

    set seqno [lindex [split [lindex $lines 0]] 1]

    if {$seqno > $session_(seqno) } {
	set session_(seqno) $seqno
	set session_(filename) [lindex [split [lindex $lines 1]] 1]
	set session_(offset) [lindex [split [lindex $lines 2]] 1]
	set session_(clientaddr) [lindex [split [lindex $lines 3]] 1]
	set session_(unicastport) [lindex [split [lindex $lines 4]] 1]
    }

    # get all of the broadcast types out
    foreach line $lines {
	if { [lindex $line 0] != "inetBroadcastAddr" } {
	    continue
	}

	set info [split [lindex $line 1] :]
	set broadcast_([lindex $info 0]) [lindex $info 1]
    }
}

#
SSACServer private init_net {} {
    $self instvar sesslist_ session_ app_

    $app_ set_filename $session_(filename)
    $app_ set_duration $session_(duration)
    $app_ set_seqno [incr session_(seqno)]


    # The DC needs to know the source IDs that goes along with
    # the replay.  This is why this modification has been made

    $self instvar player_
    set lsession [$player_ set sessions_]

    foreach sess $sesslist_ {
	# find the session object that matches this session
	set media $session_($sess,Media)
	foreach session $lsession {
	    if {[$session set media_] != $media} {
		continue
	    }

	    set agent [$session set agent_]
	    set lsource [$agent set sources_]
	    set lsrcid ""
	    foreach source $lsource {
		lappend lsrcid [$source srcid]
	    }

	    break
	}

	$app_ add_sessinfo $sess $session_($sess,Address) $lsrcid
    }
}

# To begin playback, we choose addresses, and create a player
# Right now, the unique session name is a critical piece of info that needs
# to be shared between client and server.  Is this the way we want it?
SSACServer private begin {} {
	$self instvar  session_ sesslist_ player_ ttl_ broadcast_

	set player_ [new ArchiveSystem/Play]

	$player_ open $session_(filename)

	set sesslist_ [$player_ query_sessions]
	#puts "Sesslist: $sesslist_"
	foreach sess $sesslist_ {
		if { $session_(unicastport)==0 } {
		    set media [string trimright $sess "0123456789"]
		    if {[info exist broadcast_($media)]} {
			set session_($sess,Address) $broadcast_($media)
		    } else {
			set session_($sess,Address) [$self \
					alloc_mcast_addr]/[$self alloc_port]
		    }
		} else {
			set session_($sess,Address) $session_(clientaddr)/
			append session_($sess,Address) \
					$session_(uniqport):$session_(unicastport)
			incr session_(uniqport) 4
			incr session_(unicastport) 4
		}

		# FIXME hack relies on session names being audio1, video 3, etc
	        # should be a way to query data file and discover media type
		set session_($sess,Media) [string trimright $sess "0123456789"]
		if {$session_($sess,Media) == "audio"} {
			append session_($sess,Address) /PCM/$ttl_
		} elseif {$session_($sess,Media) == "video"} {
			append session_($sess,Address) /null/$ttl_
		} else {
			append session_($sess,Address) /$ttl_
		}

		# The playback address must have the send/recv ports reversed
		# in the unicast case
		if { $session_(unicastport)==0 } {
			set pbspec $session_($sess,Address)
		} else {
			set ab [new AddressBlock $session_($sess,Address)]
			set pbspec [$ab addr]/[$ab rport]:[$ab sport]/[$ab \
					fmt]/[$ab ttl]
		}

#puts "********* $sess $session_($sess,Address) $session_($sess,Media) **********"
		$player_ create_playback_session $pbspec \
				$session_($sess,Media) $sess
	}

	$self change_time $session_(offset)

	set start [$player_ get_start]
	set end [$player_ get_end]
	set session_(duration) [expr $end - $start]
}

# This is for demo purposes, or when you want to play from a set address
SSACServer private begin2 {} {
	$self instvar  session_ sesslist_ player_

	set player_ [new ArchiveSystem/Play]


	$player_ open $session_(filename)

	set sesslist_ [$player_ query_sessions]
	foreach sess $sesslist_ {

		set session_($sess,Media) [string trimright $sess "0123456789"]
		switch $session_($sess,Media) {
			video {
				set session_($sess,Address) 224.8.8.1/8000/null/15
			}
			audio {
				set session_($sess,Address) 224.8.8.2/8000/PCM/15
			}
			mediaboard {
				set session_($sess,Address) 224.8.8.3/8000/null/15
			}
		}


		#puts "********* $sess $session_($sess,Address) $session_($sess,Media) **********"
		$player_ create_playback_session $session_($sess,Address) $session_($sess,Media) $sess
	}



	$self change_time $session_(offset)


	set start [$player_ get_start]
	set end [$player_ get_end]
	set session_(duration) [expr $end - $start]
#	puts $session_(duration)
}

#
SSACServer public get_mapping {} {
	$self instvar player_

	return [$player_ get_mapping]

}

#
SSACServer private change_time {new} {
	$self instvar player_

	if { [string compare $new "PAUSE"] == 0} {
		$player_ stop
	} else {
		$player_ start
		$player_ goto $new
		$player_ start
	}

}




# FIXME: Address allocation
# What happens if the port gets allocated to another
# process in the meanwhile?
# What happens if two different servers re-use the
# same multicast address but have overlapped regions?
# FIXME need to follow sdp rules, actually, should be able to call some sdp proc # to do this
SSACServer instproc alloc_port {  } {
	# Random number U[8192, 16384]
	set r01 [expr [random]/double(0x7fffffff)]
	return [expr round(8392 + $r01 * 8192)]
}


#
SSACServer instproc alloc_mcast_addr {  } {
	set lo1 round([expr [random]/double(0x7fffffff) * 256])
	set lo2 round([expr [random]/double(0x7fffffff) * 256])
	return "224.2.[expr round($lo1)].[expr round($lo2)]"
}

