# example_ui.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

proc LaunchEffect {effect_type} {
    global effect_info

    set enum $effect_info(num)
    incr effect_info(num) 1

    set effect_info($enum,window) [toplevel .effect_$enum];
    set effect_info($enum,cntrl_handle) [fx_create $effect_type];

    fx_set_input_callback $effect_info($enum,cntrl_handle) "NewInput $enum "
    fx_set_output_callback $effect_info($enum,cntrl_handle) "NewOutput $enum "
    fx_set_parameter_callback $effect_info($enum,cntrl_handle) "NewParameter $enum "

    button $effect_info($enum,window).startstop -text "Start" -command "StartEffect $enum"

    button $effect_info($enum,window).quit -text "Destroy Effect" -command "DestroyEffect $enum"

    pack $effect_info($enum,window).quit -side bottom -fill both -expand 1
    pack $effect_info($enum,window).startstop -side bottom -fill both -expand 1

}

proc StartEffect {enum} {
    global effect_info

    set h $effect_info($enum,cntrl_handle)
    set w $effect_info($enum,window)

    fx_status $h on
    $w.startstop configure -text "Stop" -command "StopEffect $enum"
}

proc StopEffect {enum} {
    global effect_info

    set h $effect_info($enum,cntrl_handle)
    set w $effect_info($enum,window)

    fx_status $h off
    $w.startstop configure -text "Start" -command "StartEffect $enum"
}

proc DestroyEffect {enum} {
    global effect_info

    fx_destroy $effect_info($enum,cntrl_handle)
    destroy $effect_info($enum,window)

    unset effect_info($enum,cntrl_handle)
    unset effect_info($enum,window)
}

proc NewInput {enum iname} {
    global effect_info

    set w $effect_info($enum,window)
    set h $effect_info($enum,cntrl_handle)

    set f [frame $w.if_$iname]
    set l [label $f.lab -text "Input $iname:"]
    set e [entry $f.e]
    set b [button $f.b -text "Set"]

    $b configure -command "fx_set_input_spec $h $iname \[$e get\]"

    pack $l -side left
    pack $b -side right
    pack $e -side right -expand 1 -fill both
    pack $f -side top -expand 1 -fill both
}

proc NewOutput {enum oname} {
    global effect_info

    set w $effect_info($enum,window)
    set h $effect_info($enum,cntrl_handle)

    set f [frame $w.of_$oname]
    set l [label $f.lab -text "Output $oname:"]
    set e [entry $f.e]
    set b [button $f.b -text "Set"]

    $b configure -command "fx_set_output_spec $h $oname \[$e get\]"

    pack $l -side left
    pack $b -side right
    pack $e -side right -expand 1 -fill both
    pack $f -side top -expand 1 -fill both
}

proc NewParameter {enum pname} {
    global effect_info

    set w $effect_info($enum,window)
    set h $effect_info($enum,cntrl_handle)

    set f [frame $w.pf_$pname]

    set ptype [fx_get_parameter_type $h $pname];
    set pdomain [fx_get_parameter_domain $h $pname];

    if {$ptype == "int"} {
	MakeIntegerUI $f $enum $pname $pdomain
    } elseif {$ptype == "real"} {
	MakeRealUI $f $enum $pname $pdomain
    } elseif {$ptype == "color"} {
	MakeColorUI $f $enum $pname $pdomain
    } elseif {$ptype == "text"} {
	MakeTextUI $f $enum $pname $pdomain
    } elseif {$ptype == "exclusive_choice"} {
	MakeChoiceUI $f $enum $pname $pdomain
    }

    pack $f -side top -fill both -expand 1
}

proc MakeIntegerUI {f enum pname pdomain} {
    global effect_info

    set h $effect_info($enum,cntrl_handle)

    set pdomain [split $pdomain "(),"];
    set from [lindex $pdomain 1];
    set to [lindex $pdomain 2];

    set s [scale $f.s -orient horizontal -from $from -to $to -label "$pname"];
    $s configure -command "fx_set_parameter_value $h $pname "

    pack $s -side top -fill both -expand 1
}

proc MakeRealUI {f enum pname pdomain} {
    global effect_info

    set h $effect_info($enum,cntrl_handle)

    set pdomain [split $pdomain "(),"];
    set from [lindex $pdomain 1];
    set to [lindex $pdomain 2];

    set s [scale $f.s -orient horizontal -from $from -to $to -resolution [expr ($from - $to) / 100.0] -label "$pname"]
    $s configure -command "fx_set_parameter_value $h $pname "

    pack $s -side top -fill both -expand 1
}

proc MakeTextUI {f enum pname pdomain} {
    global effect_info

    set h $effect_info($enum,cntrl_handle)

    set l [label $f.l -text "$pname :"]
    set e [entry $f.e ]
    set b [button $f.b -text "Set"]
    $b configure -command "fx_set_parameter_value $h $pname \[$e get\]"

    pack $l -side left
    pack $b -side right
    pack $e -side right -fill both -expand 1;
}

proc MakeChoiceUI {f enum pname pdomain} {
    global effect_info

    set h $effect_info($enum,cntrl_handle)
    set b [menubutton $f.b -text "Parameter $pname: <not set>"]
    set m [menu $f.b.m ]

    foreach i $pdomain {
	$m add radiobutton -label "$i" -variable effect_info($pname,choice_var) -command "fx_set_parameter_value $h $pname $i; \
		$b configure -text {$pname: $i} "
    }
    $b configure -menu $m

    pack $b -side top -fill both -expand 1
}

proc MakeColorUI {f enum pname pdomain} {
    global effect_info

    set h $effect_info($enum,cntrl_handle)

    button $f.b -text "Set to Black" -command "fx_set_parameter_value $h $pname {0 128 128}"
    button $f.w -text "Set to White" -command "fx_set_parameter_value $h $pname {255 128 128}"

    pack $f.b -side left -fill both -expand 1
    pack $f.w -side left -fill both -expand 1

    puts "Need to make Color UI for effect $enum, parameter $pname, in domain $pdomain"
}

import Application

set app [new Application example-ui]

source [glob ~kpatel/mash-code/mash/tcl/psvp/fx_service/fx_client.tcl]

menubutton .launch  -text "Launch New Effect"

menu .launch.menu
.launch.menu add command -label "Fade" -command "LaunchEffect H261FadeSubprogram"
.launch.menu add command -label "Titling" -command "LaunchEffect H261TitleSubprogram"

.launch configure -menu .launch.menu

pack .launch

set effect_info(num) 0
