# ui-print.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#   @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/mb/ui-print.tcl,v 1.12 2002/02/03 04:27:17 lim Exp $

import WidgetClass Dialog FileBox

WidgetClass MBUI_Print -superclass Dialog -configspec {
	{ -colorMode colorMode ColorMode gray set_colorMode colorMode }
	{ -orient orient Orient portrait set_orient orient }
	{ -content content Content full set_content content }
	{ -range range Range current set_range range }
	{ -pageMgr pageMgr PageMgr {} set_pageMgr pageMgr }
} -default {
	{ *Radiobutton.font WidgetDefault }
	{ *font WidgetDefault }
}

MBUI_Print instproc build_widget {path} {
	set topf [frame $path.topf -bd 2 -relief ridge]
	wm title $path "Save to Postscript"
	set optionL [label $topf.optionL -text Options]
	pack $optionL -side left -fill x
	pack $topf -side top -fill x

	set colorf [frame $topf.colorf -bd 1 -relief sunken]
	set colorb [radiobutton $colorf.pscolor -text color -underline 0 \
			-variable [$self tkvarname colorMode_] -value color]
	set grayb [radiobutton $colorf.psgray -text gray -underline 0 \
			-variable [$self tkvarname colorMode_] -value gray]
	pack $colorb $grayb -side bottom -anchor w -expand 1

	set orientf [frame $topf.orientf -bd 1 -relief sunken]
	set portb [radiobutton $orientf.port -text portrait -underline 0 \
			-variable [$self tkvarname orient_] -value portrait]
	set landb [radiobutton $orientf.land -text landscape -underline 0 \
			-variable [$self tkvarname orient_] \
			-value landscape]
	pack $landb $portb -side bottom -expand 1 -anchor w

	set contentf [frame $topf.contentf -bd 1 -relief sunken]
	set fullB [radiobutton $contentf.fullB -text "fit all items" \
			-underline 0 \
			-variable [$self tkvarname content_] -value full]
	set displayB [radiobutton $contentf.displayB -text "displayed view" \
			-underline 3 -variable [$self tkvarname content_] \
			-value displayed]
	pack $fullB $displayB  -side top -expand 1 -anchor w

	set rangef [frame $topf.rangef -bd 1 -relief sunken]
	set currB [radiobutton $rangef.currB -text "current page" \
			-underline 0 \
			-variable [$self tkvarname range_] -value current]
	set allB [radiobutton $rangef.allB -text "all pages" \
			-underline 0 \
			-variable [$self tkvarname range_] -value all]
	pack $currB $allB -side top -expand 1 -anchor w

	pack $orientf $colorf $contentf $rangef -side left -fill x \
			-padx 2 -pady 4 -expand 1

	$self tkvar filename_
	set filef [frame $path.filef -bd 2 -relief ridge]
	set filebox [FileBox $filef.filebox -filetypes {{postscript .ps}} \
			-command "$self save; $self ignore_args" ]
	$self set_subwidget filebox $filebox
 	pack $filef $filebox -side top -fill x -pady 3

	set botf [frame $path.botf -bd 2]
	set dismissb [button $botf.dismiss -text dismiss -width 10 \
			-command "$self hide" -underline 0]
	set okb [button $botf.ok -text ok -width 10 -command "$self save" \
			-underline 0]
	pack $dismissb $okb -side left
	pack $botf -side right
}

MBUI_Print proc decl_accessor {className varName {instvarName {}}} {
	if {"$instvarName"==""} {
		set instvarName $varName
		append instvarName "_"
	}
	$className instproc set_$varName {option value} \
			"\$self set $instvarName \$value"
	$className instproc $varName {} \
			"return \[\$self set $instvarName \$value\]"
}

MBUI_Print proc decl_tk_accessor {className varName {tkvarName {}}} {
	if {"$tkvarName" == ""}  {
		set tkvarName $varName
		append tkvarName "_"
	}
	$className instproc set_$varName {option value} \
			"\$self tkvar $tkvarName; set $tkvarName \$value"
	$className instproc $varName {} \
			"\$self tkvar $tkvarName; return \$tkvarname"
}

MBUI_Print proc decl_wgt_accessor { className varName {tkvarName {}} } {
	if {$tkvarName == {}}  {
		set tkvarName $varName
		append tkvarName _
	}
	eval [list $className instproc set_$varName {option value} \
		"\$self tkvar $tkvarName; set $tkvarName \$value"]
	eval [list $className instproc $varName {option} \
			"\$self tkvar $tkvarName; return \$tkvarname"]
}

MBUI_Print decl_wgt_accessor MBUI_Print colorMode {}
MBUI_Print decl_wgt_accessor MBUI_Print orient {}
MBUI_Print decl_wgt_accessor MBUI_Print content {}
MBUI_Print decl_wgt_accessor MBUI_Print range {}
MBUI_Print decl_accessor  MBUI_Print pageMgr {}

MBUI_Print instproc show {} {
	$self instvar path_
	wm deiconify $path_
	wm title $path_ "Save to Postscript"
}

MBUI_Print instproc hide {} {
	wm withdraw [$self set path_]
}

MBUI_Print instproc save {} {
	set filebox [$self subwidget filebox]
	set dir [$filebox cget -directory]
	set file [$filebox cget -filename]
	if  { $file=="" } return
	set path [file join $dir $file]
	if [file exists $path] {
		set reply [Dialog transient MessageBox -image Icons(warning) \
				-type yesno -text \
				"File \"$path\" already exists.\
				\nDo you want to overwrite it?"]
		if ![string compare $reply "no"] {
			return
		}
	}

	set f [open $path "w"]
	$self tkvar orient_ colorMode_ content_ range_
	set pageMgr [$self set pageMgr_]
	if {$range_ == "all"} {
		set pagelist [MBPageMgr sort_pages [$pageMgr pagelist]]
	} else {
		set pagelist [$pageMgr current_page]
	}
	set p [removeFirst pagelist]
	if {"$p" == ""} return

	set i 1
	# FIXME: figure out why $self get_option does not work here
	set confName [$pageMgr get_option conferenceName]
	set hdr "Page $i --- \[[$pageMgr page_label $p]\]     $confName     [gettimeofday ascii]"

        # dump prolog and document header
        TkCanvPsHeader $f "Conference Name: $confName"

        puts $f "%%Page: 1 1\nsave\n"

	[$pageMgr page2canv $p] to_ps $content_ $orient_ $hdr \
			-channel $f -colormode $colorMode_ \
			-prolog 0 -trailer 0

	foreach p $pagelist {
		incr i
		puts $f "\n%%Page: $i $i\n"
		set hdr "Page $i --- \[[$pageMgr page_label $p]\]     $confName     [gettimeofday ascii]"
		[$pageMgr page2canv $p] to_ps $content_ $orient_ $hdr \
				-channel $f -colormode $colorMode_ \
				-prolog 0 -trailer 0
		puts $f "%%PageTrailer\n"
	}
	puts $f "%%Trailer\n%%Pages:$i\nend\n%%EOF\n"
	close $f
	$self hide
}
