# ui-video.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/collaborator/ui-video.tcl,v 1.7 2002/02/03 04:21:46 lim Exp $


import ScrolledWinMgr
Class VideoContainer


VideoContainer proc.invoke {} {
	$self instvar sizes_
	set sizes_(thumbnail) {80 60}
	set sizes_(qcif) {176 144}
	set sizes_(cif) {352 288}
	set sizes_(scif) {704 576}
	set sizes_(ntsc_16) {160 120}
	set sizes_(ntsc_4) {320 240}
	set sizes_(ntsc) {640 480}
}


VideoContainer public init { path num size init_orientation } {
        $self instvar numVideos_ size_ orient_
        set numVideos_ $num
	set size_ [VideoContainer set sizes_($size)]
	set orient_ $init_orientation

        $self build_widget $path
}


VideoContainer public destroy { } {
	$self instvar videos_ path_
	set i 0
	foreach v $videos_ {
		$self throw_away $v
	}
}


VideoContainer private build_widget { path } {
        $self instvar numVideos_ videos_ size_ path_ bbox_ orient_ nextIdx_ \
			win2vw_

	set path_ $path
	ScrolledWinMgr $path -scrollbar both
	set bbox_ [$path holder]

	set videos_ {}
	set x 0
	set y 0
	if { $orient_ == "vertical" } {
		set dx 0; set dy [expr [lindex $size_ 1] + 20]
	} else {
		set dx [expr [lindex $size_ 0] + 5]; set dy 0
	}
        for { set i 0 } { $i < $numVideos_ } { incr i } {
		set v [eval new VideoWidget/Decorated $bbox_.video$i $size_ \
				$self]
		set win2vw_($bbox_.video$i) $v
		$path add_window $bbox_.video$i $x $y
		incr x $dx
		incr y $dy
		lappend videos_ $v
        }
	set nextIdx_ $numVideos_
}


VideoContainer private add { uisrc x y } {
	$self instvar videos_ path_ size_ nextIdx_ bbox_ mappings_ win2vw_
	set i [llength $videos_]
	set v [eval new VideoWidget/Decorated $bbox_.video$nextIdx_ $size_ \
			$self]
	set win2vw_($bbox_.video$nextIdx_) $v
	lappend videos_ $v
	$v switch $uisrc
	lappend mappings_([$uisrc src]) $v

	$path_ add_window $bbox_.video$nextIdx_ $x $y
	incr nextIdx_
}


VideoContainer public activate { uisrc } {
	$self instvar videos_ mappings_
	foreach v $videos_ {
		if { [$v attached-source] == {} } {
			$v switch $uisrc
			lappend mappings_([$uisrc src]) $v
			break
		}
	}
}


VideoContainer public deactivate { uisrc {othersrcs {}} } {
	$self instvar mappings_
	if [info exists mappings_([$uisrc src])] {
		foreach mapped $mappings_([$uisrc src]) {
			set new_src ""
			foreach s $othersrcs {
				if ![info exists mappings_([$s src])] {
					set new_src $s
					break
				}
			}

			$mapped switch $new_src
			if { $new_src != {} } {
				lappend mappings_([$new_src src]) $mapped
			}
		}
		unset mappings_([$uisrc src])
	}
}


VideoContainer public change_name { uisrc name } {
	$self instvar mappings_
	if [info exists mappings_([$uisrc src])] {
		foreach mapped $mappings_([$uisrc src]) {
			$mapped change_label $name
		}
	}
}


VideoContainer public drop_thumbnail { dragdrop uisrc x y } {
	$self instvar videos_ mappings_ bbox_ win2vw_

	set bl [winfo rootx $bbox_]
	set bt [winfo rooty $bbox_]
	set br [expr $bl + [winfo width  $bbox_] - 1]
	set bb [expr $bt + [winfo height $bbox_] - 1]

	# first sort the video list in top-to-bottom stacking order
	set videos {}
	foreach w [winfo children $bbox_] {
		if [info exists win2vw_($w)] {
			set videos [concat [list $win2vw_($w)] $videos]
		}
	}

	foreach v $videos {
		set w [$v path]
		if ![winfo ismapped $w] continue

		set l [winfo rootx $w]
		set t [winfo rooty $w]
		set r [expr $l + [winfo width  $w] - 1]
		set b [expr $t + [winfo height $w] - 1]

		if { $bl > $l } { set l $bl }
		if { $br < $r } { set r $br }
		if { $bt > $t } { set t $bt }
		if { $bb < $b } { set b $bb }

		if { $l > $r || $t > $b } continue

		if { $x >= $l && $x <= $r && $y >= $t && $y <= $b } {
			set s [$v attached-source]
			if { $s!={} && [info exists mappings_([$s src])] } {
				set i [lsearch -exact $mappings_([$s src]) $v]
				if { $i != -1 } {
					set mappings_([$s src]) [lreplace \
							$mappings_([$s src]) \
							$i $i]
					if { [llength $mappings_([$s src])] \
							== 0 } {
						unset mappings_([$s src])
					}
				}
			}
			$v switch $uisrc
			lappend mappings_([$uisrc src]) $v
			return 1
		}
	}

	if { $x >= $bl && $x <= $br && $y >= $bt && $y <= $bb } {
		# we are inside the canvas boundary
		# let's just add a new video widget

		set coords [$dragdrop get_nw_coords $x $y]
		set x [lindex $coords 0]
		set y [lindex $coords 1]

		$self add $uisrc [$bbox_ canvasx [expr $x -$bl]] \
				[$bbox_ canvasy [expr $y - $bt]]
		return 1
	}
	return 0
}


VideoContainer public move_widget { vwd dragdrop x y } {
	$self instvar videos_ mappings_ bbox_ path_

	set bl [winfo rootx $bbox_]
	set bt [winfo rooty $bbox_]
	set br [expr $bl + [winfo width  $bbox_] - 1]
	set bb [expr $bt + [winfo height $bbox_] - 1]

	set w [$vwd path]
	set coords [$dragdrop get_nw_coords $x $y]
	set l [lindex $coords 0]
	set t [lindex $coords 1]
	set r [expr $l + [winfo width  $w] - 1]
	set b [expr $t + [winfo height $w] - 1]

	if { $bl > $l } { set l $bl }
	if { $br < $r } { set r $br }
	if { $bt > $t } { set t $bt }
	if { $bb < $b } { set b $bb }

	if { $l <= $r && $t <= $b } {
		# we are inside the canvas boundary
		# let's just add a new video widget

		set l [lindex $coords 0]
		set t [lindex $coords 1]
		$path_ move_window [$vwd path] [$bbox_ canvasx [expr $l -$bl]]\
				[$bbox_ canvasy [expr $t - $bt]]
	} else {
		# the drop location is outside the video container
		# throw the source away

		#$dragdrop zoom_back 25
		$self throw_away $vwd
	}
}


VideoContainer private throw_away { vwd } {
	$self instvar mappings_ videos_ path_

	set s [$vwd attached-source]
	if { $s != "" } {
		$vwd switch {}
		if [info exists mappings_([$s src])] {
			set i [lsearch -exact $mappings_([$s src]) $vwd]
			if { $i != -1 } {
				set mappings_([$s src]) [lreplace \
						$mappings_([$s src]) $i $i]
				if { [llength $mappings_([$s src])] == 0 } {
					unset mappings_([$s src])
				}
			}
		}
	}

	$path_ remove_window [$vwd path]
	delete $vwd
	set i [lsearch -exact $videos_ $vwd]
	if { $i != -1 } {
		set videos_ [lreplace $videos_ $i $i]
	}
}


Class VideoWidget/Decorated -superclass VideoWidget


VideoWidget/Decorated public init { w width height vc } {
	$self instvar widget_ label_ dragdrop_ videoContainer_
	$self tkvar size_
	set videoContainer_ $vc
	set widget_ $w
	frame $w -bd 1 -relief raised
	$self next $w.video $width $height
	label $w.label_frame -height 1
	menubutton $w.label -text "Waiting for video" \
			-menu $w.label.menu
	set label_ "Waiting for video"
	pack $w.video -anchor c
	pack $w.label -fill both -expand 1 -in $w.label_frame
	pack $w.label_frame -side bottom -anchor s -fill x
	pack propagate $w.label_frame 0
	$self set uisrc_ ""

	menu $w.label.menu
	$w.label.menu add cascade -label "Size" -menu $w.label.menu.size
	$w.label.menu add command -label "Clear window" \
			-command "$self switch {}"
	$w.label.menu add command -label "Delete window" \
			-command "$videoContainer_ throw_away $self"

	set size_ ${width}x$height
	set m [menu $w.label.menu.size]
	$m add radiobutton -label QCIF -command "$self resize 176 144" \
		-value 176x144 -variable [$self tkvarname size_]
	$m add radiobutton -label CIF -command "$self resize 352 288" \
		-value 352x288 -variable [$self tkvarname size_]
	$m add radiobutton -label SCIF -command "$self resize 704 576" \
		-value 704x576 -variable [$self tkvarname size_]

	$m add separator
	$m add radiobutton -label "1/16 NTSC" \
		-command "$self resize 160 120" -value 160x120 \
		-variable [$self tkvarname size_]
	$m add radiobutton -label "1/4 NTSC" \
		-command "$self resize 320 240" -value 320x240 \
		-variable [$self tkvarname size_]
	$m add radiobutton -label NTSC \
		-command "$self resize 640 480" -value 640x480 \
		-variable [$self tkvarname size_]

	$m add separator
	$m add radiobutton -label "1/16 PAL" \
		-command "$self resize 192 144" -value 192x144 \
		-variable [$self tkvarname size_]
	$m add radiobutton -label "1/4 PAL" \
		-command "$self resize 384 288" -value 384x288 \
		-variable [$self tkvarname size_]
	$m add radiobutton -label PAL \
		-command "$self resize 768 576" -value 768x576 \
		-variable [$self tkvarname size_]

	set dragdrop_ [new DragNDrop $w.video \
			"$videoContainer_ move_widget $self"]
}


VideoWidget/Decorated public destroy { } {
	$self instvar widget_
	set w $widget_
	$self next
	destroy $w
}


VideoWidget/Decorated public path { } {
	$self instvar widget_
	return $widget_
}


VideoWidget/Decorated public change_label { label } {
	$self instvar widget_ label_
	if { $label_ != $label } {
		$widget_.label configure -text $label
		set label_ $label
	}
}


VideoWidget/Decorated public switch { uisrc } {
	$self instvar uisrc_ dragdrop_ widget_
	if { $uisrc_ == $uisrc } return
	if { $uisrc_ != {} } {
		$uisrc_ detach_window $self
	}

	set uisrc_ $uisrc
	if { $uisrc_ != {} } {
		bind $widget_.video <Double-ButtonPress-1> \
				"$uisrc_ select_thumbnail"
		$uisrc_ attach_window $self
		$self change_label [$uisrc_ name]
	} else {
		bind $widget_.video <Double-ButtonPress-1> ""
		$self change_label "Waiting for video"
	}
	$self redraw
}


VideoWidget/Decorated public attached-source { } {
	$self instvar uisrc_
	return $uisrc_
}


#
# Resize the VideoWindow being displayed in the UserWindow's VideoWidget.
#
VideoWidget/Decorated public resize { w h } {
	$self instvar uisrc_
	if { $uisrc_ != {} } { $uisrc_ detach_window $self }
	[$self window] resize $w $h
	#
	# Force an update so the window gets mapped at
	# the new size before we re-bind the window
	# to the source.
	#
	update idletasks
	if { $uisrc_ != {} } { $uisrc_ attach_window $self }
}



VideoWidget/Decorated public is-switched {} { return 0 }
VideoWidget/Decorated public video-widget {} { return $self }
VideoWidget/Decorated public set-name { name } { $self change_label $name }
