/*
 * supp-srmv2.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "supp-srmv2.h"

void
SRMv2_SuppQueue::process(SRMv2_Range *prev, Bool flag)
{
	if (flag == SRMv2_CANCEL) {
		SRMv2_Range *p = 0;
		if (!prev) {
			if (list_ != 0) {
				p = list_;
				list_ = p->next;
			}
		} else {
			p = prev->next;
			prev->next = p->next;
		}
		if (p != 0) {
//			printf("CANCEL %d %d.%d %d.%d\n", p->cid_,
//			       p->left.adu, p->left.byte, p->right.adu, p->right.byte);
			p->cancel();
			delete p;
		}
		return;
	}
	if (flag == SRMv2_BACKOFF) {
		SRMv2_Range *p = 0;
		if (prev == 0)
			p= list_;
		else
			p = prev->next;

		if (p != 0) {
//			printf("BACKOFF %d %d.%d %d.%d\n", p->cid_,
//			       p->left.adu, p->left.byte, p->right.adu, p->right.byte);
			p->backoff();
		}
		return;
	}
	printf("Unknown flag %d\n", flag);

}

void
SRMv2_SuppQueue::insert_range(SRMv2_Range *range, SRMv2_Range *before)
{
	if (range && range->valid()) {
		if (before) {
			range->next = before->next;
			before->next = range;
		} else {
			range->next = list_;
			list_ = range;
		}
		return;
	}
	if (range) {
//		printf("Deleting %d %d.%d\n", range->cid_, range->left.byte, range->right.byte);
		delete range;
	}
}

/*
 * Since the incoming range is guaranteed not to exist in the queue already,
 * simply compare the left edges of the list and insert atthe right position.
 */
void
SRMv2_SuppQueue::insert_range(SRMv2_Range *range)
{
	SRMv2_Range** r;
	SRMv2_Edge e = range->left;
	for (r = &list_; *r != 0; r = &(*r)->next)
		if (e < (*r)->left)
			break;
	range->next = *r;
	*r = range;
}

/*
 * (1) Check queue and backoff matching ranges.
 * (2) Update the set of intersecting intervals.
 * (3) Return the intersection set.
 *
 * If the flag cancel is set, the intersecting intervals
 * are canceled. If not, they are simply backed off.
 */

void
SRMv2_SuppQueue::process_intersection(SRMv2_Range *r, Bool flag)
{
	SRMv2_Range *cr = list_;
	SRMv2_Range *pr = 0;
	unsigned int cid = r->cid_;
	SRMv2_Edge left = r->left;
	SRMv2_Edge right = r->right;
	SRMv2_Session *session;
	SRMv2_Source *source;
	double period; /* ms */

	while (cr) {
		session = cr->session_;
		source  = cr->source_;
		period  = cr->period_;
//		printf("Period = %d\n", period);

		/* cr  : |---|        or         |---|
		 * recv:       |---|       |---|
		 */
		if (cr->right <= left || right <= cr->left) {
			pr = cr;
			cr = cr->next;
			continue;
		}
		/* cr  : |-------| or |-------| or |-------| or |------|
		 * recv:   |--|       |--|              |--|    |------|
		 */
		if (cr->left <= left && right <= cr->right) {
//			printf("SPLITTING :-\n");
			SRMv2_Range* r1 = new SRMv2_Range(cid, cr->left, left);
			SRMv2_Range* r2 = new SRMv2_Range(cid, right, cr->right);
			process(pr, flag);
			r1->sched_timeout(period, session, source);
			r2->sched_timeout(period, session, source);
			insert_range(r1, pr);
			if (pr) pr = pr->next;
			insert_range(r2, pr);
			if (pr)
				cr = pr->next;
			else
				cr = cr->next;
			continue;
		}

		/* cr  :   |--|    or |--|      or      |--|
		 * recv: |-------|    |-------|    |-------|
		 */
		if (left <= cr->left && cr->right <= right) {
			process(pr, flag);
			if (pr)
				cr = pr->next;
			else
				cr = cr->next;
			continue;
		}

		/*
		 * cr  : |-------|
		 * recv:      |-------|
		 */
		if (cr->left < left && left < cr->right && cr->right < right) {
			SRMv2_Range* r1 = new SRMv2_Range(cid, cr->left, left);
			cr->left = right;
			process(pr, flag);
			insert_range(r1, pr);
			r1->sched_timeout(period, session, source);
			pr = cr;
			cr = cr->next;
			continue;
		}
		/*
		 * cr  :      |-------|
		 * recv: |-------|
		 */
		if (left < cr->left && cr->left < right && right < cr->right) {
			SRMv2_Range* r1 = new SRMv2_Range(cid, right, cr->right);
			cr->right = right;
			process(pr, flag);
			insert_range(r1, pr);
			r1->sched_timeout(period, session, source);
			pr = cr;
			cr = cr->next;
			continue;
		}
	}
}


void
SRMv2_SuppQueue::append_range(SRMv2_Range *range)
{
	append_range(range, list_);
}

void
SRMv2_SuppQueue::append_range(SRMv2_Range *range, SRMv2_Range *head)
{
	SRMv2_Range *p, *b = 0;
	if (!range->valid()) return;
	/* Traverse the list to its end */
	for (p = head; p != 0; p = p->next)
		b = p;
	if (b) {
		b->next = range;
	} else head = range;
}
void
SRMv2_SuppQueue::append_copy(SRMv2_Range *range, SRMv2_Range *head)
{
	if (!range->valid()) return;
	SRMv2_Range cp = *range;
	append_range(&cp, head);
}

void
SRMv2_SuppQueue::display() {
#if 0
	SRMv2_Range *p;
	printf("\nREQ QUEUE --\n");
	for (p = list_; p != 0; p = p->next)
		printf("{%d (%d - %d)}, ", p->cid_, p->left.byte, p->right.byte);
	printf("\n");
#endif
}

