/*
 * manager-srmv2.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef srmv2_manager_h
#define srmv2_manager_h

#include "tclcl.h"
#include "inet.h"
#include "srmv2.h"
#include "session-srmv2.h"
#include "pktbuf-srmv2.h"

class SRMv2_Source;
class SRMv2_Manager : public TclObject {
public:
	SRMv2_Manager() : TclObject(), session_(0) { }
	~SRMv2_Manager() { }
	int command(int argc, const char*const* argv);

	virtual void handle_data(SRMv2_Source *src, pktbuf *pb, unsigned int cid,
				 int seqno, unsigned char type, u_int32_t off,
				 int more);
	virtual void handle_rreq(SRMv2_Source *src, u_int32_t ss, u_int32_t es,
				 unsigned int sbytes, unsigned int ebytes,
				 unsigned int cid);
	void handle_announce(SRMv2_Source *src, unsigned int cid, unsigned int signature,
			     unsigned int ebytes);
	void handle_nsrepair(SRMv2_Source *src, srmv2_announcehdr *hdrs, int count);
	adubuf* reada(SRMv2_Source* src, unsigned int cid, unsigned int seqno);
	void prepare_to_send(SRMv2_Source* src, unsigned int cid, unsigned int seqno,
			     unsigned int ss, unsigned int es);
protected:
	SRMv2_Session *session_;
};
#endif

