/*
 * np-plugin.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1991-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/mplug/cc-api/np-plugin.h,v 1.8 2002/02/24 02:13:38 lim Exp $
 */

#ifndef MASH_NP_PLUGIN_H
#define MASH_NP_PLUGIN_H


#include "np-os.h"
#include <npapi.h>


class PluginStream;


/*
 * Definition for a base class which uses the plugin API's malloc/free calls
 * to dynamically allocate/free memory for the object
 */
class NetscapeMemObject {
public:
	void* operator new(size_t size) { return NPN_MemAlloc( size ); };
	void  operator delete(void* theThing)
	{ NPN_MemFree(theThing); };

	static void* malloc(size_t size) { return NPN_MemAlloc( size ); };
	static void  free(void *ptr) { NPN_MemFree(ptr); };
};


/*
 * C++ class to encapsulate the NPP_* API functions
 *
 * Create a new class derived from this class and define your own methods
 * for custom plugins
 */
class PluginInstance : public NetscapeMemObject {

public:
	PluginInstance(NPP instance) : instance_(instance) { }
	virtual ~PluginInstance() { if (instance_) instance_->pdata = NULL; }
	virtual NPError SetWindow(NPWindow* /*window*/)
	{ return NPERR_NO_ERROR; }
	virtual void Print(NPPrint* /*printInfo*/) { }
	virtual NPBool HandleEvent(void* /*event*/) { return FALSE; }
	virtual PluginStream* CreateStream(NPMIMEType /*type*/,
					   NPStream * /*stream*/,
					   NPBool /*seekable*/,
					   uint16 * /*stype*/)
	{ return NULL; }
	virtual NPError SaveInstanceData(NPSavedData**)
	{ return NPERR_NO_ERROR; };


	/*
	 * PLUGIN DEVELOPERS:
	 * Define the following two methods in your files to do the appropriate
	 * initialization and shutdown procedures and to create an object of
	 * the appropriate subclass of PluginInstance
	 */
	static NPError Initialize(void);
	static void    Shutdown(void);
	static PluginInstance *CreateInstance(NPMIMEType mimeType,
					      NPP instance,
					      uint16 mode,
					      int16 argc,
					      const char* const *argn,
					      const char* const *argv,
					      NPSavedData *savedData);

private:
	NPP instance_;

protected:
#ifdef XP_UNIX
	/*
	 * PLUGIN DEVELOPERS:
	 * Define the following variables in your files
	 */
	static char*     mimeDescription;
	static char*     pluginName;
	static char*     pluginDescription;

	friend char*     NPP_GetMIMEDescription(void);
	friend NPError   NPP_GetValue(void *future,
				      NPPVariable variable,
				      void *value);
#endif

};




/*
 * C++ class to encapsulate stream functions
 */
class PluginStream : public NetscapeMemObject {
public:
	PluginStream(NPStream *npStream) : npStream_(npStream) { }
	virtual ~PluginStream() { if (npStream_) npStream_->pdata = NULL; }

	/* callbacks from browser */
	virtual long WriteReady() { return 0X0FFFFFFF; };
	virtual long Write(int32 /*offset*/, int32 len, void * /*buffer*/)
	{ return len; }
	virtual NPError Destroy(NPError /*reason*/) { return NPERR_NO_ERROR; };
	virtual void    StreamAsFile(const char* /*fname*/) { };
	/* done callbacks */

	const char* GetURL() const
	{ return ((npStream_) ? npStream_->url : (const char*)NULL); }

private:
	NPStream *npStream_;
};


#endif /* MASH_NP_PLUGIN_H */

