/*
 * mb-sndr.h --
 *
 *      MediaBoard Sender (MBSender)
 *      The main object from which the UI manipulate mb drawing objects.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /usr/mash/src/repository/mash/mash-1/mb/mb-sndr.h,v 1.12 2002/02/03 03:16:30 lim Exp $
 */

#ifndef mb_sndr_h
#define mb_sndr_h

#include "mb.h"
#include "mb-page.h"
#include "mb-mgr.h"

class MBCmd;
class Transformer;
class MBReceiver;

/*
 * The Sender object handles translating local actions into network
 * packets that are sent via the Network class.  All operations are
 * looped back by the sender to the local Receiver.  This way graphics
 * are drawn and handled in a uniform manner.
 */
class MBSender : public TclObject {
public:
        MBSender();

        void Init() {
                pLocalRcvr_ = pMgr_->CreateLocal();
        }

	int CreatePage(const char *szName, PageId& pgId);

        /*
         * switches to the page, returns FALSE if such a page is not defined
         * by the corresponding source
         */
        Bool MBSender::SwitchPage(const PageId& pgId);

	/*
	 * These functions create new objects, insert them into the local
	 * receiver (so they get imaged) and multicast them if the interactive
	 * level is hight enough.
	 * They are created on the current page by default
	 */
	u_long CreateItem(Page* pPage, PageItem *pItem);
	u_long CreateAsFrag(Page* pPage, PageItem *pItem, int argc,
			    const char*const* argv);

	u_long MBSender::CreateGroup(Page* pPage, PageItemType type,
				     u_long snStart, u_long snEnd,
				     PageItem *pItem);

        void Attach(MBManager *pMgr) {
		if (!pMgr)
			SignalError(("Cannot attach: Manager not found!"));
		pMgr_ = pMgr;
		Init();
	}

#ifdef OLD
	u_long ChangeItemCoord(Page* pPage, u_long item, Coord x1, Coord y1,
			       Coord x2, Coord y2);
#endif

	u_long MoveItem(Page* pPage, u_long itemid, Coord dx, Coord dy);

	// insert text into string
	Bool Insert(Page* pPage, u_long itemid, u_short index, const char* pChar);

	u_long DeleteItem(Page* pPage, u_long seqno);

	u_long DupItem(Page* pPage, u_long itemId);

	u_long NearestItem(Page* pPage, Coord x, Coord y, Coord dist);

#if 0
	Tcl_DString* OverlappedItems(Coord x1, Coord y1, Coord x2, Coord y2);
#endif
	// interactive level 0 commands are always sent out
	// interactive level 1 commands are not sent out
	//   we could change this so that the level of interactivity is user
	//   choosable
	Bool SetInteractive(int level) {
		if ( level==0 || level==1) {
			interactiveLvl_ = level;
			return TRUE;
		}
		return FALSE;
	}

	virtual int command(int argc, const char*const* argv);

protected:
	Page* pCurrPage_;

private:
	MBLocalReceiver* pLocalRcvr_;	/* local rcvr */
	MBManager*  pMgr_;
	short interactiveLvl_ ;
};

#endif

