/*
 * fca-mgr.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MASH_FCA_MGR_H
#define MASH_FCA_MGR_H


#include "srm/appmgr-srm.h"
#include "srm/session-srm.h"
#include "fca-rreq.h"

class FCAMgr;
class FCARcvr;

class FCAMgr : public SRM_AppMgr {
public:
  FCAMgr() : SRM_AppMgr(NULL), pSession_(NULL) {
    Debug(dbgFCA,("Creating FCA app-manager$$$$$$$$$$$$$$$$$$$$$$$$$"));
  }
  virtual ~FCAMgr() {}

  /* the following virtual functions are SRM callbacks */
  SRM_PacketHandler *new_source(const srm_src &sid, int islocal);
  int next_ADU(u_char *db, int len, srm_src &id, int &pkt_type,
	       int &next);
  int  periodic_update(u_char *pb);
  virtual void handle_SA(const srm_src &sid, u_char *pb, int len);
  virtual void handle_request(const srm_src &sid, u_char *pb, int len);
  virtual void handle_reply(const srm_src &sid, u_char *pb, int len);
  void sched_request(FCARepairRequest* pRequest, const SrcId& sid ) {
    pSession_->sched_request(pRequest, sid);
  }
  void sched_reply(FCARepairReply* pReply, const SrcId& sid) {
    pSession_->sched_reply(pReply, sid);
  }

  int FCAMgr::command(int argc, const char*const* argv);

private:
  FCARcvr *DefineRcvr(const srm_src &sid, int islocal);

  SRM_Session* pSession_;
};





class FCARcvr : public SRM_PacketHandler {
public:
    FCARcvr() : SRM_PacketHandler() { }
    virtual ~FCARcvr() { }
    virtual void recv(u_char *buf, int len);
};




#endif // MASH_FCA_MGR_H
