/*
 * p64_tcl.c --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

const char tk_init_tcl_code[] = "\
proc tk_butEnter w {\n\
 global tk_priv tk_strictMotif\n\
 if {[lindex [$w config -state] 4] != \"disabled\"} {\n\
 if {!$tk_strictMotif} {\n\
 $w config -state active\n\
 }\n\
 set tk_priv(window) $w\n\
 }\n\
}\n\
proc tk_butLeave w {\n\
 global tk_priv tk_strictMotif\n\
 if {[lindex [$w config -state] 4] != \"disabled\"} {\n\
 if {!$tk_strictMotif} {\n\
 $w config -state normal\n\
 }\n\
 }\n\
 set tk_priv(window) \"\"\n\
}\n\
proc tk_butDown w {\n\
 global tk_priv\n\
 set tk_priv(relief) [lindex [$w config -relief] 4]\n\
 set tk_priv(buttonWindow) $w\n\
 if {[lindex [$w config -state] 4] != \"disabled\"} {\n\
 $w config -relief sunken\n\
 }\n\
}\n\
proc tk_butUp w {\n\
 global tk_priv\n\
 if {$w == $tk_priv(buttonWindow)} {\n\
 $w config -relief $tk_priv(relief)\n\
 if {($w == $tk_priv(window))\n\
 && ([lindex [$w config -state] 4] != \"disabled\")} {\n\
 uplevel #0 [list $w invoke]\n\
 }\n\
 set tk_priv(buttonWindow) \"\"\n\
 }\n\
}\n\
proc tk_entryBackspace w {\n\
 set x [expr {[$w index insert] - 1}]\n\
 if {$x != -1} {$w delete $x}\n\
}\n\
proc tk_entryBackword w {\n\
 set string [$w get]\n\
 set curs [expr [$w index insert]-1]\n\
 if {$curs < 0} return\n\
 for {set x $curs} {$x > 0} {incr x -1} {\n\
 if {([string first [string index $string $x] \" \\t\"] < 0)\n\
 && ([string first [string index $string [expr $x-1]] \" \\t\"]\n\
 >= 0)} {\n\
 break\n\
 }\n\
 }\n\
 $w delete $x $curs\n\
}\n\
proc tk_entrySeeCaret w {\n\
 set c [$w index insert]\n\
 set left [$w index @0]\n\
 if {$left >= $c} {\n\
 if {$c > 0} {\n\
 $w view [expr $c-1]\n\
 } else {\n\
 $w view $c\n\
 }\n\
 return\n\
 }\n\
 while {([$w index @[expr [winfo width $w]-5]] < $c)\n\
 && ($left < $c)} {\n\
 set left [expr $left+1]\n\
 $w view $left\n\
 }\n\
}\n\
proc tk_listboxSingleSelect args {\n\
 foreach w $args {\n\
 bind $w <B1-Motion> {%W select from [%W nearest %y]} \n\
 bind $w <Shift-1> {%W select from [%W nearest %y]}\n\
 bind $w <Shift-B1-Motion> {%W select from [%W nearest %y]}\n\
 }\n\
}\n\
proc tk_menuBar {w args} {\n\
 global tk_priv\n\
 if {$args == \"\"} {\n\
 if [catch {set menus $tk_priv(menusFor$w)}] {\n\
 return \"\"\n\
 }\n\
 return $menus\n\
 }\n\
 if [info exists tk_priv(menusFor$w)] {\n\
 unset tk_priv(menusFor$w)\n\
 unset tk_priv(menuBarFor[winfo toplevel $w])\n\
 }\n\
 if {$args == \"{}\"} {\n\
 return\n\
 }\n\
 set tk_priv(menusFor$w) $args\n\
 set tk_priv(menuBarFor[winfo toplevel $w]) $w\n\
 bind $w <Any-Alt-KeyPress> {tk_traverseToMenu %W %A}\n\
 bind $w <F10> {tk_firstMenu %W}\n\
 bind $w <Any-ButtonRelease-1> tk_mbUnpost\n\
}\n\
proc tk_menus {w args} {\n\
 error \"tk_menus is obsolete in Tk versions 3.0 and later; please change your scripts to use tk_menuBar instead\"\n\
}\n\
proc tk_bindForTraversal args {\n\
 foreach w $args {\n\
 bind $w <Any-Alt-KeyPress> {tk_traverseToMenu %W %A}\n\
 bind $w <F10> {tk_firstMenu %W}\n\
 }\n\
}\n\
proc tk_mbPost {w} {\n\
 global tk_priv tk_strictMotif\n\
 if {[lindex [$w config -state] 4] == \"disabled\"} {\n\
 return\n\
 }\n\
 if {$w == $tk_priv(posted)} {\n\
 grab -global $tk_priv(grab)\n\
 return\n\
 }\n\
 set menu [lindex [$w config -menu] 4]\n\
 if {$menu == \"\"} {\n\
 return\n\
 }\n\
 if ![string match $w* $menu] {\n\
 error \"can't post $menu:  it isn't a descendant of $w (this is a new requirement in Tk versions 3.0 and later)\"\n\
 }\n\
 set cur $tk_priv(posted)\n\
 if {$cur != \"\"} tk_mbUnpost\n\
 set tk_priv(relief) [lindex [$w config -relief] 4]\n\
 $w config -relief raised\n\
 set tk_priv(posted) $w\n\
 if {$tk_priv(focus) == \"\"} {\n\
 set tk_priv(focus) [focus]\n\
 }\n\
 set tk_priv(activeBg) [lindex [$menu config -activebackground] 4]\n\
 set tk_priv(activeFg) [lindex [$menu config -activeforeground] 4]\n\
 if $tk_strictMotif {\n\
 $menu config -activebackground [lindex [$menu config -background] 4]\n\
 $menu config -activeforeground [lindex [$menu config -foreground] 4]\n\
 }\n\
 $menu activate none\n\
 focus $menu\n\
 $menu post [winfo rootx $w] [expr [winfo rooty $w]+[winfo height $w]]\n\
 if [catch {set grab $tk_priv(menuBarFor[winfo toplevel $w])}] {\n\
 set grab $w\n\
 } else {\n\
 if [lsearch $tk_priv(menusFor$grab) $w]<0 {\n\
 set grab $w\n\
 }\n\
 }\n\
 set tk_priv(cursor) [lindex [$grab config -cursor] 4]\n\
 $grab config -cursor arrow\n\
 set tk_priv(grab) $grab\n\
 grab -global $grab\n\
}\n\
proc tk_mbUnpost {} {\n\
 global tk_priv\n\
 set w $tk_priv(posted)\n\
 if {$w != \"\"} {\n\
 catch {\n\
 set menu [lindex [$w config -menu] 4]\n\
 $menu unpost\n\
 $menu config -activebackground $tk_priv(activeBg)\n\
 $menu config -activeforeground $tk_priv(activeFg)\n\
 $w config -relief $tk_priv(relief)\n\
 }\n\
 catch {$tk_priv(grab) config -cursor $tk_priv(cursor)}\n\
 catch {focus $tk_priv(focus)}\n\
 grab release $tk_priv(grab)\n\
 set tk_priv(grab) \"\"\n\
 set tk_priv(focus) \"\"\n\
 set tk_priv(posted) {}\n\
 }\n\
}\n\
proc tk_traverseToMenu {w char} {\n\
 global tk_priv\n\
 if {$char == \"\"} {\n\
 return\n\
 }\n\
 set char [string tolower $char]\n\
 foreach mb [tk_getMenuButtons $w] {\n\
 if {[winfo class $mb] == \"Menubutton\"} {\n\
 set char2 [string index [lindex [$mb config -text] 4] \\\n\
 [lindex [$mb config -underline] 4]]\n\
 if {[string compare $char [string tolower $char2]] == 0} {\n\
 tk_mbPost $mb\n\
 [lindex [$mb config -menu] 4] activate 0\n\
 return\n\
 }\n\
 }\n\
 }\n\
}\n\
proc tk_traverseWithinMenu {w char} {\n\
 if {$char == \"\"} {\n\
 return\n\
 }\n\
 set char [string tolower $char]\n\
 set last [$w index last]\n\
 if {$last == \"none\"} {\n\
 return\n\
 }\n\
 for {set i 0} {$i <= $last} {incr i} {\n\
 if [catch {set char2 [string index \\\n\
 [lindex [$w entryconfig $i -label] 4] \\\n\
 [lindex [$w entryconfig $i -underline] 4]]}] {\n\
 continue\n\
 }\n\
 if {[string compare $char [string tolower $char2]] == 0} {\n\
 tk_mbUnpost\n\
 $w invoke $i\n\
 return\n\
 }\n\
 }\n\
}\n\
proc tk_getMenuButtons w {\n\
 global tk_priv\n\
 set top [winfo toplevel $w]\n\
 if [catch {set bar [set tk_priv(menuBarFor$top)]}] {\n\
 return \"\"\n\
 }\n\
 return $tk_priv(menusFor$bar)\n\
}\n\
proc tk_nextMenu count {\n\
 global tk_priv\n\
 if {$tk_priv(posted) == \"\"} {\n\
 return\n\
 }\n\
 set buttons [tk_getMenuButtons $tk_priv(posted)]\n\
 set length [llength $buttons]\n\
 for {set i 0} 1 {incr i} {\n\
 if {$i >= $length} {\n\
 return\n\
 }\n\
 if {[lindex $buttons $i] == $tk_priv(posted)} {\n\
 break\n\
 }\n\
 }\n\
 incr i $count\n\
 while 1 {\n\
 while {$i < 0} {\n\
 incr i $length\n\
 }\n\
 while {$i >= $length} {\n\
 incr i -$length\n\
 }\n\
 set mb [lindex $buttons $i]\n\
 if {[lindex [$mb configure -state] 4] != \"disabled\"} {\n\
 break\n\
 }\n\
 incr i $count\n\
 }\n\
 tk_mbUnpost\n\
 tk_mbPost $mb\n\
 [lindex [$mb config -menu] 4] activate 0\n\
}\n\
proc tk_nextMenuEntry count {\n\
 global tk_priv\n\
 if {$tk_priv(posted) == \"\"} {\n\
 return\n\
 }\n\
 set menu [lindex [$tk_priv(posted) config -menu] 4]\n\
 if {[$menu index last] == \"none\"} {\n\
 return\n\
 }\n\
 set length [expr [$menu index last]+1]\n\
 set i [$menu index active]\n\
 if {$i == \"none\"} {\n\
 set i 0\n\
 } else {\n\
 incr i $count\n\
 }\n\
 while 1 {\n\
 while {$i < 0} {\n\
 incr i $length\n\
 }\n\
 while {$i >= $length} {\n\
 incr i -$length\n\
 }\n\
 if {[catch {$menu entryconfigure $i -state} state] == 0} {\n\
 if {[lindex $state 4] != \"disabled\"} {\n\
 break\n\
 }\n\
 }\n\
 incr i $count\n\
 }\n\
 $menu activate $i\n\
}\n\
proc tk_invokeMenu {menu} {\n\
 set i [$menu index active]\n\
 if {$i != \"none\"} {\n\
 tk_mbUnpost\n\
 update idletasks\n\
 $menu invoke $i\n\
 }\n\
}\n\
proc tk_firstMenu w {\n\
 set mb [lindex [tk_getMenuButtons $w] 0]\n\
 if {$mb != \"\"} {\n\
 tk_mbPost $mb\n\
 [lindex [$mb config -menu] 4] activate 0\n\
 }\n\
}\n\
proc tk_mbButtonDown w {\n\
 global tk_priv\n\
 if {[lindex [$w config -state] 4] == \"disabled\"} {\n\
 return\n\
 }\n\
 if {$tk_priv(inMenuButton) == $w} {\n\
 tk_mbPost $w\n\
 }\n\
}\n\
proc tk_textSelectTo {w index} {\n\
 global tk_priv\n\
 case $tk_priv(selectMode) {\n\
 char {\n\
 if [$w compare $index < anchor] {\n\
 set first $index\n\
 set last anchor\n\
 } else {\n\
 set first anchor\n\
 set last [$w index $index+1c]\n\
 }\n\
 }\n\
 word {\n\
 if [$w compare $index < anchor] {\n\
 set first [$w index \"$index wordstart\"]\n\
 set last [$w index \"anchor wordend\"]\n\
 } else {\n\
 set first [$w index \"anchor wordstart\"]\n\
 set last [$w index \"$index wordend\"]\n\
 }\n\
 }\n\
 line {\n\
 if [$w compare $index < anchor] {\n\
 set first [$w index \"$index linestart\"]\n\
 set last [$w index \"anchor lineend + 1c\"]\n\
 } else {\n\
 set first [$w index \"anchor linestart\"]\n\
 set last [$w index \"$index lineend + 1c\"]\n\
 }\n\
 }\n\
 }\n\
 $w tag remove sel 0.0 $first\n\
 $w tag add sel $first $last\n\
 $w tag remove sel $last end\n\
}\n\
proc tk_textBackspace w {\n\
 $w delete insert-1c insert\n\
}\n\
proc tk_textIndexCloser {w a b c} {\n\
 set a [$w index $a]\n\
 set b [$w index $b]\n\
 set c [$w index $c]\n\
 if [$w compare $a <= $b] {\n\
 return 1\n\
 }\n\
 if [$w compare $a >= $c] {\n\
 return 0\n\
 }\n\
 scan $a \"%d.%d\" lineA chA\n\
 scan $b \"%d.%d\" lineB chB\n\
 scan $c \"%d.%d\" lineC chC\n\
 if {$chC == 0} {\n\
 incr lineC -1\n\
 set chC [string length [$w get $lineC.0 $lineC.end]]\n\
 }\n\
 if {$lineB != $lineC} {\n\
 return [expr {($lineA-$lineB) < ($lineC-$lineA)}]\n\
 }\n\
 return [expr {($chA-$chB) < ($chC-$chA)}]\n\
}\n\
proc tk_textResetAnchor {w index} {\n\
 global tk_priv\n\
 if {[$w tag ranges sel] == \"\"} {\n\
 set tk_priv(selectMode) char\n\
 $w mark set anchor $index\n\
 return\n\
 }\n\
 if [tk_textIndexCloser $w $index sel.first sel.last] {\n\
 if {$tk_priv(selectMode) == \"char\"} {\n\
 $w mark set anchor sel.last\n\
 } else {\n\
 $w mark set anchor sel.last-1c\n\
 }\n\
 } else {\n\
 $w mark set anchor sel.first\n\
 }\n\
}\n\
scan [info tclversion] \"%d.%d\" a b\n\
if {$a != 7} {\n\
 error \"wrong version of Tcl loaded ([info tclversion]): need 7.x\"\n\
}\n\
scan $tk_version \"%d.%d\" a b\n\
if {($a != 3) || ($b < 3)} {\n\
 error \"wrong version of Tk loaded ($tk_version): need 3.3 or later\"\n\
}\n\
unset a b\n\
lappend auto_path $tk_library\n\
set tk_strictMotif 0\n\
bind Button <Any-Enter> {tk_butEnter %W}\n\
bind Button <Any-Leave> {tk_butLeave %W}\n\
bind Button <1> {tk_butDown %W}\n\
bind Button <ButtonRelease-1> {tk_butUp %W}\n\
bind Checkbutton <Any-Enter> {tk_butEnter %W}\n\
bind Checkbutton <Any-Leave> {tk_butLeave %W}\n\
bind Checkbutton <1> {tk_butDown %W}\n\
bind Checkbutton <ButtonRelease-1> {tk_butUp %W}\n\
bind Radiobutton <Any-Enter> {tk_butEnter %W}\n\
bind Radiobutton <Any-Leave> {tk_butLeave %W}\n\
bind Radiobutton <1> {tk_butDown %W}\n\
bind Radiobutton <ButtonRelease-1> {tk_butUp %W}\n\
bind Entry <1> {\n\
 %W icursor @%x\n\
 %W select from @%x\n\
 if {[lindex [%W config -state] 4] == \"normal\"} {focus %W}\n\
}\n\
bind Entry <B1-Motion> {%W select to @%x}\n\
bind Entry <Shift-1> {%W select adjust @%x}\n\
bind Entry <Shift-B1-Motion> {%W select to @%x}\n\
bind Entry <2> {%W scan mark %x}\n\
bind Entry <B2-Motion> {%W scan dragto %x}\n\
bind Entry <Any-KeyPress> {\n\
 if {\"%A\" != \"\"} {\n\
 %W insert insert %A\n\
 tk_entrySeeCaret %W\n\
 }\n\
}\n\
bind Entry <Delete> {tk_entryBackspace %W; tk_entrySeeCaret %W}\n\
bind Entry <BackSpace> {tk_entryBackspace %W; tk_entrySeeCaret %W}\n\
bind Entry <Control-h> {tk_entryBackspace %W; tk_entrySeeCaret %W}\n\
bind Entry <Control-d> {%W delete sel.first sel.last; tk_entrySeeCaret %W}\n\
bind Entry <Control-u> {%W delete 0 end}\n\
bind Entry <Control-v> {%W insert insert [selection get]; tk_entrySeeCaret %W}\n\
bind Entry <Control-w> {tk_entryBackword %W; tk_entrySeeCaret %W}\n\
tk_bindForTraversal Entry\n\
bind Listbox <1> {%W select from [%W nearest %y]}\n\
bind Listbox <B1-Motion> {%W select to [%W nearest %y]}\n\
bind Listbox <Shift-1> {%W select adjust [%W nearest %y]}\n\
bind Listbox <Shift-B1-Motion> {%W select to [%W nearest %y]}\n\
bind Listbox <2> {%W scan mark %x %y}\n\
bind Listbox <B2-Motion> {%W scan dragto %x %y}\n\
bind Scrollbar <Any-Enter> {\n\
 if $tk_strictMotif {\n\
 set tk_priv(activeFg) [lindex [%W config -activeforeground] 4]\n\
 %W config -activeforeground [lindex [%W config -foreground] 4]\n\
 }\n\
}\n\
bind Scrollbar <Any-Leave> {\n\
 if {$tk_strictMotif && ($tk_priv(buttons) == 0)} {\n\
 %W config -activeforeground $tk_priv(activeFg)\n\
 }\n\
}\n\
bind Scrollbar <Any-ButtonPress> {incr tk_priv(buttons)}\n\
bind Scrollbar <Any-ButtonRelease> {incr tk_priv(buttons) -1}\n\
bind Scale <Any-Enter> {\n\
 if $tk_strictMotif {\n\
 set tk_priv(activeFg) [lindex [%W config -activeforeground] 4]\n\
 %W config -activeforeground [lindex [%W config -sliderforeground] 4]\n\
 }\n\
}\n\
bind Scale <Any-Leave> {\n\
 if {$tk_strictMotif && ($tk_priv(buttons) == 0)} {\n\
 %W config -activeforeground $tk_priv(activeFg)\n\
 }\n\
}\n\
bind Scale <Any-ButtonPress> {incr tk_priv(buttons)}\n\
bind Scale <Any-ButtonRelease> {incr tk_priv(buttons) -1}\n\
bind Menubutton <Any-Enter> {\n\
 set tk_priv(inMenuButton) %W\n\
 if {[lindex [%W config -state] 4] != \"disabled\"} {\n\
 if {!$tk_strictMotif} {\n\
 %W config -state active\n\
 }\n\
 }\n\
}\n\
bind Menubutton <Any-Leave> {\n\
 set tk_priv(inMenuButton) {}\n\
 if {[lindex [%W config -state] 4] == \"active\"} {\n\
 %W config -state normal\n\
 }\n\
}\n\
bind Menubutton <1> {tk_mbButtonDown %W}\n\
bind Menubutton <Any-ButtonRelease-1> {\n\
 if {($tk_priv(posted) == \"%W\") && ($tk_priv(inMenuButton) == \"%W\")} {\n\
 [lindex [$tk_priv(posted) config -menu] 4] activate 0\n\
 } else {\n\
 tk_mbUnpost\n\
 }\n\
}\n\
bind Menubutton <B1-Enter> {\n\
 set tk_priv(inMenuButton) %W\n\
 if {([lindex [%W config -state] 4] != \"disabled\")\n\
 && ($tk_priv(posted) != \"\")} {\n\
 if {!$tk_strictMotif} {\n\
 %W config -state active\n\
 }\n\
 tk_mbPost %W\n\
 }\n\
}\n\
bind Menubutton <2> {\n\
 if {($tk_priv(posted) == \"\")\n\
 && ([lindex [%W config -state] 4] != \"disabled\")} {\n\
 set tk_priv(dragging) %W\n\
 [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y\n\
 }\n\
}\n\
bind Menubutton <B2-Motion> {\n\
 if {$tk_priv(dragging) != \"\"} {\n\
 [lindex [$tk_priv(dragging) config -menu] 4] post %X %Y\n\
 }\n\
}\n\
bind Menubutton <ButtonRelease-2> {set tk_priv(dragging) \"\"}\n\
bind Menu <Any-Enter> {set tk_priv(window) %W; %W activate @%y}\n\
bind Menu <Any-Leave> {set tk_priv(window) {}; %W activate none}\n\
bind Menu <Any-Motion> {\n\
 if {$tk_priv(window) == \"%W\"} {\n\
 %W activate @%y\n\
 }\n\
}\n\
bind Menu <1> {\n\
 if {$tk_priv(grab) != \"\"} {\n\
 grab $tk_priv(grab)\n\
 }\n\
}\n\
bind Menu <ButtonRelease-1> {tk_invokeMenu %W}\n\
bind Menu <2> {set tk_priv(x) %x; set tk_priv(y) %y}\n\
bind Menu <B2-Motion> {\n\
 if {$tk_priv(posted) == \"\"} {\n\
 %W post [expr %X-$tk_priv(x)] [expr %Y-$tk_priv(y)]\n\
 }\n\
}\n\
bind Menu <B2-Leave> { }\n\
bind Menu <B2-Enter> { }\n\
bind Menu <Escape> {tk_mbUnpost}\n\
bind Menu <Any-KeyPress> {tk_traverseWithinMenu %W %A}\n\
bind Menu <Left> {tk_nextMenu -1}\n\
bind Menu <Right> {tk_nextMenu 1}\n\
bind Menu <Up> {tk_nextMenuEntry -1}\n\
bind Menu <Down> {tk_nextMenuEntry 1}\n\
bind Menu <Return> {tk_invokeMenu %W}\n\
bind Text <1> {\n\
 set tk_priv(selectMode) char\n\
 %W mark set insert @%x,%y\n\
 %W mark set anchor insert\n\
 if {[lindex [%W config -state] 4] == \"normal\"} {focus %W}\n\
}\n\
bind Text <Double-1> {\n\
 set tk_priv(selectMode) word\n\
 %W mark set insert \"@%x,%y wordstart\"\n\
 tk_textSelectTo %W insert\n\
}\n\
bind Text <Triple-1> {\n\
 set tk_priv(selectMode) line\n\
 %W mark set insert \"@%x,%y linestart\"\n\
 tk_textSelectTo %W insert\n\
}\n\
bind Text <B1-Motion> {tk_textSelectTo %W @%x,%y}\n\
bind Text <Shift-1> {\n\
 tk_textResetAnchor %W @%x,%y\n\
 tk_textSelectTo %W @%x,%y\n\
}\n\
bind Text <Shift-B1-Motion> {tk_textSelectTo %W @%x,%y}\n\
bind Text <2> {%W scan mark %y}\n\
bind Text <B2-Motion> {%W scan dragto %y}\n\
bind Text <Any-KeyPress> {\n\
 if {\"%A\" != \"\"} {\n\
 %W insert insert %A\n\
 %W yview -pickplace insert\n\
 }\n\
}\n\
bind Text <Return> {%W insert insert \\n; %W yview -pickplace insert}\n\
bind Text <BackSpace> {tk_textBackspace %W; %W yview -pickplace insert}\n\
bind Text <Delete> {tk_textBackspace %W; %W yview -pickplace insert}\n\
bind Text <Control-h> {tk_textBackspace %W; %W yview -pickplace insert}\n\
bind Text <Control-d> {%W delete sel.first sel.last}\n\
bind Text <Control-v> {\n\
 %W insert insert [selection get]\n\
 %W yview -pickplace insert\n\
}\n\
tk_bindForTraversal Text\n\
set tk_priv(buttons) 0\n\
set tk_priv(buttonWindow) {}\n\
set tk_priv(dragging) {}\n\
set tk_priv(focus) {}\n\
set tk_priv(grab) {}\n\
set tk_priv(inMenuButton) {}\n\
set tk_priv(posted) {}\n\
set tk_priv(selectMode) char\n\
set tk_priv(window) {}\n\
proc tkerror err {\n\
 global errorInfo\n\
 set info $errorInfo\n\
 if {[tk_dialog .tkerrorDialog \"Error in Tcl Script\" \\\n\
 \"Error: $err\" error 0 OK \"See Stack Trace\"] == 0} {\n\
 return\n\
 }\n\
 set w .tkerrorTrace\n\
 catch {destroy $w}\n\
 toplevel $w -class ErrorTrace\n\
 wm minsize $w 1 1\n\
 wm title $w \"Stack Trace for Error\"\n\
 wm iconname $w \"Stack Trace\"\n\
 button $w.ok -text OK -command \"destroy $w\"\n\
 text $w.text -relief raised -bd 2 -yscrollcommand \"$w.scroll set\" \\\n\
 -setgrid true -width 40 -height 10\n\
 scrollbar $w.scroll -relief flat -command \"$w.text yview\"\n\
 pack $w.ok -side bottom -padx 3m -pady 3m -ipadx 2m -ipady 1m\n\
 pack $w.scroll -side right -fill y\n\
 pack $w.text -side left -expand yes -fill both\n\
 $w.text insert 0.0 $info\n\
 $w.text mark set insert 0.0\n\
 wm withdraw $w\n\
 update idletasks\n\
 set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \\\n\
 - [winfo vrootx [winfo parent $w]]]\n\
 set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \\\n\
 - [winfo vrooty [winfo parent $w]]]\n\
 wm geom $w +$x+$y\n\
 wm deiconify $w\n\
}\n\
";
const char p64_tcl_code[] = "\
proc build { width height } {\n\
	video .video $width $height\n\
	pack append . .video { top }\n\
	return .video\n\
}\n\
";
