/*
 * encoder-mp3.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1995-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/audio/encoder-mp3.cc,v 1.2 2002/02/03 03:10:46 lim Exp $ (LBL)";

#include "config.h"
#include "rtp.h"
#include "encoder.h"
#include "pktbuf-rtp.h"
extern "C" {
#include "../../lame/include/lame.h"
}

class MP3Encoder : public PCM_Encoder {
public:
	MP3Encoder();
        ~MP3Encoder();
	lame_global_flags *gfp;
  	short int R_Buffer[1152];
        unsigned char mp3buffer[16384];
        u_int32_t mp3ts;
        int bitrate, samplerate;
	virtual void encode(u_int32_t ts, u_int8_t* samples, int cc);
};

static class MP3EncoderClass : public TclClass {
public:
	MP3EncoderClass() : TclClass("Module/AudioEncoder/MP3") {}
	TclObject* create(int /* argc */, const char*const* /* argv */) {
		return (new MP3Encoder);
	}
} mp3_encoder_class;


MP3Encoder::MP3Encoder()
{
	gfp = lame_init();
        Tcl& tcl = Tcl::instance();
        tcl.evalf("[Application instance] get_option sampleRate");
	samplerate = atoi(tcl.result());
        tcl.evalf("[Application instance] get_option bitRate");
	bitrate = atoi(tcl.result());
	lame_set_num_channels(gfp,1);
	lame_set_in_samplerate(gfp,samplerate);
	lame_set_brate(gfp,bitrate);
	lame_set_mode(gfp,MONO);
	int ret_code = lame_init_params(gfp);
	if (ret_code < 0)
	  fprintf(stderr, "error initializing lame encoder!\n");
	lame_print_config(gfp);
	bzero(R_Buffer, 2304); // 2 bytes/sample * 1152 samples
}

void MP3Encoder::encode(u_int32_t ts, u_int8_t* frame, int len)
{
	int imp3;
	int nsamp = len/2;

	imp3 = lame_encode_buffer(gfp, (short int*)frame, R_Buffer, nsamp,
				  mp3buffer, 16384);

	register int marker = (ts != last_ts_) ? htons(RTP_M) : 0;
	last_ts_ = ts + len;

	// should check that it is less than sizeof(pb->data)
	if (imp3 <= 0)
		return;
	
	if (marker != 0)
	  mp3ts = ts;
	else
	  mp3ts += 2304;

	pktbuf* pb = pool_->alloc(mp3ts, RTP_PT_MP3);
	rtphdr* rh = (rtphdr*)pb->data;
	rh->rh_flags |= marker;
	u_int8_t* o = (u_int8_t*)(rh + 1);
	
	memcpy(o, mp3buffer, imp3);
	pb->len = imp3 + sizeof(*rh);
	target_->recv(pb);
}

MP3Encoder::~MP3Encoder()
{
	lame_close(gfp);
}
