#
# plugin.sql site plugin definition
#

#
# Cleanup
#
DELETE FROM s_site_plugin WHERE site_type = 'amazonuk';
DELETE FROM s_site_plugin_conf WHERE site_type = 'amazonuk';
DELETE FROM s_site_plugin_input_field WHERE site_type = 'amazonuk';
DELETE FROM s_site_plugin_link WHERE site_type = 'amazonuk';
DELETE FROM s_site_plugin_s_attribute_type_map WHERE site_type = 'amazonuk';
DELETE FROM s_site_plugin_s_attribute_type_lookup_map WHERE site_type = 'amazonuk';

INSERT INTO s_site_plugin (site_type, classname, order_no, title, image, description, external_url, items_per_page, more_info_url)
VALUES('amazonuk', 'amazonuk', 5, 'Amazon.co.uk', 'amazonuk.gif', 'A good source of CD, DVD (Region 2), VHS, Books, Games, etc.', 'http://www.amazon.co.uk', 25, 'http://www.amazon.co.uk/exec/obidos/ASIN/{amazukasin}');

#
# Input Fields
#	
INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('amazonuk', 'title', 1, '', 'Title Search', 'text', '', '{title}');

INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('amazonuk', 'amazukasin', 2, '', 'ASIN/ISBN Number', 'text', '', '{ifdef(amazukasin,{amazukasin},{if(s_item_type==BOOK,{isbn},\'\')})}');

#
# Configuration
#
INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonuk', 'item_type_to_index_map', '', 'CD', 'music');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonuk', 'item_type_to_index_map', '', 'MP3', 'music');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonuk', 'item_type_to_index_map', '', 'BOOK', 'books-uk');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonuk', 'item_type_to_index_map', '', 'GAME', 'video-games-uk');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonuk', 'item_type_to_index_map', '', 'VHS', 'vhs-uk');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonuk', 'item_type_to_index_map', '', 'DVD', 'dvd-uk');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonuk', 'item_type_to_index_map', '', 'VCD', 'dvd-uk');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonuk', 'item_type_to_index_map', '', 'DIVX', 'dvd-uk');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonuk', 'item_type_to_index_map', '', 'LD', 'dvd-uk');

#
# Links
#
INSERT INTO s_site_plugin_link(site_type, s_item_type_group, s_item_type, order_no, description, url, title_url)
VALUES('amazonuk', '*', '*', 1, 'More Info', 'http://www.amazon.co.uk/exec/obidos/ASIN/{amazukasin}', 'http://www.amazon.co.uk/exec/obidos/external-search?url=index={config_var_value(item_type_to_index_map, {s_item_type})}&keyword={title}');

INSERT INTO s_site_plugin_link(site_type, s_item_type_group, s_item_type, order_no, description, url, title_url)
VALUES('amazonuk', '*', 'GAME', 2, 'Screenshots', 'http://www.amazon.co.uk/exec/obidos/tg/stores/detail/-/videogames/{amazukasin}/pictures#more-pictures', NULL);

#
# site variable to s_attribute_type mapping
#
INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonuk', 'title', '*', '*', 'ALT_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonuk', 'title', '*', '*', 'S_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonuk', 'genre', 'VIDEO', '*', 'MOVIEGENRE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonuk', 'genre', 'AUDIO', '*', 'MUSICGENRE');
	
INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonuk', 'genre', '*', 'BOOK', 'BOOKGENRE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonuk', 'genre', '*', 'GAME', 'GAMEGENRE');
	
INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonuk', 'blurb', 'VIDEO', '*', 'MOVIE_PLOT');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonuk', 'blurb', 'AUDIO', '*', 'COMMENTS');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonuk', 'blurb', '*', 'BOOK', 'COMMENTS');	

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonuk', 'listprice', 'VIDEO', '*', 'RET_PRICE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonuk', 'listprice', '*', '*', 'COVERPRICE');


#
# site variable to s_attribute_type_lookup mapping
#
INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonuk', 'AUDIO_LANG', 'Dolby Digital Surround', 'ENGLISH_SR' ); 

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'AGE_RATING', '18', 'R');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'AGE_RATING', '15', 'MA');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'AGE_RATING', '12', 'M');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'AGE_RATING', 'U', 'G');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'AGE_RATING', 'E', 'NR');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'BOOKGENRE', 'Children\'s Books', 'Children');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonuk', 'BOOKGENRE', 'Cosmetics, make-up & skin care', 'Reference' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazonuk', 'BOOKGENRE', 'Health and Hygiene', 'Reference' ); 

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'GAMESYSTEM', 'PlayStation', 'PS1');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'GAMESYSTEM', 'PlayStation2', 'PS2');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'GAMESYSTEM', 'Sega Dreamcast', 'DREAMCAST');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'GAMESYSTEM', 'Nintendo 64', 'N64');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'GAMESYSTEM', 'GameCube', 'GAMECUBE');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'GAMESYSTEM', 'Xbox', 'XBOX');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'GAMESYSTEM', 'Game Boy Color', 'GAMEBOY');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'GAMESYSTEM', 'Game Boy', 'GAMEBOY');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'GAMESYSTEM', 'Game Boy Advance', 'GAMEBOYADVANCE');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'GAMESYSTEM', 'Mac OS', 'MACCDROM');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazonuk', 'GAMESYSTEM', 'Windows', 'PCCDROM');

####################################################################################################
# Item Type / Attribute Type relationships
####################################################################################################

INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'AMAZUKASIN', 'Amazon UK Standard Item Number', 'Amazon UK ASIN', 'hidden', 'hidden', NULL, 'amazonuk');

#
# Link to DVD, VHS, etc
#
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'AMAZUKASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'AMAZUKASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'AMAZUKASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'AMAZUKASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'AMAZUKASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'AMAZUKASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'AMAZUKASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'AMAZUKASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'MP3', 'AMAZUKASIN', '0',NULL, NULL); 

#
# Extra attribute, you must explicitly link into particular item types.
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'ELSPARATED', 'ELSPA Video and Computer Game Rating', 'ELSPA Rating', 'radio_grid(%img% %display%, 4)', 'display(%img% %display%, list-link)', NULL, NULL);

INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'ELSPARATED', '0', '3+', 'Everyone', '', 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'ELSPARATED', '1', '11+', 'Teen', '', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'ELSPARATED', '2', '15+', 'Mature', '', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'ELSPARATED', '3', '18+', 'Adults Only', '', NULL);
