// TopologyLocalOperationsDoc.cpp : implementation of the CTopologyLocalOperationsDoc class
//

#include "stdafx.h"

#include "TopologyLocalOperationsDoc.h"

#include "TopologyLocalOperationsApp.h"
#include "ResultDialog.h"

#include <AIS_ListOfInteractive.hxx>
#include <AIS_ListIteratorOfListOfInteractive.hxx>


/////////////////////////////////////////////////////////////////////////////
// CTopologyLocalOperationsDoc

IMPLEMENT_DYNCREATE(CTopologyLocalOperationsDoc, CDocument)

BEGIN_MESSAGE_MAP(CTopologyLocalOperationsDoc, OCC_3dBaseDoc)
	//{{AFX_MSG_MAP(CTopologyLocalOperationsDoc)
	ON_COMMAND(ID_PRISM, OnPrism)
	ON_COMMAND(ID_REVOL, OnRevol)
	ON_COMMAND(ID_GLUE, OnGlue)
 	ON_COMMAND(ID_DPRISM, OnDprism)
 	ON_COMMAND(ID_Pipe, OnPipe)
	ON_COMMAND(ID_LINEAR, OnLinear)
	ON_COMMAND(ID_SPLIT, OnSplit)
	ON_COMMAND(ID_THICK, OnThick)
	ON_COMMAND(ID_OFFSET, OnOffset)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTopologyLocalOperationsDoc construction/destruction

CTopologyLocalOperationsDoc::CTopologyLocalOperationsDoc()
{
	myAISContext->SetDisplayMode(AIS_Shaded,Standard_False);
}

CTopologyLocalOperationsDoc::~CTopologyLocalOperationsDoc()
{
}

/////////////////////////////////////////////////////////////////////////////
// CTopologyLocalOperationsDoc diagnostics

#ifdef _DEBUG
void CTopologyLocalOperationsDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CTopologyLocalOperationsDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

//
// BRepFeat_MakePrism
//
void CTopologyLocalOperationsDoc::OnPrism() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	TopoDS_Shape S = BRepPrimAPI_MakeBox(400.,250.,300.);
	Handle(AIS_Shape) ais1 = new AIS_Shape(S);

	myAISContext->SetColor(ais1,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);
	myAISContext->SetCurrentObject(ais1,Standard_False);
	Fit();
	Sleep(500);

	TopExp_Explorer Ex;
	Ex.Init(S,TopAbs_FACE);
	Ex.Next();
	TopoDS_Face F = TopoDS::Face(Ex.Current());
	Handle(Geom_Surface) surf = BRep_Tool::Surface(F);
	Handle(Geom_Plane) Pl = Handle(Geom_Plane)::DownCast(surf);
	gp_Dir D = Pl->Pln().Axis().Direction();
// new in 2.0 ..use the trigonometric orientation to make the extrusion.
	D.Reverse();
	gp_Pnt2d p1,p2;
	Handle(Geom2d_Curve) aline;
	BRepBuilderAPI_MakeWire MW;
	p1 = gp_Pnt2d(200.,-100.);
	p2 = gp_Pnt2d(100.,-100.);
	aline = GCE2d_MakeLine(p1,p2).Value();
	MW.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));
	p1 = p2;
	p2 = gp_Pnt2d(100.,-200.);
	aline = GCE2d_MakeLine(p1,p2).Value();
	MW.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));
	p1 = p2;
	p2 = gp_Pnt2d(200.,-200.);
	aline = GCE2d_MakeLine(p1,p2).Value();
	MW.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));
	p1 = p2;
	p2 = gp_Pnt2d(200.,-100.);
	aline = GCE2d_MakeLine(p1,p2).Value();
	MW.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));
	BRepBuilderAPI_MakeFace MKF;
	MKF.Init(surf,Standard_False);
	MKF.Add(MW.Wire());
	TopoDS_Shape FP = MKF.Face();
	BRepLib::BuildCurves3d(FP);
	BRepFeat_MakePrism MKP(S,FP,F,D,0,Standard_True);
	MKP.Perform(200.);
	TopoDS_Shape res1 = MKP.Shape();
	ais1->Set(res1);

	myAISContext->Redisplay(ais1,Standard_False);
	myAISContext->SetCurrentObject(ais1,Standard_False);
	Fit();
	Sleep(500);

	Ex.Next();
	TopoDS_Face F2 = TopoDS::Face(Ex.Current());
	surf = BRep_Tool::Surface(F2);
	Pl = Handle(Geom_Plane)::DownCast(surf);
	D = Pl->Pln().Axis().Direction();
	D.Reverse();
	BRepBuilderAPI_MakeWire MW2;
	p1 = gp_Pnt2d(100.,100.);
	p2 = gp_Pnt2d(200.,100.);
	aline = GCE2d_MakeLine(p1,p2).Value();
	MW2.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));
	p1 = p2;
	p2 = gp_Pnt2d(150.,200.);
	aline = GCE2d_MakeLine(p1,p2).Value();
	MW2.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));
	p1 = p2;
	p2 = gp_Pnt2d(100.,100.);
	aline = GCE2d_MakeLine(p1,p2).Value();
	MW2.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));
	BRepBuilderAPI_MakeFace MKF2;
	MKF2.Init(surf,Standard_False);
	MKF2.Add(MW2.Wire());
	FP = MKF2.Face();
	BRepLib::BuildCurves3d(FP);
	BRepFeat_MakePrism MKP2(res1,FP,F2,D,1,Standard_True);
	MKP2.Perform(100.);
	TopoDS_Shape res2 = MKP2.Shape();
	ais1->Set(res2);

	myAISContext->Redisplay(ais1);
	myAISContext->SetCurrentObject(ais1,Standard_False);
	Fit();

	TCollection_AsciiString Message ("\
	\n\
--- Extrusion ---\n\
	\n\
TopoDS_Shape S = BRepPrimAPI_MakeBox(400.,250.,300.);\n\
TopExp_Explorer Ex;\n\
Ex.Init(S,TopAbs_FACE);\n\
Ex.Next();\n\
TopoDS_Face F = TopoDS::Face(Ex.Current());\n\
Handle(Geom_Surface) surf = BRep_Tool::Surface(F);\n\
Handle(Geom_Plane) Pl = Handle(Geom_Plane)::DownCast(surf);\n\
gp_Dir D = Pl->Pln().Axis().Direction();\n\
D.Reverse();\n\
gp_Pnt2d p1,p2;\n\
Handle(Geom2d_Curve) aline;\n\
BRepBuilderAPI_MakeWire MW;\n\
p1 = gp_Pnt2d(200.,-100.);\n\
p2 = gp_Pnt2d(100.,-100.);\n\
aline = GCE2d_MakeLine(p1,p2).Value();\n\
MW.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));\n\
p1 = p2;\n\
p2 = gp_Pnt2d(100.,-200.);\n\
aline = GCE2d_MakeLine(p1,p2).Value();\n\
MW.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));\n\
p1 = p2;\n\
p2 = gp_Pnt2d(200.,-200.);\n\
aline = GCE2d_MakeLine(p1,p2).Value();\n\
MW.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));\n\
p1 = p2;\n\
p2 = gp_Pnt2d(200.,-100.);\n\
aline = GCE2d_MakeLine(p1,p2).Value();\n\
MW.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));\n\
BRepBuilderAPI_MakeFace MKF;\n\
MKF.Init(surf,Standard_False);\n\
MKF.Add(MW.Wire());\n\
TopoDS_Shape FP = MKF.Face();\n\
BRepLib::BuildCurves3d(FP);\n\
BRepFeat_MakePrism MKP(S,FP,F,D,0,Standard_True);\n\
MKP.Perform(200);\n\
TopoDS_Shape res1 = MKP.Shape();\n\
	\n");
		Message += "\n\
--- Protrusion --- \n\
\n\
Ex.Next();\n\
TopoDS_Face F2 = TopoDS::Face(Ex.Current());\n\
surf = BRep_Tool::Surface(F2);\n\
Pl = Handle(Geom_Plane)::DownCast(surf);\n\
D = Pl->Pln().Axis().Direction();\n\
D.Reverse();\n\
BRepBuilderAPI_MakeWire MW2;\n\
p1 = gp_Pnt2d(100.,100.);\n\
p2 = gp_Pnt2d(200.,100.);\n\
aline = GCE2d_MakeLine(p1,p2).Value();\n\
MW2.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));\n\
p1 = p2;\n\
p2 = gp_Pnt2d(150.,200.);\n\
aline = GCE2d_MakeLine(p1,p2).Value();\n\
MW2.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));\n\
p1 = p2;\n\
p2 = gp_Pnt2d(100.,100.);\n\
aline = GCE2d_MakeLine(p1,p2).Value();\n\
MW2.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));\n\
BRepBuilderAPI_MakeFace MKF2;\n\
MKF2.Init(surf,Standard_False);\n\
MKF2.Add(MW2.Wire());\n\
FP = MKF2.Face();\n\
BRepLib::BuildCurves3d(FP);\n\
BRepFeat_MakePrism MKP2(res1,FP,F2,D,1,Standard_True);\n\
MKP2.Perform(100.);\n\
TopoDS_Shape res2 = MKP2.Shape();\n\
	\n";
	PocessTextInDialog("Make an extrusion or a protrusion", Message);
}

//
// BRepFeat_MakeDPrism
//
void CTopologyLocalOperationsDoc::OnDprism() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TopoDS_Shape S = BRepPrimAPI_MakeBox(400.,250.,300.);
	Handle(AIS_Shape) ais1 = new AIS_Shape(S);

	myAISContext->SetColor(ais1,Quantity_NOC_RED,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	
	TopExp_Explorer Ex;
	Ex.Init(S,TopAbs_FACE);
	Ex.Next();
	Ex.Next();
	Ex.Next();
	Ex.Next();
	Ex.Next();
	TopoDS_Face F = TopoDS::Face(Ex.Current());
	Handle(Geom_Surface) surf = BRep_Tool::Surface(F);
	gp_Circ2d c(gp_Ax2d(gp_Pnt2d(200.,130.),gp_Dir2d(1.,0.)),50.);
	BRepBuilderAPI_MakeWire MW;
	Handle(Geom2d_Curve) aline = new Geom2d_Circle(c);
	MW.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,PI));
	MW.Add(BRepBuilderAPI_MakeEdge(aline,surf,PI,2.*PI));
	BRepBuilderAPI_MakeFace MKF;
	MKF.Init(surf,Standard_False);
	MKF.Add(MW.Wire());
	TopoDS_Face FP = MKF.Face();
	BRepLib::BuildCurves3d(FP);
	BRepFeat_MakeDPrism MKDP(S,FP,F,10*PI180,1,Standard_True);
	MKDP.Perform(200);
	TopoDS_Shape res1 = MKDP.Shape();

	myAISContext->Display(ais1,Standard_False);
	myAISContext->SetCurrentObject(ais1,Standard_False);
	Fit();
	Sleep(500);

	ais1->Set(res1);
	
	myAISContext->Redisplay(ais1,Standard_False);
	myAISContext->SetCurrentObject(ais1,Standard_False);

	Fit();

	TCollection_AsciiString Message ("\
	\n\
--- Protrusion with draft angle --- \n\
	\n\
TopoDS_Shape S = BRepPrimAPI_MakeBox(400.,250.,300.);\n\
TopExp_Explorer Ex;\n\
Ex.Init(S,TopAbs_FACE);\n\
Ex.Next();\n\
Ex.Next();\n\
Ex.Next();\n\
Ex.Next();\n\
Ex.Next();\n\
TopoDS_Face F = TopoDS::Face(Ex.Current());\n\
Handle(Geom_Surface) surf = BRep_Tool::Surface(F);\n\
gp_Circ2d c(gp_Ax2d(gp_Pnt2d(200.,130.),gp_Dir2d(1.,0.)),50.);\n\
BRepBuilderAPI_MakeWire MW;\n\
Handle(Geom2d_Curve) aline = new Geom2d_Circle(c);\n\
MW.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,PI));\n\
MW.Add(BRepBuilderAPI_MakeEdge(aline,surf,PI,2.*PI));\n\
BRepBuilderAPI_MakeFace MKF;\n\
MKF.Init(surf,Standard_False);\n\
MKF.Add(MW.Wire());\n\
TopoDS_Face FP = MKF.Face();\n\
BRepLib::BuildCurves3d(FP);\n\
BRepFeat_MakeDPrism MKDP(S,FP,F,10*PI180,1,Standard_True);\n\
MKDP.Perform(200);\n\
TopoDS_Shape res1 = MKDP.Shape();\n\
	\n");
	PocessTextInDialog("Make an extrusion or a protrusion with a draft angle", Message);
}

void CTopologyLocalOperationsDoc::OnRevol() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	TopoDS_Shape S = BRepPrimAPI_MakeBox(400.,250.,300.);

	Handle(AIS_Shape) ais1 = new AIS_Shape(S);
	
	myAISContext->SetColor(ais1,Quantity_NOC_CORAL,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);
	myAISContext->SetCurrentObject(ais1,Standard_False);
	Fit();
	Sleep(500);

	TopExp_Explorer Ex;
	Ex.Init(S,TopAbs_FACE);
	Ex.Next();
	Ex.Next();
	TopoDS_Face F1 = TopoDS::Face(Ex.Current());
	Handle(Geom_Surface) surf = BRep_Tool::Surface(F1);
	Handle (Geom_Plane) Pl = Handle(Geom_Plane)::DownCast(surf);
	gp_Ax1 D = gp::OX();
	BRepBuilderAPI_MakeWire MW1;
	gp_Pnt2d p1,p2;
	p1 = gp_Pnt2d(100.,100.);
	p2 = gp_Pnt2d(200.,100.);
	Handle(Geom2d_Line) aline = GCE2d_MakeLine(p1,p2).Value();
	MW1.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));
	p1 = p2;
	p2 = gp_Pnt2d(150.,200.);
	aline = GCE2d_MakeLine(p1,p2).Value();
	MW1.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));
	p1 = p2;
	p2 = gp_Pnt2d(100.,100.);
	aline = GCE2d_MakeLine(p1,p2).Value();
	MW1.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));
	BRepBuilderAPI_MakeFace MKF1;
	MKF1.Init(surf,Standard_False);
	MKF1.Add(MW1.Wire());
	TopoDS_Face FP = MKF1.Face();
	BRepLib::BuildCurves3d(FP);
	BRepFeat_MakeRevol MKrev(S,FP,F1,D,1,Standard_True);
	Ex.Next();
	Ex.Next();
	TopoDS_Face F2 = TopoDS::Face(Ex.Current());
	MKrev.Perform(F2);
	TopoDS_Shape res1 = MKrev.Shape();


	myAISContext->Remove(ais1);
	Handle(AIS_Shape) ais2 = new AIS_Shape(res1);
	myAISContext->Display(ais2,Standard_False);
	myAISContext->SetCurrentObject(ais2,Standard_False);
	Fit();

	TCollection_AsciiString Message ("\
	\n\
TopoDS_Shape S = BRepPrimAPI_MakeBox(400.,250.,300.);\n\
TopExp_Explorer Ex;\n\
Ex.Init(S,TopAbs_FACE);\n\
Ex.Next();\n\
Ex.Next();\n\
TopoDS_Face F1 = TopoDS::Face(Ex.Current());\n\
Handle(Geom_Surface) surf = BRep_Tool::Surface(F1);\n\
Handle (Geom_Plane) Pl = Handle(Geom_Plane)::DownCast(surf);\n\
gp_Ax1 D = gp::OX();\n\
BRepBuilderAPI_MakeWire MW1;\n\
gp_Pnt2d p1,p2;\n\
p1 = gp_Pnt2d(100.,100.);\n\
p2 = gp_Pnt2d(200.,100.);\n\
Handle(Geom2d_Line) aline = GCE2d_MakeLine(p1,p2).Value();\n\
MW1.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));\n\
p1 = p2;\n\
p2 = gp_Pnt2d(150.,200.);\n\
aline = GCE2d_MakeLine(p1,p2).Value();\n\
MW1.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));\n\
p1 = p2;\n\
p2 = gp_Pnt2d(100.,100.);\n\
aline = GCE2d_MakeLine(p1,p2).Value();\n\
MW1.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));\n\
BRepBuilderAPI_MakeFace MKF1;\n\
MKF1.Init(surf,Standard_False);\n\
MKF1.Add(MW1.Wire());\n\
TopoDS_Face FP = MKF1.Face();\n\
BRepLib::BuildCurves3d(FP);\n\
BRepFeat_MakeRevol MKrev(S,FP,F1,D,1,Standard_True);\n\
Ex.Next();\n\
TopoDS_Face F2 = TopoDS::Face(Ex.Current());\n\
MKrev.Perform(F2);\n\
TopoDS_Shape res1 = MKrev.Shape();\n\
	\n");
	PocessTextInDialog("Make a local revolution", Message);
}

void CTopologyLocalOperationsDoc::OnGlue() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	TopoDS_Shape S1 = BRepPrimAPI_MakeBox(gp_Pnt(-500.,-500.,0.),gp_Pnt(-100.,-250.,300.));

	Handle(AIS_Shape) ais1 = new AIS_Shape(S1);
	myAISContext->SetColor(ais1,Quantity_NOC_ORANGE,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);
	myAISContext->SetCurrentObject(ais1,Standard_False);
	Fit();
	Sleep(1000);
	
	TopExp_Explorer Ex1;
	Ex1.Init(S1,TopAbs_FACE);
	Ex1.Next();
	Ex1.Next();
	Ex1.Next();
	Ex1.Next();
	Ex1.Next();
	TopoDS_Face F1 = TopoDS::Face(Ex1.Current());
	TopoDS_Shape S2 = BRepPrimAPI_MakeBox(gp_Pnt(-400.,-400.,300.),gp_Pnt(-200.,-300.,500.));
	Handle(AIS_Shape) ais2 = new AIS_Shape(S2);

	myAISContext->SetColor(ais2,Quantity_NOC_AZURE,Standard_False); 
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais2,Standard_False);
	myAISContext->SetCurrentObject(ais2,Standard_False);
	Fit();
	Sleep(1000);

	TopExp_Explorer Ex2;
	Ex2.Init(S2,TopAbs_FACE);
	Ex2.Next();
	Ex2.Next();
	Ex2.Next();
	Ex2.Next();
	TopoDS_Face F2 = TopoDS::Face(Ex2.Current());
	BRepFeat_Gluer glue(S2,S1);
	glue.Bind(F2,F1);
	TopoDS_Shape res1 = glue.Shape();
	myAISContext->Erase(ais2,Standard_False,Standard_False);
	
	ais1->Set(res1);

	myAISContext->Redisplay(ais1);	
	myAISContext->SetCurrentObject(ais1,Standard_False);
	Fit();
	Sleep(1000);

	TopoDS_Shape S3 = BRepPrimAPI_MakeBox(500.,400.,300.);

	Handle(AIS_Shape) ais3 = new AIS_Shape(S3);
	myAISContext->SetColor(ais3,Quantity_NOC_ORANGE,Standard_False); 
	myAISContext->SetMaterial(ais3,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais3,Standard_False);
	myAISContext->SetCurrentObject(ais3,Standard_False);
	Fit();
	Sleep(1000);

	TopExp_Explorer Ex3;
	Ex3.Init(S3,TopAbs_FACE);
	Ex3.Next();
	Ex3.Next();
	Ex3.Next();
	Ex3.Next();
	Ex3.Next();
	TopoDS_Face F3 = TopoDS::Face(Ex3.Current());
	TopoDS_Shape S4 = BRepPrimAPI_MakeBox(gp_Pnt(0.,0.,300.),gp_Pnt(200.,200.,500.));

	Handle(AIS_Shape) ais4 = new AIS_Shape(S4);
	myAISContext->SetColor(ais4,Quantity_NOC_AZURE,Standard_False); 
	myAISContext->SetMaterial(ais4,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais4,Standard_False);
	myAISContext->SetCurrentObject(ais4,Standard_False);
	Fit();
	Sleep(1000);

	TopExp_Explorer Ex4;
	Ex4.Init(S4,TopAbs_FACE);
	Ex4.Next();
	Ex4.Next();
	Ex4.Next();
	Ex4.Next();
	TopoDS_Face F4 = TopoDS::Face(Ex4.Current());
	BRepFeat_Gluer glue2(S4,S3);
	glue2.Bind(F4,F3);
	LocOpe_FindEdges CommonEdges(F4,F3);
	for (CommonEdges.InitIterator(); CommonEdges.More(); CommonEdges.Next()) 
		glue2.Bind(CommonEdges.EdgeFrom(),CommonEdges.EdgeTo());
	TopoDS_Shape res2 = glue2.Shape();
	myAISContext->Erase(ais3,Standard_False,Standard_False);
	
	ais4->Set(res2);

	myAISContext->Redisplay(ais4,Standard_False);
	myAISContext->SetCurrentObject(ais4,Standard_False);
	Fit();
	Sleep(1000);

	TCollection_AsciiString Message ("\
	\n\
--- Without common edges ---\n\
	\n\
TopoDS_Shape S1 = BRepPrimAPI_MakeBox(gp_Pnt(-500.,-500.,0.),gp_Pnt(-100.,-250.,300.));\n\
TopExp_Explorer Ex1;\n\
Ex1.Init(S1,TopAbs_FACE);\n\
Ex1.Next();\n\
Ex1.Next();\n\
Ex1.Next();\n\
Ex1.Next();\n\
Ex1.Next();\n\
TopoDS_Face F1 = TopoDS::Face(Ex1.Current());\n\
TopoDS_Shape S2 = BRepPrimAPI_MakeBox(gp_Pnt(-400.,-400.,300.),gp_Pnt(-200.,-300.,500.));\n\
TopExp_Explorer Ex2;\n\
Ex2.Init(S2,TopAbs_FACE);\n\
Ex2.Next();\n\
Ex2.Next();\n\
Ex2.Next();\n\
Ex2.Next();\n\
TopoDS_Face F2 = TopoDS::Face(Ex2.Current());\n\
BRepFeat_Gluer glue(S2,S1);\n\
glue.Bind(F2,F1);\n\
TopoDS_Shape res1 = glue.Shape();\n\
\n\
--- With common edges ---\n\
\n\
TopoDS_Shape S3 = BRepPrimAPI_MakeBox(500.,400.,300.);\n\
TopExp_Explorer Ex3;\n\
Ex3.Init(S3,TopAbs_FACE);\n\
Ex3.Next();\n\
Ex3.Next();\n\
Ex3.Next();\n\
Ex3.Next();\n\
Ex3.Next();\n\
TopoDS_Face F3 = TopoDS::Face(Ex3.Current());\n\
TopoDS_Shape S4 = BRepPrimAPI_MakeBox(gp_Pnt(0.,0.,300.),gp_Pnt(200.,200.,500.));\n\
TopExp_Explorer Ex4;\n\
Ex4.Init(S4,TopAbs_FACE);\n\
Ex4.Next();\n\
Ex4.Next();\n\
Ex4.Next();\n\
Ex4.Next();\n\
TopoDS_Face F4 = TopoDS::Face(Ex4.Current());\n\
BRepFeat_Gluer glue2(S4,S3);\n\
glue2.Bind(F4,F3);\n\
LocOpe_FindEdges CommonEdges(F4,F3);\n\
for (CommonEdges.InitIterator(); CommonEdges.More(); CommonEdges.Next()) \n\
	glue2.Bind(CommonEdges.EdgeFrom(),CommonEdges.EdgeTo());\n\
TopoDS_Shape res2 = glue2.Shape();\n\
	\n");
	PocessTextInDialog("Glue two solids", Message);
}


void CTopologyLocalOperationsDoc::OnPipe() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	TopoDS_Shape S = BRepPrimAPI_MakeBox(400.,250.,300.);
	Handle(AIS_Shape) ais1 = new AIS_Shape(S);

	myAISContext->SetColor(ais1,Quantity_NOC_CORAL,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);
	myAISContext->SetCurrentObject(ais1,Standard_False);
	Fit();
	Sleep(500);

	TopExp_Explorer Ex;
	Ex.Init(S,TopAbs_FACE);
	Ex.Next();
	Ex.Next();
	TopoDS_Face F1 = TopoDS::Face(Ex.Current());
	Handle(Geom_Surface) surf = BRep_Tool::Surface(F1);
	BRepBuilderAPI_MakeWire MW1;
	gp_Pnt2d p1,p2;
	p1 = gp_Pnt2d(100.,100.);
	p2 = gp_Pnt2d(200.,100.);
	Handle(Geom2d_Line) aline = GCE2d_MakeLine(p1,p2).Value();
	MW1.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));
	p1 = p2;
	p2 = gp_Pnt2d(150.,200.);
	aline = GCE2d_MakeLine(p1,p2).Value();
	MW1.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));
	p1 = p2;
	p2 = gp_Pnt2d(100.,100.);
	aline = GCE2d_MakeLine(p1,p2).Value();
	MW1.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));
	BRepBuilderAPI_MakeFace MKF1;
	MKF1.Init(surf,Standard_False);
	MKF1.Add(MW1.Wire());
	TopoDS_Face FP = MKF1.Face();
	BRepLib::BuildCurves3d(FP);
	TColgp_Array1OfPnt CurvePoles(1,3);
	gp_Pnt pt = gp_Pnt(150.,0.,150.);
	CurvePoles(1) = pt;
	pt = gp_Pnt(200.,-100.,150.);
	CurvePoles(2) = pt;
	pt = gp_Pnt(150.,-200.,150.);
	CurvePoles(3) = pt;
	Handle(Geom_BezierCurve) curve = new Geom_BezierCurve(CurvePoles);
	TopoDS_Edge E = BRepBuilderAPI_MakeEdge(curve);
	TopoDS_Wire W = BRepBuilderAPI_MakeWire(E);
	BRepFeat_MakePipe MKPipe(S,FP,F1,W,1,Standard_True);
	MKPipe.Perform();
	TopoDS_Shape res1 = MKPipe.Shape();
	ais1->Set(res1);

	myAISContext->Redisplay(ais1,Standard_False); 
	myAISContext->SetCurrentObject(ais1,Standard_False);
	Fit();
	
	TCollection_AsciiString Message ("\
	\n\
TopoDS_Shape S = BRepPrimAPI_MakeBox(400.,250.,300.);\n\
TopExp_Explorer Ex;\n\
Ex.Init(S,TopAbs_FACE);\n\
Ex.Next();\n\
Ex.Next();\n\
TopoDS_Face F1 = TopoDS::Face(Ex.Current());\n\
Handle(Geom_Surface) surf = BRep_Tool::Surface(F1);\n\
BRepBuilderAPI_MakeWire MW1;\n\
gp_Pnt2d p1,p2;\n\
p1 = gp_Pnt2d(100.,100.);\n\
p2 = gp_Pnt2d(200.,100.);\n\
Handle(Geom2d_Line) aline = GCE2d_MakeLine(p1,p2).Value();\n\
MW1.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));\n\
p1 = p2;\n\
p2 = gp_Pnt2d(150.,200.);\n\
aline = GCE2d_MakeLine(p1,p2).Value();\n\
MW1.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));\n\
p1 = p2;\n\
p2 = gp_Pnt2d(100.,100.);\n\
aline = GCE2d_MakeLine(p1,p2).Value();\n\
MW1.Add(BRepBuilderAPI_MakeEdge(aline,surf,0.,p1.Distance(p2)));\n\
BRepBuilderAPI_MakeFace MKF1;\n\
MKF1.Init(surf,Standard_False);\n\
TopoDS_Face FP = MKF1.Face();\n\
BRepLib::BuildCurves3d(FP);\n\
TColgp_Array1OfPnt CurvePoles(1,3);\n\
gp_Pnt pt = gp_Pnt(150.,0.,150.);\n\
CurvePoles(1) = pt;\n\
pt = gp_Pnt(200.,-100.,150.);\n\
CurvePoles(2) = pt;\n\
pt = gp_Pnt(150.,-200.,150.);\n\
CurvePoles(3) = pt;\n\
Handle(Geom_BezierCurve) curve = new Geom_BezierCurve(CurvePoles);\n\
TopoDS_Edge E = BRepBuilderAPI_MakeEdge(curve);\n\
TopoDS_Wire W = BRepBuilderAPI_MakeWire(E);\n\
BRepFeat_MakePipe MKPipe(S,FP,F1,W,1,Standard_True);\n\
MKPipe.Perform();\n\
TopoDS_Shape res1 = MKPipe.Shape();\n\
	\n");
	PocessTextInDialog("Make a local pipe", Message);
}


void CTopologyLocalOperationsDoc::OnLinear() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	BRepBuilderAPI_MakeWire mkw;
	gp_Pnt p1 = gp_Pnt(0.,0.,0.);
	gp_Pnt p2 = gp_Pnt(200.,0.,0.);
	mkw.Add(BRepBuilderAPI_MakeEdge(p1,p2));
	p1 = p2;
	p2 = gp_Pnt(200.,0.,50.);
	mkw.Add(BRepBuilderAPI_MakeEdge(p1,p2));
	p1 = p2;
	p2 = gp_Pnt(50.,0.,50.);
	mkw.Add(BRepBuilderAPI_MakeEdge(p1,p2));
	p1 = p2;
	p2 = gp_Pnt(50.,0.,200.);
	mkw.Add(BRepBuilderAPI_MakeEdge(p1,p2));
	p1 = p2;
	p2 = gp_Pnt(0.,0.,200.);
	mkw.Add(BRepBuilderAPI_MakeEdge(p1,p2));
	p1 = p2;
	mkw.Add(BRepBuilderAPI_MakeEdge(p2,gp_Pnt(0.,0.,0.)));
	
	TopoDS_Shape S = BRepPrimAPI_MakePrism(BRepBuilderAPI_MakeFace(mkw.Wire()), 
									   gp_Vec(gp_Pnt(0.,0.,0.),gp_Pnt(0.,100.,0.)));

	Handle(AIS_Shape) ais1 = new AIS_Shape(S);
	myAISContext->SetColor(ais1,Quantity_NOC_CYAN2,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);
	myAISContext->SetCurrentObject(ais1,Standard_False);
	Fit();
	Sleep(500);

	TopoDS_Wire W = BRepBuilderAPI_MakeWire(BRepBuilderAPI_MakeEdge(gp_Pnt(50.,45.,100.),
													  gp_Pnt(100.,45.,50.)));	
	Handle(Geom_Plane) aplane = new Geom_Plane(0.,1.,0.,-45.);
	BRepFeat_MakeLinearForm aform(S, W, aplane, gp_Vec(0.,10.,0.), gp_Vec(0.,0.,0.),
								  1, Standard_True);
	aform.Perform(/*10.*/); // new in 2.0

	TopoDS_Shape res = aform.Shape();
	ais1->Set(res);
	myAISContext->Redisplay(ais1,Standard_False);
	myAISContext->SetCurrentObject(ais1);
	Fit();

	TCollection_AsciiString Message ("\
	\n\
BRepBuilderAPI_MakeWire mkw;\n\
gp_Pnt p1 = gp_Pnt(0.,0.,0.);\n\
gp_Pnt p2 = gp_Pnt(200.,0.,0.);\n\
mkw.Add(BRepBuilderAPI_MakeEdge(p1,p2));\n\
p1 = p2;\n\
p2 = gp_Pnt(200.,0.,50.);\n\
mkw.Add(BRepBuilderAPI_MakeEdge(p1,p2));\n\
p1 = p2;\n\
p2 = gp_Pnt(50.,0.,50.);\n\
mkw.Add(BRepBuilderAPI_MakeEdge(p1,p2));\n\
p1 = p2;\n\
p2 = gp_Pnt(50.,0.,200.);\n\
mkw.Add(BRepBuilderAPI_MakeEdge(p1,p2));\n\
p1 = p2;\n\
p2 = gp_Pnt(0.,0.,200.);\n\
mkw.Add(BRepBuilderAPI_MakeEdge(p1,p2));\n\
p1 = p2;\n\
mkw.Add(BRepBuilderAPI_MakeEdge(p2,gp_Pnt(0.,0.,0.)));\n\
TopoDS_Shape S = BRepPrimAPI_MakePrism(BRepBuilderAPI_MakeFace(mkw.Wire()), \n\
								gp_Vec(gp_Pnt(0.,0.,0.),gp_Pnt(0.,100.,0.)));\n\
TopoDS_Wire W = BRepBuilderAPI_MakeWire(BRepBuilderAPI_MakeEdge(gp_Pnt(50.,45.,100.),\n\
												gp_Pnt(100.,45.,50.)));\n\
Handle(Geom_Plane) aplane = new Geom_Plane(0.,1.,0.,-45.);\n\
BRepFeat_MakeLinearForm aform(S, W, aplane, gp_Dir(0.,10.,0.), gp_Dir(0.,0.,0.),\n\
							1, Standard_True);\n\
aform.Perform(10.);\n\
TopoDS_Shape res = aform.Shape();\n\
	\n");
	PocessTextInDialog("Make a rib", Message);
}


void CTopologyLocalOperationsDoc::OnSplit() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TopoDS_Shape S = BRepPrimAPI_MakeBox(gp_Pnt(-100,-60,-80),150,200,170); 
	
	Handle(AIS_Shape) ais1 = new AIS_Shape(S);
	myAISContext->SetColor(ais1,Quantity_NOC_RED,Standard_False);
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);
	myAISContext->Display(ais1,Standard_False);
	myAISContext->SetCurrentObject(ais1,Standard_False);
	Fit();
	Sleep(500);

	BRepAlgoAPI_Section asect(S, gp_Pln(1,2,1,-15),Standard_False);
	asect.ComputePCurveOn1(Standard_True);
	asect.Approximation(Standard_True);
	asect.Build();
	TopoDS_Shape R = asect.Shape();
	BRepTools::Write(R,"E:\\temp\\R");

	BRepFeat_SplitShape asplit(S);
	
	for (TopExp_Explorer Ex(R,TopAbs_EDGE); Ex.More(); Ex.Next()) {
		TopoDS_Shape anEdge = Ex.Current();
		TopoDS_Shape aFace;
		if (asect.HasAncestorFaceOn1(anEdge,aFace)) {
			TopoDS_Face F = TopoDS::Face(aFace);
			TopoDS_Edge E = TopoDS::Edge(anEdge);
			asplit.Add(E,F);
		}
	}

	asplit.Build();

	//Sleep(1000);
	myAISContext->Erase(ais1,Standard_False,Standard_False);
	//Fit();

	TopoDS_Shape Result = asplit.Shape();
	
	Handle(AIS_Shape) ais2 = new AIS_Shape(Result);

	myAISContext->SetColor(ais2,Quantity_NOC_RED,Standard_False);
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);
	myAISContext->SetDisplayMode(ais2,1,Standard_False);
	myAISContext->Display(ais2,Standard_False);
	myAISContext->SetCurrentObject(ais2,Standard_False);
	Fit();
		TCollection_AsciiString Message ("\
	\n\
TopoDS_Shape S = BRepPrimAPI_MakeBox(gp_Pnt(-100,-60,-80),150,200,170); 	\n\
		\n\
BRepBuilderAPI_Section asect(S, gp_Pln(1,2,1,-15),Standard_False);	\n\
asect.ComputePCurveOn1(Standard_True);	\n\
asect.Approximation(Standard_True);	\n\
asect.Build();	\n\
TopoDS_Shape R = asect.Shape();	\n\
	\n\
BRepFeat_SplitShape asplit(S);	\n\
	\n\
for (TopExp_Explorer Ex(R,TopAbs_EDGE); Ex.More(); Ex.Next()) {	\n\
TopoDS_Shape anEdge = Ex.Current();	\n\
	TopoDS_Shape aFace;	\n\
	if (asect.HasAncestorFaceOn1(anEdge,aFace)) {	\n\
		TopoDS_Face F = TopoDS::Face(aFace);	\n\
		TopoDS_Edge E = TopoDS::Edge(anEdge);	\n\
		asplit.Add(E,F);	\n\
	}	\n\
}	\n\
	\n\
asplit.Build();	\n\
	\n\
TopoDS_Shape Result = asplit.Shape();	\n\
	\n\
\n");

PocessTextInDialog("Split a shape", Message);
}



void CTopologyLocalOperationsDoc::OnThick() 
{
	AIS_ListOfInteractive L;
	myAISContext->DisplayedObjects(L);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(L);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TopoDS_Shape S1 = BRepPrimAPI_MakeBox(150,200,110);
	
	Handle(AIS_Shape) abox1 = new AIS_Shape(S1);
	myAISContext->SetColor(abox1,Quantity_NOC_WHITE);
	myAISContext->SetMaterial(abox1,Graphic3d_NOM_PLASTIC,Standard_False);
	myAISContext->Display(abox1,Standard_False);
	myAISContext->SetCurrentObject(abox1,Standard_False);
	Fit();
	Sleep(1000);

	TopTools_ListOfShape aList;
	TopExp_Explorer Ex(S1,TopAbs_FACE);
	Ex.Next();	//this is the front face
	TopoDS_Shape aFace = Ex.Current();
	aList.Append(aFace);
		
	TopoDS_Shape aThickSolid = BRepOffsetAPI_MakeThickSolid(S1,aList,10,0.01);

	Handle(AIS_Shape) ais1 = new AIS_Shape(aThickSolid);
	myAISContext->SetColor(ais1,Quantity_NOC_RED,Standard_False);
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);
	myAISContext->Display(ais1,Standard_False);
	myAISContext->SetCurrentObject(ais1,Standard_False);
	Fit();
	Sleep(1000);
	
	myAISContext->Erase(abox1,Standard_True,Standard_False);
	Fit();


		TCollection_AsciiString Message ("\
	\n\
TopoDS_Shape S = BRepPrimAPI_MakeBox(150,200,110);	\n\
	\n\
TopTools_ListOfShape aList;	\n\
TopExp_Explorer Ex(S,TopAbs_FACE);	\n\
Ex.Next();	//in order to recover the front face	\n\
TopoDS_Shape aFace = Ex.Current();	\n\
aList.Append(aFace);	\n\
			\n\
TopoDS_Shape aThickSolid = BRepPrimAPI_MakeThickSolid(S,aList,15,0.01);	\n\
	\n\
\n");
PocessTextInDialog("Make a thick solid", Message);
}

void CTopologyLocalOperationsDoc::OnOffset() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TopoDS_Shape S1 = BRepPrimAPI_MakeBox(150,200,110);

	Handle(AIS_Shape) aisBox1 = new AIS_Shape(S1);
	myAISContext->SetColor(aisBox1,Quantity_NOC_BROWN,Standard_False);
	myAISContext->SetMaterial(aisBox1,Graphic3d_NOM_GOLD,Standard_False);
	myAISContext->Display(aisBox1,Standard_False);
	Fit();
	Sleep(500);

	TopoDS_Shape anOffsetShape1 = BRepOffsetAPI_MakeOffsetShape(S1,60,0.01);

	Handle(AIS_Shape) ais1 = new AIS_Shape(anOffsetShape1);
	myAISContext->SetColor(ais1,Quantity_NOC_MATRABLUE,Standard_False);
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_GOLD,Standard_False);
	myAISContext->SetTransparency(ais1,0.5,Standard_False);
	myAISContext->Display(ais1,Standard_False);
	Fit();
	Sleep(500);

	TopoDS_Shape S2 = BRepPrimAPI_MakeBox(gp_Pnt(500,0,0),220,140,180);
	
	Handle(AIS_Shape) aisBox2 = new AIS_Shape(S2);
	myAISContext->SetColor(aisBox2,Quantity_NOC_WHITE,Standard_False);
	myAISContext->SetMaterial(aisBox2,Graphic3d_NOM_GOLD,Standard_False);
	myAISContext->SetTransparency(aisBox2,0.5,Standard_False);
	myAISContext->Display(aisBox2,Standard_False);
	Fit();
	Sleep(500);

	TopoDS_Shape anOffsetShape2 = BRepOffsetAPI_MakeOffsetShape(S2,-40,0.01,
		BRepOffset_Skin,Standard_False,Standard_False,GeomAbs_Arc);

	Handle(AIS_Shape) ais2 = new AIS_Shape(anOffsetShape2);
	myAISContext->SetColor(ais2,Quantity_NOC_MATRABLUE);
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_GOLD,Standard_False);
	myAISContext->Display(ais2);
	Fit();
	
	TCollection_AsciiString Message ("\
	\n\
\n\
TopoDS_Shape S1 = BRepPrimAPI_MakeBox(150,200,110);	\n\
\n\
TopoDS_Shape anOffsetShape1 = BRepPrimAPI_MakeOffsetShape(S1,60,0.01);	\n\
\n\
//The white box	\n\
	\n\
TopoDS_Shape S2 = BRepPrimAPI_MakeBox(gp_Pnt(300,0,0),220,140,180);	\n\
\n\
TopoDS_Shape anOffsetShape2 = BRepPrimAPI_MakeOffsetShape(S2,-20,0.01,	\n\
	BRepOffset_Skin,Standard_False,Standard_False,GeomAbs_Arc);	\n\
	\n\
\n\
\n");
PocessTextInDialog("Make an offset shape", Message);

}
