// File:        SelectMgr_SortCriterion.cxx
// Created:     Thu Mar 26 17:32:47 1998
// Author:      Robert COUBLANC
//              <rob@robox.paris1.matra-dtv.fr>


#include <SelectMgr_SortCriterion.ixx>
#include <Precision.hxx>

//=======================================================================
//function : SelectMgr_SortCriterion
//purpose  : Empty constructor
//=======================================================================

SelectMgr_SortCriterion::SelectMgr_SortCriterion()
     : myPrior  (0),
       myDepth  (0.0),
       myDist   (0.0)
{}

//=======================================================================
//function : SelectMgr_SortCriterion
//purpose  : Constructor
//=======================================================================

SelectMgr_SortCriterion::SelectMgr_SortCriterion(const Standard_Integer Prior,
                                                 const Standard_Real Depth,
                                                 const Standard_Real Dist)
     : myPrior  (Prior),
       myDepth  (Depth),
       myDist   (Dist)
{}

//=======================================================================
//function : IsGreater
//purpose  :  priorite d'abor, puis profondeur + distance...
//=======================================================================
Standard_Boolean SelectMgr_SortCriterion::IsGreater
                                (const SelectMgr_SortCriterion& SC) const
{
  if(myPrior>SC.Priority()) return Standard_True;
  if(myPrior<SC.Priority()) return Standard_False;
  
  if(Abs(myDepth-SC.Depth())<=Precision::Confusion())
// OCC4201 (AGV): The condition "Equal" is not to be treated
//    return myDist<=SC.MinDist();
    return myDist < SC.MinDist();
// OCC4201 end
  return (myDepth < SC.Depth() );
}

//=======================================================================
//function : IsLower
//purpose  : On n'utilise que les criteres de profondeur et de priorite...
//=======================================================================
Standard_Boolean SelectMgr_SortCriterion::IsLower
                                (const SelectMgr_SortCriterion& SC) const
{
  if(myPrior>SC.Priority()) return Standard_False;
  if(myPrior<SC.Priority()) return Standard_True;
  if(Abs(myDepth-SC.Depth())<=Precision::Confusion())
    return myDist > SC.MinDist();
  
  return (myDepth > SC.Depth() );
}
