
// File:        OSD_Chronometer.cxx
// Created:     Mon Nov 16 15:20:41 1992
// Author:      Mireille MERCIEN
//              <mip@sdsun3>

#ifndef WNT

//---------- Systemes autres que WNT : ----------------------------------

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <OSD_Chronometer.ixx>
#include <Standard_Address.hxx>

#include <Standard_Stream.hxx>

#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

#ifdef HAVE_SYS_TIMES_H
# include <sys/times.h>
#endif

//=======================================================================
//Selon les plateformes on doit avoir le nombre de clicks par secondes
//qui est l unite de mesure du temps. 
//=======================================================================
#ifndef sysconf 
# define _sysconf sysconf
#endif

#if defined(HAVE_TIME_H) || defined(WNT) || defined(DECOSF1)
# include <time.h>
#endif

#  ifndef CLK_TCK
#   define CLK_TCK	CLOCKS_PER_SEC
#  endif

#ifdef HAVE_LIMITS
# include <limits>
#elif defined (HAVE_LIMITS_H)
# include <limits.h>
#endif

#ifdef WNT
# include <limits>
#endif

//=======================================================================
//function : OSD_Chronometer
//purpose  : 
//=======================================================================
OSD_Chronometer::OSD_Chronometer()
{
  RefToInitialTMS = (Standard_Address) new tms;
  RefToCurrentTMS = (Standard_Address) new tms;
  Cumul_user      = Cumul_sys = 0.            ;
  Stopped         = Standard_True             ; 
}
//=======================================================================
//function :  Destroy
//purpose  : 
//=======================================================================
void OSD_Chronometer :: Destroy () {

 delete (tms*)RefToCurrentTMS ;
 delete (tms*)RefToInitialTMS ;

}


//=======================================================================
//function : Reset
//purpose  : 
//=======================================================================
void OSD_Chronometer::Reset ()
{
  Stopped     = Standard_True;
  Cumul_user  = Cumul_sys = 0. ;
}

//=======================================================================
//function : Stop
//purpose  : 
//=======================================================================
void OSD_Chronometer::Stop ()
{
  if (!Stopped) {
    times((tms*)RefToCurrentTMS);
    Standard_Integer diffr_user = (Standard_Integer)( ((tms*)RefToCurrentTMS)->tms_utime -
                                                      ((tms*)RefToInitialTMS)->tms_utime       );
    Standard_Integer diffr_sys  = (Standard_Integer)( ((tms*)RefToCurrentTMS)->tms_stime -
                                                      ((tms*)RefToInitialTMS)->tms_stime       );
    //tms_utime et tms_stime sont donnes en CLK_TCK par seconde, 
    // (man times,limits.h, man sysconf)
    //   cout << "Nombre de clicks par seconde : " << CLK_TCK << endl;
//modified by NIZNHY-PKV Fri Mar 25 17:15:12 2005f
#if defined(LIN) || defined(linux) || defined(__FreeBSD__)
    static long aCLK_TCK=sysconf(_SC_CLK_TCK);
    //
    Cumul_user += (Standard_Real) diffr_user / aCLK_TCK ;
    Cumul_sys  += (Standard_Real) diffr_sys  / aCLK_TCK ;
#else
    Cumul_user += (Standard_Real) diffr_user / CLK_TCK ;
    Cumul_sys  += (Standard_Real) diffr_sys  / CLK_TCK ;
#endif
//modified by NIZNHY-PKV Fri Mar 25 17:15:18 2005t
    Stopped = Standard_True;
  }
  else cout << "WARNING: OSD_Chronometer already Stopped !\n";
}

//=======================================================================
//function : Start
//purpose  : 
//=======================================================================
void OSD_Chronometer::Start()
{
  if (Stopped) {
    Stopped = Standard_False;
    times((tms*)RefToInitialTMS);
  }
  else cout << "WARNING: OSD_Chronometer already Running !\n";
}

//=======================================================================
//function : Show
//purpose  : 
//=======================================================================
void OSD_Chronometer::Show ()
{
  Standard_Boolean StopSav = Stopped;
  if (!StopSav) Stop();
  cout << "CPU user time: "   << Cumul_user  << " seconds " << endl;
  cout << "CPU system time: " << Cumul_sys   << " seconds " << endl;
  if (!StopSav) Start();
}

//=======================================================================
//function : Show
//purpose  : 
//=======================================================================
void OSD_Chronometer::Show (Standard_OStream& os)
{
  Standard_Boolean StopSav = Stopped;
  if (!StopSav) Stop();
  os << "CPU user time: "   << Cumul_user  << " seconds " << endl;
  os << "CPU system time: " << Cumul_sys   << " seconds " << endl;
  if (!StopSav) Start();
}

//=======================================================================
//function : Show
//purpose  : Returns cpu user time
//=======================================================================
void OSD_Chronometer::Show (Standard_Real& second)
{
  Standard_Boolean StopSav = Stopped;
  if (!StopSav) Stop();
  second = Cumul_user; 
  if (!StopSav) Start();
}
//=======================================================================
//function : Show
//purpose  : Returns both user and system cpu times
//=======================================================================
void OSD_Chronometer::Show (Standard_Real& user,
                            Standard_Real& system)
{
  Standard_Boolean StopSav = Stopped;
  if (!StopSav) Stop();
  user = Cumul_user; 
  system = Cumul_sys; 
  if (!StopSav) Start();
}

#else

//---------------------------- Systeme WNT --------------------------------

#define STRICT
#include <windows.h>

#include <OSD_Chronometer.ixx>

__int64 __fastcall FileTimeToQuadWord ( PFILETIME          );
void    __fastcall QuadWordToFileTime ( __int64, PFILETIME );

OSD_Chronometer :: OSD_Chronometer () {

 RefToInitialTMSUser = ( Standard_Address )new FILETIME;
 RefToCurrentTMSUser = ( Standard_Address )new FILETIME;
 RefToInitialTMSKrnl = ( Standard_Address )new FILETIME;
 RefToCurrentTMSKrnl = ( Standard_Address )new FILETIME;

 Reset ();

}  // end constructor

void OSD_Chronometer :: Destroy () {

 delete RefToCurrentTMSKrnl;
 delete RefToInitialTMSKrnl;
 delete RefToCurrentTMSUser;
 delete RefToInitialTMSUser;

}  // end OSD_Chronometer :: Destroy

void OSD_Chronometer :: Reset () {

 Stopped = Standard_True;

 Cumul_user = Cumul_sys = 0;

}  // end OSD_Chronometer :: Reset

void OSD_Chronometer :: Stop () {

 if ( !Stopped ) {

  FILETIME ftDummy;
 
  GetThreadTimes (
   GetCurrentThread (), &ftDummy, &ftDummy,
   ( PFILETIME )RefToCurrentTMSKrnl,
   ( PFILETIME )RefToCurrentTMSUser
  );

  __int64 diffUser = FileTimeToQuadWord (  ( PFILETIME )RefToCurrentTMSUser  ) -
                     FileTimeToQuadWord (  ( PFILETIME )RefToInitialTMSUser  );
  __int64 diffKrnl = FileTimeToQuadWord (  ( PFILETIME )RefToCurrentTMSKrnl  ) -
                     FileTimeToQuadWord (  ( PFILETIME )RefToInitialTMSKrnl  );

  Cumul_user += ( Standard_Real )diffUser;
  Cumul_sys  += ( Standard_Real )diffKrnl;

  Stopped = Standard_True;
 
 } else

  cerr << "WARNING: OSD_Chronometer already stopped !\n" << flush;

}  // end OSD_Chronometer :: Stop

void OSD_Chronometer :: Start () {

 if ( Stopped ) {
 
  FILETIME ftDummy;
 
  GetThreadTimes (
   GetCurrentThread (), &ftDummy, &ftDummy,
   ( PFILETIME )RefToInitialTMSKrnl,
   ( PFILETIME )RefToInitialTMSUser
  );

  Stopped = Standard_False;

 } else

  cerr << "WARNING: OSD_Chronometer already running !\n" << flush;

}  // end OSD_Chronometer :: Start

void OSD_Chronometer :: Show () {

 Standard_Boolean stopSav = Stopped;

 if ( !Stopped ) Stop ();

 cout << "CPU user   time: " << Cumul_user * ( Standard_Real )0.0000001 << " seconds " << endl;
 cout << "CPU kernel time: " << Cumul_sys  * ( Standard_Real )0.0000001 << " seconds " << endl << flush;

 if ( !stopSav ) Start ();

}  // end OSD_Chronometer :: Show

void OSD_Chronometer :: Show ( Standard_OStream& os ) {

 Standard_Boolean stopSav = Stopped;

 if ( !Stopped ) Stop ();

 os << "CPU user   time: " << Cumul_user * ( Standard_Real )0.0000001 << " seconds " << endl;
 os << "CPU kernel time: " << Cumul_sys  * ( Standard_Real )0.0000001 << " seconds " << endl;

 if ( !stopSav ) Start ();

}  // end  OSD_Chronometer :: Show

void OSD_Chronometer :: Show ( Standard_Real& UserSeconds ) {

 Standard_Boolean stopSav = Stopped;

 if ( !Stopped ) Stop ();

 UserSeconds = Cumul_user * ( Standard_Real )0.0000001;

 if ( !stopSav ) Start ();

}  // end OSD_Chronometer :: Show

void OSD_Chronometer :: Show ( Standard_Real& UserSeconds, Standard_Real& SystemSeconds ) {

 Standard_Boolean stopSav = Stopped;

 if ( !Stopped ) Stop ();

 UserSeconds   = Cumul_user * ( Standard_Real )0.0000001;
 SystemSeconds = Cumul_sys  * ( Standard_Real )0.0000001;

 if ( !stopSav ) Start ();

}  // end OSD_Chronometer :: Show

__int64 __fastcall FileTimeToQuadWord ( PFILETIME pFt ) {

 __int64 qw;

 qw   = pFt -> dwHighDateTime;
 qw <<= 32;
 qw  |= pFt -> dwLowDateTime;

 return qw;

}  // end FileTimeToQuadWord

void __fastcall QuadWordToFileTime ( __int64 qw, PFILETIME pFt ) {

 pFt -> dwHighDateTime = ( DWORD )( qw >> 32 );
 pFt -> dwLowDateTime  = ( DWORD ) ( qw & 0xFFFFFFFF );

}  // end QuadWordToFileTime

#endif
