// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Prs3d_PlaneAspect_HeaderFile
#define _Prs3d_PlaneAspect_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Prs3d_PlaneAspect_HeaderFile
#include <Handle_Prs3d_PlaneAspect.hxx>
#endif

#ifndef _Handle_Prs3d_LineAspect_HeaderFile
#include <Handle_Prs3d_LineAspect.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Prs3d_CompositeAspect_HeaderFile
#include <Prs3d_CompositeAspect.hxx>
#endif
class Prs3d_LineAspect;


//! A framework to define the display of planes. <br>
class Prs3d_PlaneAspect : public Prs3d_CompositeAspect {

public:
 // Methods PUBLIC
 // 

//! Constructs an empty framework for the display of planes. <br>
Standard_EXPORT Prs3d_PlaneAspect();

//! Returns the attributes of displayed edges involved in the presentation of planes. <br>
Standard_EXPORT   Handle_Prs3d_LineAspect EdgesAspect() const;

//! Returns the attributes of displayed isoparameters involved in the presentation of planes. <br>
Standard_EXPORT   Handle_Prs3d_LineAspect IsoAspect() const;

//! Returns the settings for displaying an arrow. <br>
Standard_EXPORT   Handle_Prs3d_LineAspect ArrowAspect() const;


Standard_EXPORT   void SetArrowsLength(const Quantity_Length L) ;

//! Returns the length of the arrow shaft used in the display of arrows. <br>
Standard_EXPORT   Quantity_Length ArrowsLength() const;

//! Sets the angle of the arrowhead used in the display of planes. <br>
Standard_EXPORT   void SetArrowsSize(const Quantity_Length L) ;

//! Returns the size of arrows used in the display of planes. <br>
Standard_EXPORT   Quantity_Length ArrowsSize() const;

//! Sets the angle of the arrowhead used in the display <br>
//! of arrows involved in the presentation of planes. <br>
Standard_EXPORT   void SetArrowsAngle(const Quantity_PlaneAngle ang) ;

//! Returns the angle of the arrowhead used in the <br>
//! display of arrows involved in the presentation of planes. <br>
Standard_EXPORT   Quantity_PlaneAngle ArrowsAngle() const;

//! Sets the display attributes defined in DisplayCenterArrow to active. <br>
Standard_EXPORT   void SetDisplayCenterArrow(const Standard_Boolean draw) ;

//! Returns true if the display of center arrows is allowed. <br>
Standard_EXPORT   Standard_Boolean DisplayCenterArrow() const;

//! Sets the display attributes defined in DisplayEdgesArrows to active. <br>
Standard_EXPORT   void SetDisplayEdgesArrows(const Standard_Boolean draw) ;

//! Returns true if the display of edge arrows is allowed. <br>
Standard_EXPORT   Standard_Boolean DisplayEdgesArrows() const;


Standard_EXPORT   void SetDisplayEdges(const Standard_Boolean draw) ;


Standard_EXPORT   Standard_Boolean DisplayEdges() const;

//! Sets the display attributes defined in DisplayIso to active. <br>
Standard_EXPORT   void SetDisplayIso(const Standard_Boolean draw) ;

//! Returns true if the display of isoparameters is allowed. <br>
Standard_EXPORT   Standard_Boolean DisplayIso() const;


Standard_EXPORT   void SetPlaneLength(const Quantity_Length LX,const Quantity_Length LY) ;

//! Returns the length of the x axis used in the display of planes. <br>
Standard_EXPORT   Quantity_Length PlaneXLength() const;

//! Returns the length of the y axis used in the display of planes. <br>
Standard_EXPORT   Quantity_Length PlaneYLength() const;

//! Sets the distance L between isoparameters used in the display of planes. <br>
Standard_EXPORT   void SetIsoDistance(const Quantity_Length L) ;

//! Returns the distance between isoparameters used in the display of planes. <br>
Standard_EXPORT   Quantity_Length IsoDistance() const;
//Standard_EXPORT ~Prs3d_PlaneAspect();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Prs3d_LineAspect myEdgesAspect;
Handle_Prs3d_LineAspect myIsoAspect;
Handle_Prs3d_LineAspect myArrowAspect;
Quantity_Length myArrowsLength;
Quantity_Length myArrowsSize;
Quantity_PlaneAngle myArrowsAngle;
Standard_Boolean myDrawCenterArrow;
Standard_Boolean myDrawEdgesArrows;
Standard_Boolean myDrawEdges;
Standard_Boolean myDrawIso;
Quantity_Length myPlaneXLength;
Quantity_Length myPlaneYLength;
Quantity_Length myIsoDistance;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
