// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntSurf_PathPointTool_HeaderFile
#define _IntSurf_PathPointTool_HeaderFile

#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _gp_Vec_HeaderFile
#include <gp_Vec.hxx>
#endif
#ifndef _gp_Dir2d_HeaderFile
#include <gp_Dir2d.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_OutOfRange;
class StdFail_UndefinedDerivative;
class IntSurf_PathPoint;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class IntSurf_PathPointTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
//! Returns the 3d coordinates of the starting point. <br>
static  gp_Pnt Value3d(const IntSurf_PathPoint& PStart) ;
//! Returns the <U, V> parameters which are associated <br>
//!          with <P> <br>
//!          it's the parameters which start the marching algorithm <br>
static  void Value2d(const IntSurf_PathPoint& PStart,Standard_Real& U,Standard_Real& V) ;
//! Returns True if the point is a point on a non-oriented <br>
//!          arc, which means that the intersection line does not <br>
//!          stop at such a point but just go through such a point. <br>
//!          IsPassingPnt is True when IsOnArc is True <br>
static  Standard_Boolean IsPassingPnt(const IntSurf_PathPoint& PStart) ;
//! Returns True if the surfaces are tangent at this point. <br>
//!          IsTangent can be True when IsOnArc is True <br>
//!          if IsPassingPnt is True and IsTangent is True,this point <br>
//!          is a stopped point. <br>
static  Standard_Boolean IsTangent(const IntSurf_PathPoint& PStart) ;
//! returns the tangent at the intersection in 3d space <br>
//!          associated to <P> <br>
//!         an exception is raised if IsTangent is true. <br>
static  gp_Vec Direction3d(const IntSurf_PathPoint& PStart) ;
//! returns the tangent at the intersection in the <br>
//!          parametric space of the parametrized surface.This tangent <br>
//!          is associated to the value2d <br>
//!          la tangente a un sens signifiant (indique le sens de chemin <br>
//!          ement) <br>
//!          an exception is raised if IsTangent is true. <br>
static  gp_Dir2d Direction2d(const IntSurf_PathPoint& PStart) ;
//! Returns the multiplicity of the point i-e <br>
//!          the number of auxillar parameters associated to the <br>
//!          point which the principal parameters are given by Value2d <br>
static  Standard_Integer Multiplicity(const IntSurf_PathPoint& PStart) ;
//! Parametric coordinates associated to the multiplicity. <br>
//!          An exception is raised if Mult<=0 or Mult>multiplicity. <br>
static  void Parameters(const IntSurf_PathPoint& PStart,const Standard_Integer Mult,Standard_Real& U,Standard_Real& V) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};


#include <IntSurf_PathPointTool.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
