// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom2dConvert_BSplineCurveKnotSplitting_HeaderFile
#define _Geom2dConvert_BSplineCurveKnotSplitting_HeaderFile

#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Handle_Geom2d_BSplineCurve_HeaderFile
#include <Handle_Geom2d_BSplineCurve.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TColStd_HArray1OfInteger;
class Standard_DimensionError;
class Standard_RangeError;
class Geom2d_BSplineCurve;
class TColStd_Array1OfInteger;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! An algorithm to determine points at which a BSpline <br>
//!  curve should be split in order to obtain arcs of the same continuity. <br>
//! If you require curves with a minimum continuity for <br>
//! your computation, it is useful to know the points <br>
//! between which an arc has a continuity of a given <br>
//! order. For a BSpline curve, the discontinuities are <br>
//! localized at the knot values. Between two knot values <br>
//! the BSpline is infinitely and continuously <br>
//! differentiable. At a given knot, the continuity is equal <br>
//! to: Degree - Mult, where Degree is the <br>
//! degree of the BSpline curve and Mult is the multiplicity of the knot. <br>
//! It is possible to compute the arcs which correspond to <br>
//! this splitting using the global function <br>
//! SplitBSplineCurve provided by the package Geom2dConvert. <br>
//! A BSplineCurveKnotSplitting object provides a framework for: <br>
//! -   defining the curve to be analysed and the required degree of continuity, <br>
//! -   implementing the computation algorithm, and <br>
//! -   consulting the results. <br>
class Geom2dConvert_BSplineCurveKnotSplitting  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Determines points at which the BSpline curve <br>
//!  BasisCurve should be split in order to obtain arcs <br>
//!  with a degree of continuity equal to ContinuityRange. <br>
//! These points are knot values of BasisCurve. They <br>
//! are identified by indices in the knots table of BasisCurve. <br>
//! Use the available interrogation functions to access <br>
//! computed values, followed by the global function <br>
//! SplitBSplineCurve (provided by the package <br>
//! Geom2dConvert) to split the curve. <br>
//! Exceptions <br>
//! Standard_RangeError if ContinuityRange is less than zero. <br>
Standard_EXPORT Geom2dConvert_BSplineCurveKnotSplitting(const Handle(Geom2d_BSplineCurve)& BasisCurve,const Standard_Integer ContinuityRange);

//!Returns the number of points at which the analysed <br>
//! BSpline curve should be split, in order to obtain arcs <br>
//! with the continuity required by this framework. <br>
//! All these points correspond to knot values. Note that <br>
//! the first and last points of the curve, which bound the <br>
//! first and last arcs, are counted among these splitting points. <br>
Standard_EXPORT   Standard_Integer NbSplits() const;

//! Loads the SplitValues table with the split knots <br>
//! values computed in this framework. Each value in the <br>
//! table is an index in the knots table of the BSpline <br>
//! curve analysed by this algorithm. <br>
//! The values in SplitValues are given in ascending <br>
//! order and comprise the indices of the knots which <br>
//! give the first and last points of the curve. Use two <br>
//! consecutive values from the table as arguments of the <br>
//! global function SplitBSplineCurve (provided by the <br>
//! package Geom2dConvert) to split the curve. <br>
//! Exceptions <br>
//! Standard_DimensionError if the array SplitValues <br>
//! was not created with the following bounds: <br>
//! -   1, and <br>
//! -   the number of split points computed in this <br>
//!   framework (as given by the function NbSplits). <br>
Standard_EXPORT   void Splitting(TColStd_Array1OfInteger& SplitValues) const;

//!Returns the split knot of index Index to the split knots <br>
//! table computed in this framework. The returned value <br>
//! is an index in the knots table of the BSpline curve <br>
//! analysed by this algorithm. <br>
//! Notes: <br>
//! -   If Index is equal to 1, the corresponding knot <br>
//!   gives the first point of the curve. <br>
//! -   If Index is equal to the number of split knots <br>
//!   computed in this framework, the corresponding <br>
//!   point is the last point of the curve. <br>
//! Exceptions <br>
//! Standard_RangeError if Index is less than 1 or <br>
//! greater than the number of split knots computed in this framework. <br>
Standard_EXPORT   Standard_Integer SplitValue(const Standard_Integer Index) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TColStd_HArray1OfInteger splitIndexes;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
