// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_CorrectTolerances_HeaderFile
#define _BOP_CorrectTolerances_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  The  Set  of  static functions to provide valid values of <br>
//!  tolerances for shapes. <br>
//!  Tolerances becomes valid in  terms of the checkshape. <br>
class BOP_CorrectTolerances  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Provides valid values of tolerances for the shape <aS> <br>
//! <aTolMax> is max value of the tolerance that can be <br>
//! accepted for correction.  If real value of the tolerance <br>
//! will be greater than  <aTolMax>, the correction does not <br>
//! perform. <br>
Standard_EXPORT static  void CorrectTolerances(const TopoDS_Shape& aS,const Standard_Real aTolMax = 0.0001) ;


//! Provides valid values of tolerances for the shape <aS> <br>
//! in  terms of BRepCheck_InvalidCurveOnSurface. <br>
Standard_EXPORT static  void CorrectCurveOnSurface(const TopoDS_Shape& aS,const Standard_Real aTolMax = 0.0001) ;


//! Provides valid values of tolerances for the shape <aS> <br>
//! in  terms of BRepCheck_InvalidPointOnCurve. <br>
Standard_EXPORT static  void CorrectPointOnCurve(const TopoDS_Shape& aS,const Standard_Real aTolMax = 0.0001) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
