// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _AppParCurves_MultiCurve_HeaderFile
#define _AppParCurves_MultiCurve_HeaderFile

#ifndef _Handle_AppParCurves_HArray1OfMultiPoint_HeaderFile
#include <Handle_AppParCurves_HArray1OfMultiPoint.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class AppParCurves_HArray1OfMultiPoint;
class Standard_OutOfRange;
class Standard_DimensionError;
class Standard_ConstructionError;
class AppParCurves_Array1OfMultiPoint;
class AppParCurves_MultiPoint;
class TColgp_Array1OfPnt;
class TColgp_Array1OfPnt2d;
class gp_Pnt;
class gp_Pnt2d;
class gp_Vec;
class gp_Vec2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class describes a MultiCurve approximating a Multiline. <br>
//!          As a Multiline is a set of n lines, a MultiCurve is a set <br>
//!          of n curves. These curves are Bezier curves. <br>
//!          A MultiCurve is composed of m MultiPoint. <br>
//!          The approximating degree of these n curves is the same for <br>
//!          each one. <br>
class AppParCurves_MultiCurve  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! returns an indefinite MultiCurve. <br>
Standard_EXPORT AppParCurves_MultiCurve();

//! creates a MultiCurve, describing Bezier curves all <br>
//!          containing the same number of MultiPoint. <br>
//!          An exception is raised if Degree < 0. <br>
Standard_EXPORT AppParCurves_MultiCurve(const Standard_Integer NbPol);

//! creates a MultiCurve, describing Bezier curves all <br>
//!          containing the same number of MultiPoint. <br>
//!          Each MultiPoint must have NbCurves Poles. <br>
Standard_EXPORT AppParCurves_MultiCurve(const AppParCurves_Array1OfMultiPoint& tabMU);


Standard_EXPORT virtual  void Delete() ;
Standard_EXPORT virtual ~AppParCurves_MultiCurve(){Delete();}

//! The number of poles of the MultiCurve <br>
//!          will be set to <nbPoles>. <br>
Standard_EXPORT   void SetNbPoles(const Standard_Integer nbPoles) ;

//! sets the MultiPoint of range Index to the value <br>
//!          <MPoint>. <br>
//!          An exception is raised if Index <0 or Index >NbMPoint. <br>
Standard_EXPORT   void SetValue(const Standard_Integer Index,const AppParCurves_MultiPoint& MPoint) ;

//! Returns the number of curves resulting from the <br>
//! approximation of a MultiLine. <br>
Standard_EXPORT   Standard_Integer NbCurves() const;

//!  Returns the number of poles on curves resulting from the approximation of a MultiLine. <br>
Standard_EXPORT virtual  Standard_Integer NbPoles() const;

//! returns the degree of the curves. <br>
Standard_EXPORT virtual  Standard_Integer Degree() const;

//! returns the dimension of the CuIndex curve. <br>
//!          An exception is raised if CuIndex<0 or CuIndex>NbCurves. <br>
Standard_EXPORT   Standard_Integer Dimension(const Standard_Integer CuIndex) const;

//! returns the Pole array of the curve of range CuIndex. <br>
//!          An exception is raised if the dimension of the curve <br>
//!          is 2d. <br>
Standard_EXPORT   void Curve(const Standard_Integer CuIndex,TColgp_Array1OfPnt& TabPnt) const;

//! returns the Pole array of the curve of range CuIndex. <br>
//!          An exception is raised if the dimension of the curve <br>
//!          is 3d. <br>
Standard_EXPORT   void Curve(const Standard_Integer CuIndex,TColgp_Array1OfPnt2d& TabPnt) const;

//! returns the Index MultiPoint. <br>
//!          An exception is raised if Index <0 or Index >Degree+1. <br>
Standard_EXPORT  const AppParCurves_MultiPoint& Value(const Standard_Integer Index) const;

//! returns the Nieme pole of the CuIndex curve. <br>
//!          the curve must be a 3D curve. <br>
Standard_EXPORT  const gp_Pnt& Pole(const Standard_Integer CuIndex,const Standard_Integer Nieme) const;

//! returns the Nieme pole of the CuIndex curve. <br>
//!          the curve must be a 2D curve. <br>
Standard_EXPORT  const gp_Pnt2d& Pole2d(const Standard_Integer CuIndex,const Standard_Integer Nieme) const;

//! Applies a transformation to the curve of range <br>
//!          <CuIndex>. <br>
//!          newx = x + dx*oldx <br>
//!          newy = y + dy*oldy    for all points of the curve. <br>
//!          newz = z + dz*oldz <br>
Standard_EXPORT   void Transform(const Standard_Integer CuIndex,const Standard_Real x,const Standard_Real dx,const Standard_Real y,const Standard_Real dy,const Standard_Real z,const Standard_Real dz) ;

//! Applies a transformation to the Curve of range <br>
//!          <CuIndex>. <br>
//!          newx = x + dx*oldx <br>
//!          newy = y + dy*oldy    for all points of the curve. <br>
Standard_EXPORT   void Transform2d(const Standard_Integer CuIndex,const Standard_Real x,const Standard_Real dx,const Standard_Real y,const Standard_Real dy) ;

//! returns the value of the point with a parameter U <br>
//!          on the Bezier curve number CuIndex. <br>
//!          An exception is raised if CuIndex <0 or > NbCurves. <br>
//!          An exception is raised if the curve dimension is 2d. <br>
Standard_EXPORT virtual  void Value(const Standard_Integer CuIndex,const Standard_Real U,gp_Pnt& Pt) const;

//! returns the value of the point with a parameter U <br>
//!          on the Bezier curve number CuIndex. <br>
//!          An exception is raised if CuIndex <0 or > NbCurves. <br>
//!          An exception is raised if the curve dimension is 3d. <br>
Standard_EXPORT virtual  void Value(const Standard_Integer CuIndex,const Standard_Real U,gp_Pnt2d& Pt) const;

//! returns the value of the point with a parameter U <br>
//!          on the Bezier curve number CuIndex. <br>
//!          An exception is raised if CuIndex <0 or > NbCurves. <br>
//!          An exception is raised if the curve dimension is 3d. <br>
Standard_EXPORT virtual  void D1(const Standard_Integer CuIndex,const Standard_Real U,gp_Pnt& Pt,gp_Vec& V1) const;

//! returns the value of the point with a parameter U <br>
//!          on the Bezier curve number CuIndex. <br>
//!          An exception is raised if CuIndex <0 or > NbCurves. <br>
//!          An exception is raised if the curve dimension is 2d. <br>
Standard_EXPORT virtual  void D1(const Standard_Integer CuIndex,const Standard_Real U,gp_Pnt2d& Pt,gp_Vec2d& V1) const;

//! returns the value of the point with a parameter U <br>
//!          on the Bezier curve number CuIndex. <br>
//!          An exception is raised if CuIndex <0 or > NbCurves. <br>
//!          An exception is raised if the curve dimension is 3d. <br>
Standard_EXPORT virtual  void D2(const Standard_Integer CuIndex,const Standard_Real U,gp_Pnt& Pt,gp_Vec& V1,gp_Vec& V2) const;

//! returns the value of the point with a parameter U <br>
//!          on the Bezier curve number CuIndex. <br>
//!          An exception is raised if CuIndex <0 or > NbCurves. <br>
//!          An exception is raised if the curve dimension is 2d. <br>
Standard_EXPORT virtual  void D2(const Standard_Integer CuIndex,const Standard_Real U,gp_Pnt2d& Pt,gp_Vec2d& V1,gp_Vec2d& V2) const;

//! Prints on the stream o information on the current <br>
//!          state of the object. <br>
//!          Is used to redefine the operator <<. <br>
Standard_EXPORT virtual  void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Handle_AppParCurves_HArray1OfMultiPoint tabPoint;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
