// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _AdvApprox_SimpleApprox_HeaderFile
#define _AdvApprox_SimpleApprox_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_PLib_JacobiPolynomial_HeaderFile
#include <Handle_PLib_JacobiPolynomial.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Handle_TColStd_HArray2OfReal_HeaderFile
#include <Handle_TColStd_HArray2OfReal.hxx>
#endif
#ifndef _AdvApprox_EvaluatorFunction_HeaderFile
#include <AdvApprox_EvaluatorFunction.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class PLib_JacobiPolynomial;
class TColStd_HArray1OfReal;
class TColStd_HArray2OfReal;
class Standard_OutOfRange;
class Standard_ConstructionError;
class TColStd_Array1OfInteger;
class TColStd_Array1OfReal;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Approximate  a function on   an intervall [First,Last] <br>
//!          The result  is  a simple  polynomial  whose  degree is  as low as <br>
//!          possible  to   satisfy  the required  tolerance  and  the <br>
//!          maximum degree.  The maximum  error and the averrage error <br>
//!          resulting from  approximating the function by the polynomial are computed <br>
class AdvApprox_SimpleApprox  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT AdvApprox_SimpleApprox(const Standard_Integer TotalDimension,const Standard_Integer TotalNumSS,const GeomAbs_Shape Continuity,const Standard_Integer WorkDegree,const Standard_Integer NbGaussPoints,const Handle(PLib_JacobiPolynomial)& JacobiBase,const AdvApprox_EvaluatorFunction& Func);


//!  Warning: <br>
//!     the Function of type <br>
//!     EvaluatorFunction from Approx <br>
//!     must be an extern "C" function otherwise <br>
//!     this will NOT WORK <br>
Standard_EXPORT   void Perform(const TColStd_Array1OfInteger& LocalDimension,const TColStd_Array1OfReal& LocalTolerancesArray,const Standard_Real First,const Standard_Real Last,const Standard_Integer MaxDegree) ;


Standard_EXPORT   Standard_Boolean IsDone() const;


Standard_EXPORT   Standard_Integer Degree() const;

//! returns the coefficients in the Jacobi Base <br>
Standard_EXPORT   Handle_TColStd_HArray1OfReal Coefficients() const;

//! returns the constraints at First <br>
Standard_EXPORT   Handle_TColStd_HArray2OfReal FirstConstr() const;

//! returns the constraints at Last <br>
Standard_EXPORT   Handle_TColStd_HArray2OfReal LastConstr() const;


Standard_EXPORT   Handle_TColStd_HArray1OfReal SomTab() const;


Standard_EXPORT   Handle_TColStd_HArray1OfReal DifTab() const;


Standard_EXPORT   Standard_Real MaxError(const Standard_Integer Index) const;


Standard_EXPORT   Standard_Real AverageError(const Standard_Integer Index) const;

//! display information on approximation <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myTotalNumSS;
Standard_Integer myTotalDimension;
Standard_Integer myNbGaussPoints;
Standard_Integer myWorkDegree;
Standard_Integer myNivConstr;
Handle_PLib_JacobiPolynomial myJacPol;
Handle_TColStd_HArray1OfReal myTabPoints;
Handle_TColStd_HArray2OfReal myTabWeights;
AdvApprox_EvaluatorFunction myEvaluator;
Standard_Integer myDegree;
Handle_TColStd_HArray1OfReal myCoeff;
Handle_TColStd_HArray2OfReal myFirstConstr;
Handle_TColStd_HArray2OfReal myLastConstr;
Handle_TColStd_HArray1OfReal mySomTab;
Handle_TColStd_HArray1OfReal myDifTab;
Handle_TColStd_HArray1OfReal myMaxError;
Handle_TColStd_HArray1OfReal myAverageError;
Standard_Boolean done;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
