#!/usr/bin/perl
#
# vieweditclients.cgi
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# 
# $Id: vieweditclients.cgi,v 1.7 2001/08/29 22:22:45 adam Exp $
#use strict qw(refs vars);

require 'etc/timesheet.conf';
require 'lib/client-funcs.pl';
require 'lib/common-funcs.pl';
use CGI qw(:standard);
use ADB;

my $dead = '';
my $function;
my $dummy;

my $javave =<<EOT;

function jump_cut () {

   myrec = eval(parent.right.document.loghours.record_number.value);
   totrec = eval(parent.right.document.loghours.totalrecords.value);
   if (isNaN(myrec)) {
      alert("The record number must be a number!");
   }

   if ( (myrec > totrec) || (myrec <= 0)) {
       alert("Hmmm. Can't find record number " +  myrec + " because there are only " + totrec + " records!" );
       parent.right.document.loghours.record_number.value = eval(parent.right.document.loghours.recordnumber.value);
   }
   else {
       document.loghours.submit();
  }
}

EOT
    
#&time_head($Conf::VIEWEDIT_CLIENTS);
    print header;
if(param('delete.x')){
    
    print start_html('-title'      =>$Conf::VIEWEDIT_CLIENTS,
		     '-BACKGROUND' => $Conf::BACKGROUND,
		     '-script'     =>$Conf::JAVA_HELP . $javave,     
		     '-BGCOLOR'    => $Conf::BGCOLOR,
		     '-onLoad'     => 'parent.left.location.reload();'
		     );
}else{
    
    print start_html('-title'      =>$Conf::VIEWEDIT_CLIENTS,
		     '-BACKGROUND' => $Conf::BACKGROUND,
		     '-script'     =>$Conf::JAVA_HELP . $javave,     
		     '-BGCOLOR'    => $Conf::BGCOLOR,
		     );
}


&help_button_big('VIEWEDIT_CLIENTS');


if(param('recordnumber') != param('record_number')){
    my %state;
    my $dbconn;
    my $oops;
    my %clients;
    my %client_info;
    my $var;
    &print_form_head;

    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if(!$dbconn->is_ok){
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);

    $state{'record_number'} = param('record_number');
    # Let's get our recordkeeping straight
    $state{'nextrecord'} = $state{'record_number'} + 1;
    $state{'prevrecord'} = ($state{'record_number'} - 1);
    $state{'recordnumber'} = $state{'record_number'};
    if ($state{'nextrecord'} > $state{'totalrecords'}){
	$state{'nextrecord'} = 0;
    }


    %clients = &get_client_search_result($dbconn, $state{'searchtable'});
    $state{'client_id'} = $clients{$state{'recordnumber'}};
    %client_info = &client_join($dbconn, $state{'client_id'});
    

    &add_client_to_state(\%state, \%client_info, $dbconn);
    
    &reset_all_params;

    &admin_show_client_form(%state);


    &write_state(%state);
    &print_client_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";
    

    
# }
}
elsif(param('apply.x')){
    my %state;
    my $dbconn;
    my $oops;
    my %clients;
    my %client_info;
    my $var;
    my $reply;
    my $sql;
    my $current_client_id;
    &print_form_head;
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if(!$dbconn->is_ok){
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);
    my $current_client = $state{'recordnumber'};

    %clients = &get_client_search_result($dbconn, $state{'searchtable'});
    $current_client_id = $clients{$current_client};
    %client_info = &client_join($dbconn, $current_client_id);



    ##
    my $tempopen;
    $tempopen = 0 if param('open') eq 'n';
    $tempopen = 1 if param('open') eq 'y';

    $client_info{'default_bill_rate'} = param('default_bill_rate') if param('default_bill_rate');

    $client_info{'client_name'} = param('client_name') if param('client_name');


    $client_info{'default_approved'} = 0 if param('default_approved') eq 'n';
    $client_info{'default_approved'} = 1 if param('default_approved') eq 'y';


    &scrub_hash(\%client_info);

    # Make our SQL
    $sql = "UPDATE client SET ";
    $sql .= "client_name = '$client_info{'client_name'}', ";
    $sql .= "default_bill_rate = '$client_info{'default_bill_rate'}', ";
    $sql .= "default_approved = $client_info{'default_approved'} ";
    $sql .= "WHERE client_id = $current_client_id;";

    $reply = $dbconn->query($sql);
    if(!$reply){
	$oops = $dbconn->errorstring;
	&error("Update error for client '$current_client_id': $oops", $sql);
    }
    
    $state{'client_id'} = $clients{$state{'recordnumber'}};
    %client_info = &client_join($dbconn, $state{'client_id'});

    &add_client_to_state(\%state, \%client_info, $dbconn);

    &reset_all_params;

    &admin_show_client_form(%state);


    &write_state(%state);
    &print_client_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";

}elsif(param('delete.x')){
    my %state;
    my $dbconn;
    my $oops;
    my %client;
    my %client_info;
    my $var;
    my $current_client_id;
    my $sql, $reply;

    &print_form_head;

    # If we came her via approve, we dont change anything
    # Otherwise we properly change recordnumber, nextrec etc...
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if(!$dbconn->is_ok){
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);
    my $current_client = $state{'recordnumber'};

    %client = &get_client_search_result($dbconn, $state{'searchtable'});
    
    $current_client_id = $client{$current_client};

    $sql = "DELETE from $state{'searchtable'} where client_id = $current_client_id;";
    $reply = $dbconn->query($sql);
    if(!$reply){
	$oops = $dbconn->errorstring;
	&error("Delete error for $current_client_id: $oops", $sql);
    }

    $sql = "DELETE from $Conf::CLIENT_DB where client_id = $current_client_id;";
    $reply = $dbconn->query($sql);
    if(!$reply){
	$oops = $dbconn->errorstring;
	&error("Delete error for $current_client_id: $oops", $sql);
    }
    $sql = "UPDATE $Conf::JOB_DB set fkclient_id = '9999' where fkclient_id = $current_client_id;";
    $reply = $dbconn->query($sql);
    if(!$reply){
	$oops = $dbconn->errorstring;
	&error("Delete error updating jobs for $current_client_id: $oops", $sql);
    }

    $state{'totalrecords'}--;
    if ($state{'totalrecords'} == 0){
	&admin_search_client_form(%state);
	&searchbutton;
	&write_state(%state);
	print "</FORM>";
	exit;
    }
    if($state{'totalrecords'} < $state{'recordnumber'}){
	$state{'recordnumber'} = $state{'totalrecords'};
	$state{'nextrecord'} = 0;
	$state{'prevrecord'} = ($state{'totalrecords'} - 1);
    }

    %client = &get_client_search_result($dbconn, $state{'searchtable'});
    $state{'client_id'} = $client{$state{'recordnumber'}};
    if(!$state{'client_id'}){
	&error("Next record not found, please use your back button");
    }
    %client_info = &client_join($dbconn, $state{'client_id'});

    &add_client_to_state(\%state, \%client_info, $dbconn);

    &reset_all_params;

    &admin_show_client_form(%state);

    &write_state(%state);
    &print_client_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";

    exit;
}elsif(param('prevrecord.x')){
    my %state;
    my $dbconn;
    my $oops;
    my %client;
    my %client_info;
    my $var;
    &print_form_head;
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if(!$dbconn->is_ok){
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);

    # Let's get our recordkeeping straight
    $state{'nextrecord'} = $state{'recordnumber'};
    $state{'recordnumber'} = $state{'prevrecord'};    
    $state{'prevrecord'} = ($state{'recordnumber'} - 1);


    %client = &get_client_search_result($dbconn, $state{'searchtable'});
    $state{'client_id'} = $client{$state{'recordnumber'}};
    %client_info = &client_join($dbconn, $state{'client_id'});

    &add_client_to_state(\%state, \%client_info, $dbconn);
    &reset_all_params;
    
    &admin_show_client_form(%state);


    &write_state(%state);
    &print_client_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";

}elsif(param('nextrecord.x') || param('approve.x')){
    my %state;
    my $dbconn;
    my $oops;
    my %client;
    my %client_info;
    my $var;


    # OK, if we are doing an "Approve, we basically perform a
    # next record with one itnermediate step  So we just set a var
    # here to use in some conditionals later on



    &print_form_head;
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if(!$dbconn->is_ok){
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);

    $state{'prevrecord'} = $state{'recordnumber'};
    $state{'recordnumber'} = $state{'nextrecord'};    
    $state{'nextrecord'} = ($state{'recordnumber'} + 1);
    if ($state{'nextrecord'} > $state{'totalrecords'}){
	$state{'nextrecord'} = 0;
    }


    %client = &get_client_search_result($dbconn, $state{'searchtable'});

    $state{'client_id'} = $client{$state{'recordnumber'}};


    %client_info = &client_join($dbconn, $state{'client_id'});

    &add_client_to_state(\%state, \%client_info, $dbconn);

    &admin_show_client_form(%state);

    &write_state(%state);
    &print_client_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";


}elsif(param('searchsubmit.x')){
    my %state;
    my $searchtable;
    my $dbconn;
    my $result;
    my $oops;
    my %client;
    my $var;
    &print_form_head;


    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if(!$dbconn->is_ok){
	$oops = $dbconn->errorstring;
	&error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);

    # Drop any old searches from temp storage in the DB
    $result = $dbconn->query("DROP TABLE temp_client_search_$state{'remote_user'};");
    
    # Get all the state variables in shape for the search
    $state{'default_approved'} = 0 if (param('default_approved') eq "n");
    $state{'default_approved'} = 1 if (param('default_approved') eq "y");

    $state{'client_id'} = param('client_id') if param('client_id');
    $state{'client_name'} = param('client_name') if param('client_name');
    $state{'default_bill_rate'} = param('default_bill_rate') if param('default_bill_rate');
    

    &scrub_hash(\%state);
    # Run the search and get our temp storage table in return
    $state{'searchtable'} = &search_client(%state);
    
    # Fill up a hash with our results
    %client = &get_client_search_result($dbconn, $state{'searchtable'});
    
    if (!$client{'1'}){
	print "<H1>No Matches Found</H1>";

	&admin_search_client_form(%state);

	&searchbutton;
	print "</FORM>";
	exit;
    }else{
	$state{'client_id'} = $client{'1'};
	
    }
    
    #if we want the short listing do this
    if(param('output') eq "short"){
	my $key;
	my %short_job;
	my $sq = "Select * from $state{'searchtable'}, client WHERE ";
	$sq .= "$state{'searchtable'}.client_id ";
	$sq .= "= client.client_id;";
	my $client_munge = $dbconn->query("$sq");
	if (!$client_munge){
	    my $oops = $dbconn->errorstring;
	    &error("Error getting client munge: $oops", $sq);
	}
	print "<H3 align=center>Short Listing</H3><br>";
	print "<TABLE BORDER=1>";
	print "<TR><TH>Client ID</TH><TH>Client</TH><TH>Default Billing</TH><TH>Default Approved</TH></TR>\n";
	my $numlines = $client_munge->get_num_rows;
	my $i;
	my %chash;
	$i = 0;
	while ($i < $numlines){
	    %chash = $client_munge->get_row($i);
	    print "<TR><TD>$chash{'client_id'}</TD><TD>$chash{'client_name'}</TD><TD>$chash{'default_bill_rate'}</TD><TD>";
	    if ($chash{'default_approved'}){
		print "Yes";
	    }else{
		print "No";
	    }
	    print "</TD></TR>\n";
	    $i++;
	}
	
	
	print "</TABLE>";
	&write_state(%state);
	print '<INPUT TYPE="image" NAME="search" SRC="images/search.gif" BORDER=0>';

    
    }
    # OTHERWISE WE DO LONG OUTPUT
    else{
      # Some wooparse SQL to get all teh info for our first record
      my %client_info = &client_join($dbconn, $state{'client_id'});
      
      # Add these to our state hash
      
      &add_client_to_state(\%state, \%client_info, $dbconn);


      $state{'recordnumber'} = 1;
      my @recs = keys %client;
      $state{'totalrecords'} = $#recs + 1;
      if($state{'totalrecords'} == $state{'recordnumber'}){
	$state{'nextrecord'} = 0;
      }
      else{
	$state{'nextrecord'} = ($state{'recordnumber'} +1);
      }
      
      &admin_show_client_form(%state);
      
      &write_state(%state);
      
      &print_client_commands(%state);
      &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
			'recordnumber'=>"$state{'recordnumber'}",
			'nextrecord'=>"$state{'nextrecord'}");
      print "</FORM>";
    
    }#END OF LONG OUTPUT BLOCK
    
}else{				# The bottom of the basket, print new form
    my %state;
    my $oops;
    my $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if(!$dbconn->is_ok){
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    $state{'client_id'} = param('client_id');
    if($state{'client_id'}){
	$state{'client_name'} = &client_id_to_name($state{'client_id'});
    }
    $state{'remote_user'} = remote_user;
    
    &print_form_head;
    
    &reset_all_params;
    param('default_bill_rate','');
    param('default_approved','any');
    &admin_search_client_form('client_id'=>"$state{'client_id'}",
			      'client_name'=>"$state{'client_name'}",
			      'remote_user'=>"$state{'remote_user'}");

    
    &searchbutton;
    &write_state(%state);
    print "</FORM>";
    
}

sub print_form_head{
print <<EOT;
<CENTER>
<IMG SRC="images/vieweditclients-big.gif" BORDER=0 ALT=[View/Edit Jobs]>
</CENTER>
<FORM NAME=loghours METHOD="POST" ACTION="vieweditclients.cgi">
EOT


}

sub searchbutton
{
    print "<INPUT TYPE=\"image\" NAME=\"searchsubmit\" SRC=\"images/search.gif\" BORDER=\"0\">";
}


sub add_client_to_state
{
    my $st = shift;
    my $jb = shift;
    my $var;
    foreach $var (keys %$jb){
	$$st{$var} = $$jb{$var};
    }
    
    if($$st{'default_approved'} == 1){
        $$st{'default_approved'} = "y";
    }else{
        $$st{'default_approved'} = "n";
    }

}







