#!/usr/bin/perl
#
#
use LWP::UserAgent; 
use Getopt::Long; 

# EXECUTIVE SUMMARY:
# ------------------
#
# Pulls down client and job data from a timesheet server, sends it to
# stdout.  Usage: 
#
#    timesheet-get-data.pl URL
#       USER\n
#       PASSWORD\n
#
# I.e., you have to send it user and password on the first two lines
# of stdin.  That's the only non-command-line input this script
# receives, AFAIK.   -kff



&GetOptions(
	    "approot=s" => \$approot, 
	    "type=s" => \$type, 
	    "cgi=s" => \$cgi, 
	    );

if ( ! $approot ) {
    $approot = "http://localhost/onshore-timesheet/";
}

if ( ! $cgi ) { 
    $cgi = "dump-clients-jobs.cgi"; 
}

$url = shift; 
if ( ! $url ) { 
  if ( $type eq "client" or $type eq "job" ) { 
    $url = "$approot/$cgi?dump=$type"; 
  } else {
    print "ERROR: unknown type \"$type\"\n";
    exit 1; 
  }
}

# We get user and password from stdin.  This is preferable to command
# line options because this way they don't show up in process lists. 
$uname = <>;
chomp $uname;
$password = <>;
chomp $password;

$ua=new LWP::UserAgent; 
# Create a user agent object
$ua->agent("timesheet-getdata/0.8" . $ua->agent);
# Create a request
my $req = new HTTP::Request GET => $url; 
$req->authorization_basic($uname, $password);

$res = $ua->request($req); 

if ( $res->is_success ) { 
    print $res->content; 
} else {
    print "ERROR: GET of  \"$url\"  failed.\n" ;
    exit 1; 
}


