# [.MK]OpenVMS.MMS.  This file is .included from [.platform]'platform'.mms
# (where 'platform' is OpenVMS_Alpha_n_m or OpenVms_VAX_n_m).  The platform
# specific file sets the macro, $(POSIX_LIB_DEPEND) used below.

OMNIORB_IDL_LC_FLAGS = -l
OMNIORB_IDL_ANY_FLAGS = "-Wba"
OMNIORB_IDL_ONLY = omniidl -bcxx
OMNIORB_IDL = $(OMNIORB_IDL_ONLY) $(OMNIORB_IDL_ANY_FLAGS)

OMNIORB_VERSION = 4.1.0
OMNIORB_MAJOR_VERSION = $(word 1,$(subst ., ,$(OMNIORB_VERSION)))
OMNIORB_MINOR_VERSION = $(word 2,$(subst ., ,$(OMNIORB_VERSION)))
OMNIORB_MICRO_VERSION = $(word 3,$(subst ., ,$(OMNIORB_VERSION)))
OMNIORB_FILE_VERSION=$(foreach x,$(OMNIORB_MICRO_VERSION),$(OMNIORB_MAJOR_VERSION))
OMNIORB_LIB=omniORB$(OMNIORB_FILE_VERSION)
OMNIDYN_LIB=omniDynamic$(OMNIORB_FILE_VERSION)

OMNITHREAD_VERSION = 3.0
OMNITHREAD_MAJOR_VERSION = $(word 1,$(subst ., ,$(OMNITHREAD_VERSION)))
OMNITHREAD_MINOR_VERSION = $(word 2,$(subst ., ,$(OMNITHREAD_VERSION)))
OMNITHREAD_MICRO_VERSION = $(word 3,$(subst ., ,$(OMNITHREAD_VERSION)))
OMNITHREAD_FILE_VERSION=\
$(foreach x,$(OMNITHREAD_MICRO_VERSION),$(OMNITHREAD_MAJOR_VERSION))
OMNITHREAD_LIB=omnithread$(OMNITHREAD_FILE_VERSION)

# Note that it is imperative to use omnilib: rather than $(LIBPATH_V)
# in the following to avoid the DCL "%DCL-W-TKNOVF, command element is
# too long - shorten" hatefulness.
OMNIORB_SHAREDLIB=omnilib:omni_share$(CONFIG_SUFFIX).olb
OMNIORB_SHAREDLIB_DEPEND=$(LIBPATH_V)omni_share$(CONFIG_SUFFIX).olb\
	$(POSIX_LIB_DEPEND)

OMNITHREAD_SHAREDLIB_DEPEND = $(LIBPATH_V)$(OMNITHREAD_LIB)$(ShareableImageSuffix).exe\
	$(POSIX_LIB_DEPEND)
OMNITHREAD_STATICLIB_DEPEND = $(LIBPATH_V)$(OMNITHREAD_LIB)$(CONFIG_SUFFIX).olb $(POSIX_LIB_DEPEND)
OMNITHREAD_STATICLIB = $(LIBPATH_V)$(OMNITHREAD_LIB)$(CONFIG_SUFFIX).olb

.ifdef USE_SHAREABLE_IMAGES
OMNITHREAD_LIB_DEPEND	= $(OMNITHREAD_SHAREDLIB_DEPEND)
OMNITHREAD_LIB		= $(OMNIORB_SHAREDLIB)
.else
OMNITHREAD_LIB_DEPEND	= $(OMNITHREAD_STATICLIB_DEPEND)
OMNITHREAD_LIB		= $(OMNITHREAD_STATICLIB)
.endif

# set compiler switch and library for floating point option.

# (Can no longer enforce mutual exclusion of
# D_FLOAT|G_FLOAT|IEEE_FLOAT.  Now MMS will redefine existing macro.
# Oh well...)

.IFDEF D_FLOAT
FloatType = D
.ENDIF

.IFDEF G_FLOAT
FloatType = G
.ENDIF

.IFDEF IEEE_FLOAT
FloatType = IEEE
.ENDIF

# handle default case:
.IFDEF D_FLOAT
.ELSE
# ifndef D_FLOAT
.IFDEF G_FLOAT
.ELSE
# ifndef G_FLOAT
.IFDEF IEEE_FLOAT
.ELSE
# ifndef IEEE_FLOAT

.IFDEF ALPHA
# Alpha default
FloatType = G
DefaultFloatType=1
.ELSE
# VAX default
FloatType = D
DefaultFloatType=1
.ENDIF	! Alpha vs VAX

.ENDIF	! IEEE_FLOAT else clause
.ENDIF	! G_FLOAT else clause
.ENDIF	! D_FLOAT else clause

.ifdef DefaultFloatType
# if taking the default then conserve command line space.
.else
OMNIORB_CXXFLOAT = /Float=$(FloatType)_Float
.endif

.IFDEF USE_SHAREABLE_IMAGES
CORBA_LIB_DEPEND = $(OMNIORB_SHAREDLIB_DEPEND)
CORBA_LIB = $(OMNIORB_SHAREDLIB)
.ELSE
CORBA_LIB_DEPEND = $(LIBPATH_V)omniDynamic3$(CONFIG_SUFFIX).olb\
 $(LIBPATH_V)omniORB3$(CONFIG_SUFFIX).olb\
 $(OMNITHREAD_LIB_DEPEND)
CORBA_LIB = $(LIBPATH_V)omniDynamic3$(CONFIG_SUFFIX).olb\
 $(LIBPATH_V)omniORB3$(CONFIG_SUFFIX).olb\
 $(OMNITHREAD_LIB)
.ENDIF

OMNIORB_LIB_REPOSITORY=omnilib:
OMNIORB_LIB_CXXFLAGS = $(PLATFORM_LIB_CXXFLAGS)
OMNIORB_CXXINCLUDES = ./ $(TOP)/include
OMNIORB_CINCLUDES = ./ $(TOP)/include
OMNIORB_IDL_FLAGS = -IomniIdls: $(OMNIORB_IDL_PLATFORM)

# Note that the MMS $(patsubst ...) function uses '%' to match a
# single character only (like some file systems do).

BinPattern=*$(CONFIG_SUFFIX).exe
