# Coming into this file, the make variable CURRENT should have been defined.
#
# Note that unlike other platforms, TOP is not currently defined.  Instead, it
# is required that a concealed, rooted logical be defined so that readme.openvms
# resides in [000000].  CURRENT is used only as a unique key identifying the
# source directory.

# Either uncomment out one of the platform lines below or use the autoconfig
# mechanism by uncommenting out this line

autoconfig=1

#platform=OpenVMS_Alpha_6_2	# OpenVMS Alpha 6.2 Compaq C++ 5.6 or 6.2
#platform=OpenVMS_Alpha_7_1	# OpenVMS Alpha 7.1 Compaq C++ 5.6 or 6.2
#platform=OpenVMS_Alpha_7_2	# OpenVMS Alpha 7.2 Compaq C++ 5.6 or 6.2
#platform=OpenVMS_VAX_6_1	# OpenVMS VAX 6.1 Compaq C++ 5.6
#platform=OpenVMS_VAX_6_2	# OpenVMS VAX 6.2 Compaq C++ 5.6
#platform=OpenVMS_VAX_7_1	# OpenVMS VAX 7.1 Compaq C++ 5.6
#platform=OpenVMS_VAX_7_2	# OpenVMS VAX 7.2 Compaq C++ 5.6

# Also enable one of the following (if autoconfig is not used):
# CXX5=1	# Compaq C++ 5.x compiler
# CXX6=1	# Compaq C++ 6.x compiler (Alpha only)

# Enable one of the following for the release version of the libraries.  (Note
# that /Debug=all may seem odd for release builds, but could be useful for
# running PCA or analyzing crash dumps).

# RELEASE_DEBUG=/NoDebug
# RELEASE_DEBUG=/Debug=all
RELEASE_DEBUG=/Debug=trace

# enable this to link against shareable images
USE_SHAREABLE_IMAGES=1

# if autoconfig is not enabled then set the following to a concealed, rooted,
# logical name that points to the top level directory.

# UTOP=/omnidevroot # unix format
# VTOP=omnidevroot: # vms format

# Set the verification level of compilations here.  I.e., if you want only brief
# messages ("Compiling foo.cc...") set this to 0 or comment it out.
COMPILE_VERIFY=0

# Note that unlike other platforms, EXPORT_TREE and IMPORT_TREES is not defined
# here.  This way, these can be overridden later (unlike GNUmake, MMS does not
# allow you to redefine a macro).

# Macro to indicate whether the current directory has been initialized.

dir_initialized=_$(CURRENT)_initialized_

# If the directory has been initialized then $(dir_initialized) will be defined
# in the following.

.include [mk]dirs.mms

# If the directory has been initialized then go ahead and build

.ifdef $(dir_initialized)

.ifdef autoconfig
.include [mk]platform.mms
.endif

.include [mk]beforedir.mms
.include dir.mms
.include dependencies.d

# otherwise initialize the directory, add $(dir_initialized)=1 to [mk]dirs.mms
# then recurse.

.else


.default
	@ !

premake ::
	@ $(CONFIGURE_PLATFORM)
	@ mms /macro=(dir.mms) /descr=[mk]premake.mms
	@ @[mk]adddir.dcl "$(dir_initialized)"

all :: premake
	@ $(mms) $(mmsqualifiers) $(mmstargets)

export :: all

.endif

.include [mk]afterdir.mms
