// Copyright (C) 2006 Bruno Roggeri <mpomme@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#ifndef TICKS_H
#define TICKS_H

#include <stdio.h>
#include <list>
#include "globals.h"
#include "prop_matrix.h"

/*#define DEBUG_OCPLOT_TICKS*/
#ifdef DEBUG_OCPLOT_TICKS
#define _DEBUG_TICKS_PRINT(...) fprintf(stderr , __VA_ARGS__)
#else
#define _DEBUG_TICKS_PRINT(...)
#endif

class Ticks {
public:
  Ticks(int direction, ocpl::Handle Parent, double base = 10.); 
  ~Ticks();
  void SetRange(double left, double right);
  void SetPixelSize(double psize);
  void SetLogScale(bool logscale);
  void GetAutoTicks(Matrix& ticks_mat);
#ifdef TICKS_TEST
  void TestBetween(double a, double b) {
      Between(a, b);
  }
#endif

private:
  // figure handle
  ocpl::Handle _parent;

  // Find all multiples of the base
  void FindBaseFactors();
  // Factors of the base
  int nf;
  double *factors;

  // Is there some space for more ticks ?
  bool EvaluateClutter();
  double MinDT();
  double MaxDT();

  // Linear case
  void AddTicks(double dt);
  void AddTicks();
  int level;

  // Logarithmic case
  void AddLogTicks();
  void Between(double l, double r);
  
  
  // Defines the dataspace to cover
  double left;
  double right;
  double range;
  bool inverted;
  bool logscale;

  // Base of the tick positions
  // Usually we work in base-10
  double base;

  // Direction of the axes we're drawing for.
  // 0->x
  // 1->y
  int direction;
  // "Physical" pixel size 
  double psize;

  list<double> ticks;
};

#endif
