// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#ifndef SURFACE_H
#define SURFACE_H

#include <FL/gl.h>
#include "globals.h"
#include "object.h"

//! Holds Patch objects
class Surface : public Object {
public:
  Surface(ocpl::Handle Parent,
	  Matrix& XData, 
	  Matrix& YData, 
	  Matrix& ZData); 
  ~Surface() {};
  void draw();
private:
  double midp(Matrix& M, long i, long j) {
    return ( M(i,j) + M(i+1,j) + M(i,j+1) + M(i+1,j+1) )/4.0;
  };
  GLuint display_list;
};

#endif
