// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#include "prop_scalar.h"

void Scalar::Get(ocpl::command& com)
{
  com.argout(0,ocpl::real,1,1,reinterpret_cast<char*>(&Value));
}

void Scalar::Set(ocpl::command& com)
{
   if(com.argin(2)->id != ocpl::real) {
    ret_error(com,"Value of property must be real");
    return;
  }
  
  if(com.argin(2)->nr*com.argin(2)->nc!=1) {
    ret_error(com,"Value of property must be scalar");
    return;
  }
  
  Value = *(reinterpret_cast<double*>(com.argin(2)->data));
  com.init_argout(0);
}
