## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} vtk_update(@var{f})
## Internal octaviz function for updating the specified figure.
## @end deftypefn
## @seealso{vtk_clear}

## Author: Dragan Tubic, Jonathan Stickel


function vtk_update(f)
  
  f.outline_actor.VisibilityOff();
  f.axes.VisibilityOff();

  if ( f.axes_on )
    b = f.renderer.ComputeVisiblePropBounds();
    f.outline.SetBounds( b(1), b(2), b(3), b(4), b(5), b(6) );
    f.axes.SetInput( f.outline_actor.GetMapper.GetInput );
    f.outline_actor.VisibilityOn();
    f.axes.VisibilityOn();
  end
  
  f.renderer.ResetCamera();
  f.window.Render();
  
endfunction

## 'f.axes_on' is reverting to 1 after being set to 0, effectively making the if statement above of no effect
## to be solved later; JJS 1/24/07
## for example, do:
##(make a figure with axes, e.g. vtk_sombsurf)
##f = vtk_figure(0);
##f.axes_on = 0
##vtk_update (f);
##clear f
##f = vtk_figure (0);
##f.axes_on
