

%  This example demonstrates the use of glyphing. We also use a mask filter
%  to select a subset of points to glyph.

vtk_init;

VTK_DATA_ROOT = vtkGetDataRoot();

%  Read a data file. This originally was a Cyberware laser digitizer scan 
%  of Fran J.'s face. Surface normals are generated based on local geometry
%  (i.e., the polygon normals surrounding eash point are averaged). We flip
%  the normals because we want them to point out 
fran = vtkPolyDataReader();
fran.SetFileName(strcat(VTK_DATA_ROOT,"/Data/fran_cut.vtk"));
normals = vtkPolyDataNormals();
normals.SetInput(fran.GetOutput());
normals.FlipNormalsOn();
franMapper = vtkPolyDataMapper();
franMapper.SetInput(normals.GetOutput());
franActor = vtkActor();
franActor.SetMapper(franMapper);
franActor.GetProperty().SetColor(1.0, 0.49, 0.25);

%  We subsample the dataset because we want to glyph just a subset of
%  the points. Otherwise the display is cluttered and cannot be easily
%  read. The RandonModeOn and SetOnRatio combine to random select one out
%  of every 10 points in the dataset.
ptMask = vtkMaskPoints();
ptMask.SetInput(normals.GetOutput());
ptMask.SetOnRatio(10);
ptMask.RandomModeOn();

%  In this case we are using a cone as a glyph. We transform the cone so
%  its base is at 0,0,0. This is the point where glyph rotation occurs.
cone = vtkConeSource();
cone.SetResolution(6);
transform = vtkTransform();
transform.Translate(0.5, 0.0, 0.0);
transformF = vtkTransformPolyDataFilter();
transformF.SetInput(cone.GetOutput());
transformF.SetTransform(transform);

%  vtkGlyph3D takes two inputs: the input point set (SetInput) which can be
%  any vtkDataSet; and the glyph (SetSource) which must be a vtkPolyData.
%  We are interested in orienting the glyphs by the surface normals that
%  we previosuly generated.
glyph = vtkGlyph3D();
glyph.SetInput(ptMask.GetOutput());
glyph.SetSource(transformF.GetOutput());
glyph.SetVectorModeToUseNormal();
glyph.SetScaleModeToScaleByVector();
glyph.SetScaleFactor(0.004);
spikeMapper = vtkPolyDataMapper();
spikeMapper.SetInput(glyph.GetOutput());
spikeActor = vtkActor();
spikeActor.SetMapper(spikeMapper);
spikeActor.GetProperty().SetColor(0.0, 0.79, 0.34);

%  Create the RenderWindow, Renderer and both Actors
ren = vtkRenderer();
renWin = vtkRenderWindow();
renWin.AddRenderer(ren);
iren = vtkRenderWindowInteractor();
iren.SetRenderWindow(renWin);

%  Add the actors to the renderer, set the background and size
ren.AddActor(franActor);
ren.AddActor(spikeActor);

renWin.SetSize(500, 500);
ren.SetBackground(0.1, 0.2, 0.4);

%  Set a nice camera position.
cam1 = ren.GetActiveCamera();
cam1.Zoom(1.4);
cam1.Azimuth(110);


% renWin.Render();
vtkInitializeInteractor(iren);
