

%  This example demonstrates how to use implicit modelling.

vtk_init;
vtkColors;

VTK_DATA_ROOT = vtkGetDataRoot();

%  Create lines which serve as the "seed" geometry. The lines spell the
%  word "hello".
reader = vtkPolyDataReader();
reader.SetFileName(strcat(VTK_DATA_ROOT,"/Data/hello.vtk"));
lineMapper = vtkPolyDataMapper();
lineMapper.SetInput(reader.GetOutput());
lineActor = vtkActor();
lineActor.SetMapper(lineMapper);
lineActor.GetProperty().SetColor(red);

%  Create implicit model with vtkImplicitModeller. This computes a
%  scalar field which is the distance 
%  contour filter then extracts the geoemtry at the distance value 0.25
%  
imp = vtkImplicitModeller();
imp.SetInput(reader.GetOutput());
imp.SetSampleDimensions(110, 40, 20);
imp.SetMaximumDistance(0.25);
imp.SetModelBounds(-1.0, 10.0, -1.0, 3.0, -1.0, 1.0);
contour = vtkContourFilter();
contour.SetInput(imp.GetOutput());
contour.SetValue(0, 0.25);
impMapper = vtkPolyDataMapper();
impMapper.SetInput(contour.GetOutput());
impMapper.ScalarVisibilityOff();
impActor = vtkActor();
impActor.SetMapper(impMapper);
impActor.GetProperty().SetColor(peacock);
impActor.GetProperty().SetOpacity(0.5);

%  Create the usual graphics stuff.
%  Create the RenderWindow, Renderer and both Actors
ren = vtkRenderer();
renWin = vtkRenderWindow();
renWin.AddRenderer(ren);
iren = vtkRenderWindowInteractor();
iren.SetRenderWindow(renWin);

%  Add the actors to the renderer, set the background and size
ren.AddActor(lineActor);
ren.AddActor(impActor);
ren.SetBackground(1, 1, 1);
renWin.SetSize(600, 250);

camera = vtkCamera();
camera.SetClippingRange(1.81325, 90.6627);
camera.SetFocalPoint(4.5, 1, 0);
camera.SetPosition(4.5, 1.0, 6.73257);
camera.SetViewUp(0, 1, 0);
camera.Zoom(0.8);
ren.SetActiveCamera(camera);


% renWin.Render();
vtkInitializeInteractor(iren);
