%%NAME
%%  ecdcover  -  write a cdcover 
%%
%%SYNOPSIS
%%  ecdcover(title[,description[,author[,version[,date[,textColor
%%          [,frontImage[,background[,logo[,content]]]]]]]]])
%%
%%PARAMETER(S)
%%  title         string of title of cd  
%%  description   string of description, default=''
%%  author        string of author, default=''
%%  version       string of version, default=''
%%  date          string of time or date, default=''
%%  textColor     color vector [r g b]  [0 0 0]=black [1 1 1]=white,
%%                default=[0 0 0]
%%  frontImage    filename(ppm-file)  of frontImage , default=''
%%  background    filename(ppm-file) of background, default=''
%%  logo          filename(ppm-file)  of logo, default=''
%%  content       filename(asci-file, tabs with '#')  of table of contents
%%
% written by Stefan Mueller stefan.mueller@fgan.de 2000

function ecdcover(title,description,author,version,date,textColor, ...
                 frontImage,background,logo,content)
  if nargin<1 | nargin>10
    usage ('ecdcover(title[,description[,author[,version[,date[,textColor[,frontImage[,background[,logo[,content]]]]]]]])');
  end
  eglobpar;
  if nargin<10
    content='';
  end
  if nargin<9
    logo='';
  end
  if nargin<8
    background='';
  end
  if nargin<7
    frontImage='';
  end
  if nargin<6
    textColor=[0 0 0];
  end
  if nargin<5
    date='';
  end
  if nargin<4
    version='';
  end
  if nargin<3
    author='';
  end
  if nargin<2
    description='';
  end

  esavpar;
  fCoverH=119.5;
  fCoverW=119.5;
  bCoverH=117.5;
  bCoverW=150;
  bCoverPos=[(eWinWidth-bCoverW)/2 (eWinHeight-fCoverH-bCoverH)/2];
  fCoverPos=[bCoverPos(1) bCoverPos(2)+0.25+bCoverH];
  contentW=120;
  contentH=60;
  logoH=10;
  fImageH=60;
  if isempty(version)
    fImageH=fImageH-10
  end

%frontside
  %background
  if ~isempty(background)
    ePlotAreaPos=fCoverPos;
    ePlotAreaWidth=fCoverW;
    ePlotAreaHeight=fCoverH;
    [im cm]=eppmread(background);
    eimage(im,cm);
    erect(eFile,eFac*fCoverPos(1),eFac*fCoverPos(2),eFac*fCoverW,...
          eFac*fCoverH,0.2,[0 0 0],0); 
  else
    erect(eFile,eFac*fCoverPos(1),eFac*fCoverPos(2),eFac*fCoverW,...
          eFac*fCoverH,1,[0 0 0],0); 
  end

  %frontImage
  if ~isempty(frontImage)
    [im cm]=eppmread(frontImage);
    [ih iw]=size(im);
    whFac=iw/ih;
    fImageW=fImageH*whFac;
    ePlotAreaPos=[fCoverPos(1)+(fCoverW-fImageW)/2 ...
                  fCoverPos(2)+(fCoverH-fImageH)/3];
    ePlotAreaWidth=fImageW;
    ePlotAreaHeight=fImageH;
    eimage(im,cm);
    erect(eFile,eFac*ePlotAreaPos(1),eFac*ePlotAreaPos(2),eFac*fImageW,...
          eFac*fImageH,0.2,[0 0 0],0); 
  end

  %title
  etext(title,fCoverPos(1)+fCoverW/2,fCoverPos(2)+100,10,0,1,0,textColor);

  %description
  etext(description,fCoverPos(1)+fCoverW/2,fCoverPos(2)+90,6,0,1,0,textColor);

  %version
  etext(version,fCoverPos(1)+fCoverW/2,fCoverPos(2)+10,6,0,1,0,textColor);
  
%backside
  %background
  if ~isempty(background)
    ePlotAreaPos=bCoverPos;
    ePlotAreaWidth=bCoverW;
    ePlotAreaHeight=bCoverH;
    [im cm]=eppmread(background);
    eimage(im,cm);
    erect(eFile,eFac*bCoverPos(1),eFac*bCoverPos(2), ...
      eFac*bCoverW,eFac*bCoverH,0.2,[0 0 0],0); 
  else
    erect(eFile,eFac*bCoverPos(1),eFac*bCoverPos(2), ...
      eFac*bCoverW,eFac*bCoverH,1,[0 0 0],0); 
  end

  %logo
  if ~isempty(logo)
    [im cm]=eppmread(logo);
    [ih iw]=size(im);
    whFac=iw/ih;
    logoW=logoH*whFac;
    ePlotAreaPos=[bCoverPos(1)+(bCoverW-logoW)/2 ...
                  bCoverPos(2)+10+5/2-logoH/2];
    ePlotAreaWidth=logoW;
    ePlotAreaHeight=logoH;
    eimage(im,cm);
  end

  %title
  etext(title,bCoverPos(1)+bCoverW/2,bCoverPos(2)+105,8,0,1,0,textColor);
  etext(title,bCoverPos(1)+4,bCoverPos(2)+bCoverH*5/6,4,0,1,90,textColor);
  etext(title,bCoverPos(1)+bCoverW-4,bCoverPos(2)+bCoverH*5/6,4,0,1,270,textColor);

  %description
  etext(description,bCoverPos(1)+bCoverW/2,bCoverPos(2)+97,5,0,1,0,textColor);
  etext(description,bCoverPos(1)+4,bCoverPos(2)+bCoverH*3/12,4,0,1,90,textColor);
  etext(description,bCoverPos(1)+bCoverW-4,bCoverPos(2)+bCoverH*3/12,4,0,1,270,textColor);

  %date
  etext(date,bCoverPos(1)+bCoverW*1/4,bCoverPos(2)+10,5,0,1,0,textColor);

  %version
  etext(version,bCoverPos(1)+4,bCoverPos(2)+bCoverH*7/12,4,0,1,90,textColor);
  etext(version,bCoverPos(1)+bCoverW-4,bCoverPos(2)+bCoverH*7/12,4,0,1,270,textColor);

  %author
  etext(author,bCoverPos(1)+bCoverW*3/4,bCoverPos(2)+10,5,0,1,0,textColor);

  % table of contents 
  if ~isempty(content)
    textFile=fopen(content,'r');
    [text tl]=fread(textFile,inf,'uchar');              
    textString=setstr(text');
    cr=setstr(13);
    lf=setstr(10);
    tab='#';
    pos=findstr(textString,cr);
    textString(pos)=' ';
    pos=findstr(textString,lf);
    nLines=length(pos);
    fontSpace=contentH/nLines;
    if fontSpace>5;
      fontSize=5;
    else
      fontSize=fontSpace;
    end
    lineStart=1;
    for i=1:nLines
      tabPos=findstr(textString(lineStart:pos(i)-1),tab);
      if length(tabPos)>0
        tabPos=[tabPos+lineStart-1 pos(i)];
      else 
        tabPos=pos(i);
      end
      nRows=length(tabPos);
      tabSpace=contentW/nRows;
      textStart=lineStart;
      for k=1:nRows
        if tabPos(k)>textStart
          text=textString(textStart:(tabPos(k)-1));
          etext(text,bCoverPos(1)+(bCoverW-contentW)/2+(k-1)*tabSpace,...
                bCoverPos(2)+90-i*fontSpace,...
                fontSize,1,1,0,textColor);
        end
        textStart=tabPos(k)+1;

      end
      lineStart=pos(i)+1;
    end
  end
  
  erespar;
