/*
  $Date: 1999/10/15 12:40:27 $
  $Revision: 1.1.1.1 $
  $Author: kise $
  hash.c
  ϥåؿ

  key : 2ĤϢʬΥ٥Ф, idͤؿ
  search : id ͤϥåɽ˴ϿƤ뤫Ĵ٤ؿ
  enter : ϿƤʤid ϥåɽϿؿ
*/

#include <stdio.h>
#include "const.h"
#include "defs.h"
#include "extern.h"
#include "function.h"


namespace voronoi{
    /* ϥåؿ 1 */
    HashVal hash1(Key key)
    {
        return(key % M1);
    }

    /* ϥåؿ 2 */
    HashVal hash2(Key key)
    {
        return(key % M2);
    }

    /* ؿ */
    void init_hash()
    {
        HashVal i;

        for(i=0;i<M1+M2;i++)
            hashtable[i]=NIL;
    }

    /*
     * ϥåؿФ륭Ĥؿ
     * 2ĤΥ٥Ȥ, Фid ֤
     */
    Key key(Label lab1, Label lab2)
    {
        unsigned long key,tmp;

        key = lab1;
        key = key << 2*BYTE;
        tmp = lab2;
        key = key | tmp;
        return key;
    }

    /* id ϥåɽϿƤ뤫Ĵ٤ؿ */ 
    int search(Label lab1, Label lab2)
    {
        Key id;
        HashVal x;
        HashTable *p;

        id = key(lab1,lab2);
        x = hash1(id)+hash2(id);	/* ϥåͤ׻ */
        p = hashtable[x];

        while(p != NIL) {
            if((lab1 == p->lab1) && (lab2 == p->lab2)) /* ϿƤ */
                return(p->entry);	                       /* entry ֤ͤ */
            p = p->next;
        }
    
        return NODATA;	/* ϿƤʤȤNODATA ֤ͤ */
    }

    /*
     * ϿƤʤid ȤФentry ͤ
     * ϥåɽϿؿ
     */ 
    void enter(Label lab1, Label lab2, unsigned int entry)
    {
        Key id;
        HashVal x;
        HashTable *p;

        id = key(lab1,lab2);
        x = hash1(id)+hash2(id);	/* ϥåͤ׻ */
    
        /* Ͽ뤿ΰݤ */
        p = (HashTable *)myalloc(sizeof(HashTable)* 1);

        /* ݤΰ, ͤϿ */
        p->next = hashtable[x];
        hashtable[x] = p;
        hashtable[x]->lab1 = lab1;
        hashtable[x]->lab2 = lab2;
        hashtable[x]->entry = entry;
    }
}
