// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _TDF_Label_HeaderFile
#define _TDF_Label_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _TDF_LabelNodePtr_HeaderFile
#include <TDF_LabelNodePtr.hxx>
#endif
#ifndef _Handle_TDF_Data_HeaderFile
#include <Handle_TDF_Data.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TDF_Attribute_HeaderFile
#include <Handle_TDF_Attribute.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Standard_DomainError;
class Standard_OutOfRange;
class Standard_NullObject;
class TDF_ChildIterator;
class TDF_Attribute;
class TDF_AttributeIterator;
class TDF_Data;
class TDF_LabelMapHasher;
class Standard_GUID;
class TDF_IDFilter;
class TDF_AttributeIndexedMap;


//! This class provides basic operations  to define <br>
//! a label in a data structure. <br>
//! A label is a feature in the feature hierarchy. A <br>
//!          label is always connected to a Data from TDF. <br>
//! To a label is attached attributes containing the <br>
//!          software components information. <br>
//! <br>
//!          Label information: <br>
//! <br>
//!          It is possible to know the tag, the father, the <br>
//!          depth in the tree of the label, if the label is <br>
//!          root, null or equal to another label. <br>
//! <br>
//!          Comfort methods: <br>
//!          Some methods useful on a label. <br>
//! <br>
//!          Attributes: <br>
//! <br>
//!          It is possible to get an attribute in accordance <br>
//!          to an ID, or the yougest previous version of a <br>
//!          current attribute. <br>
class TDF_Label  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Constructs an empty label object. <br>
  Standard_EXPORT   TDF_Label();
  //! Nullifies the label. <br>
//! <br>
        void Nullify() ;
  //! Returns the Data owning <me>. <br>
//! <br>
        Handle_TDF_Data Data() const;
  //! Returns the tag of the label. <br>
//! This is the integer assigned randomly to a label <br>
//!  in a data framework. This integer is used to <br>
//! identify this label in an entry. <br>
//! <br>
        Standard_Integer Tag() const;
  //! Returns the label father. This label may be null <br>
//!          if the label is root. <br>
//! <br>
       const TDF_Label Father() const;
  //! Returns True if the <aLabel> is null, i.e. it has <br>
//!          not been included in the data framework. <br>
//! <br>
        Standard_Boolean IsNull() const;
  //! Sets or unsets <me> and all its descendants as <br>
//!          imported label, according to <aStatus>. <br>
  Standard_EXPORT     void Imported(const Standard_Boolean aStatus) const;
  //! Returns True if the <aLabel> is imported. <br>
//! <br>
        Standard_Boolean IsImported() const;
  //! Returns True if the <aLabel> is equal to me (same <br>
//!           LabelNode*). <br>
        Standard_Boolean IsEqual(const TDF_Label& aLabel) const;
      Standard_Boolean operator ==(const TDF_Label& aLabel) const
{
  return IsEqual(aLabel);
}
  
        Standard_Boolean IsDifferent(const TDF_Label& aLabel) const;
      Standard_Boolean operator !=(const TDF_Label& aLabel) const
{
  return IsDifferent(aLabel);
}
  
        Standard_Boolean IsRoot() const;
  //! Returns true if <me> owns an attribute with <anID> as ID. <br>
  Standard_EXPORT     Standard_Boolean IsAttribute(const Standard_GUID& anID) const;
  //! Adds an Attribute  to the current label. Raises if <br>
//!          there is already one. <br>
  Standard_EXPORT     void AddAttribute(const Handle(TDF_Attribute)& anAttribute) const;
  //!  Forgets an  Attribute   from the  current  label, <br>
//!          setting its   forgotten status true and  its valid <br>
//!           status false. Raises if   the attribute is not in <br>
//!          the structure. <br>
  Standard_EXPORT     void ForgetAttribute(const Handle(TDF_Attribute)& anAttribute) const;
  //! Forgets the  Attribute of  GUID <aguid> from   the <br>
//!          current label   . If the   attribute doesn't exist <br>
//!          returns False. Otherwise returns True. <br>
  Standard_EXPORT     Standard_Boolean ForgetAttribute(const Standard_GUID& aguid) const;
  //! Forgets all the attributes. Does it on also on the <br>
//!          sub-labels if <clearChildren> is set to true. Of <br>
//!          course, this method is compatible with Transaction <br>
//!          & Delta mecanisms. <br>
  Standard_EXPORT     void ForgetAllAttributes(const Standard_Boolean clearChildren = Standard_True) const;
  //! Undo Forget action, setting its forgotten status <br>
//!          false and its valid status true. Raises if the <br>
//!          attribute is not in the structure. <br>
  Standard_EXPORT     void ResumeAttribute(const Handle(TDF_Attribute)& anAttribute) const;
  //! Finds an attribute of the current label, according <br>
//!          to <anID>. <br>
//! If anAttribute is not a valid one, false is returned. <br>
//! <br>
//!        The method returns True if found, False otherwise. <br>
//! <br>
//!          A removed attribute cannot be found. <br>
  Standard_EXPORT     Standard_Boolean FindAttribute(const Standard_GUID& anID,Handle(TDF_Attribute)& anAttribute) const;
  //! Finds an attribute of the current label, according <br>
//!          to <anID> and <aTransaction>. This attribute <br>
//!          has/had to be a valid one for the given <br>
//!          transaction index . So, this attribute is not <br>
//!          necessary a valid one. <br>
//! <br>
//!          The method returns True if found, False otherwise. <br>
//! <br>
//!          A removed attribute cannot be found nor a backuped <br>
//!          attribute of a removed one. <br>
  Standard_EXPORT     Standard_Boolean FindAttribute(const Standard_GUID& anID,const Standard_Integer aTransaction,Handle(TDF_Attribute)& anAttribute) const;
  //! Returns true if <me> or a DESCENDANT of <me> owns <br>
//!          attributes not yet available in transaction 0. It <br>
//!          means at least one of their attributes is new, <br>
//!          modified or deleted. <br>
//! <br>
        Standard_Boolean MayBeModified() const;
  //! Returns true if <me> owns attributes not yet <br>
//!          available in transaction 0. It means at least one <br>
//!          attribute is new, modified or deleted. <br>
//! <br>
        Standard_Boolean AttributesModified() const;
  //! Returns true if this label has at least one attribute. <br>
  Standard_EXPORT     Standard_Boolean HasAttribute() const;
  //! Returns the number of attributes. <br>
  Standard_EXPORT     Standard_Integer NbAttributes() const;
  //! Returns the depth of the label in the data framework. <br>
//! This corresponds to the number of fathers which <br>
//! this label has, and is used in determining <br>
//! whether a label is root, null or equivalent to another label. <br>
//! Exceptions: <br>
//! Standard_NullObject if this label is null. This is <br>
//! because a null object can have no depth. <br>
  Standard_EXPORT     Standard_Integer Depth() const;
  //! Returns True if <me> is a descendant of <br>
//!          <aLabel>. Attention: every label is its own <br>
//!          descendant. <br>
  Standard_EXPORT     Standard_Boolean IsDescendant(const TDF_Label& aLabel) const;
  //! Returns the root label Root of the data structure. <br>
//! This has a depth of 0. <br>
//! Exceptions: <br>
//! Standard_NullObject if this label is null. This is <br>
//! because a null object can have no depth. <br>
  Standard_EXPORT    const TDF_Label Root() const;
  //! Returns true if this label has at least one child. <br>
        Standard_Boolean HasChild() const;
  //! Returns the number of children. <br>
  Standard_EXPORT     Standard_Integer NbChildren() const;
  //! Finds a child label having <aTag> as tag. Creates <br>
//! The tag aTag identifies the label which will be the parent. <br>
//! If create is true and no child label is found, a new one is created. <br>
//! Example: <br>
//! //creating a label with tag 10 at Root <br>
//! TDF_Label lab1 = aDF->Root().FindChild(10); <br>
//! //creating labels 7 and 2 on label 10 <br>
//! TDF_Label lab2 = lab1.FindChild(7); <br>
//! TDF_Label lab3 = lab1.FindChild(2); <br>
  Standard_EXPORT     TDF_Label FindChild(const Standard_Integer aTag,const Standard_Boolean create = Standard_True) const;
  //! Create  a new child   label of me  using autoamtic <br>
//!          delivery tags provided by TagSource. <br>
        TDF_Label NewChild() const;
  //! Returns the current transaction index. <br>
  Standard_EXPORT     Standard_Integer Transaction() const;
  //! Returns true if node address of <me> is lower than <br>
//!          <otherLabel> one. Used to quickly sort labels (not <br>
//!          on entry criterion). <br>
//! <br>
//! -C++: inline <br>
  Standard_EXPORT     Standard_Boolean HasLowerNode(const TDF_Label& otherLabel) const;
  //! Returns true if node address of <me> is greater <br>
//!          than <otherLabel> one. Used to quickly sort labels <br>
//!          (not on entry criterion). <br>
//! <br>
//! -C++: inline <br>
  Standard_EXPORT     Standard_Boolean HasGreaterNode(const TDF_Label& otherLabel) const;
  //! Dumps the minimum information about <me> on <br>
//!          <aStream>. <br>
//! <br>
  Standard_EXPORT     Standard_OStream& Dump(Standard_OStream& anOS) const;
    Standard_OStream& operator<<(Standard_OStream& anOS) const
{
  return Dump(anOS);
}
  //! Dumps the label on <aStream> and its attributes <br>
//!          rank in <aMap> if their IDs are kept by <IDFilter>. <br>
  Standard_EXPORT     void ExtendedDump(Standard_OStream& anOS,const TDF_IDFilter& aFilter,TDF_AttributeIndexedMap& aMap) const;
  //! Dumps the label entry. <br>
  Standard_EXPORT     void EntryDump(Standard_OStream& anOS) const;


friend class TDF_ChildIterator;
friend class TDF_Attribute;
friend class TDF_AttributeIterator;
friend class TDF_Data;
friend class TDF_LabelMapHasher;



protected:





private:

  //! Reserved to the friends. <br>
  Standard_EXPORT   TDF_Label(const TDF_LabelNodePtr& aNode);
  //! Adds an Attribute to <toNode>. Raises if there is <br>
//!          already one. <br>
  Standard_EXPORT     void AddToNode(const TDF_LabelNodePtr& toNode,const Handle(TDF_Attribute)& anAttribute) const;
  //! Forgets an Attribute from <fromNode>.  Raises if <br>
//!          the attribute is not in the structure. <br>
  Standard_EXPORT     void ForgetFromNode(const TDF_LabelNodePtr& fromNode,const Handle(TDF_Attribute)& anAttribute) const;
  //! Resumes a forgotten Attribute to <toNode>.  Raises <br>
//!          if the attribute is not in the structure. <br>
  Standard_EXPORT     void ResumeToNode(const TDF_LabelNodePtr& fromNode,const Handle(TDF_Attribute)& anAttribute) const;
  
  Standard_EXPORT     TDF_LabelNodePtr FindOrAddChild(const Standard_Integer aTag,const Standard_Boolean create) const;
  
  Standard_EXPORT     void InternalDump(Standard_OStream& anOS,const TDF_IDFilter& aFilter,TDF_AttributeIndexedMap& aMap,const Standard_Boolean extended) const;


TDF_LabelNodePtr myLabelNode;


};


#include <TDF_Label.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
