// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _gp_Sphere_HeaderFile
#define _gp_Sphere_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _gp_Ax3_HeaderFile
#include <gp_Ax3.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _gp_Ax1_HeaderFile
#include <gp_Ax1.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif
class Standard_ConstructionError;
class gp_Ax3;
class gp_Pnt;
class gp_Ax1;
class gp_Ax2;
class gp_Trsf;
class gp_Vec;


Standard_EXPORT const Handle(Standard_Type)& STANDARD_TYPE(gp_Sphere);


//! Describes a sphere. <br>
//! A sphere is defined by its radius and positioned in space <br>
//! with a coordinate system (a gp_Ax3 object). The origin of <br>
//! the coordinate system is the center of the sphere. This <br>
//! coordinate system is the "local coordinate system" of the sphere. <br>
//! Note: when a gp_Sphere sphere is converted into a <br>
//! Geom_SphericalSurface sphere, some implicit <br>
//! properties of its local coordinate system are used explicitly: <br>
//! -   its origin, "X Direction", "Y Direction" and "main <br>
//!   Direction" are used directly to define the parametric <br>
//!   directions on the sphere and the origin of the parameters, <br>
//! -   its implicit orientation (right-handed or left-handed) <br>
//!   gives the orientation (direct, indirect) to the <br>
//!   Geom_SphericalSurface sphere. <br>
//! See Also <br>
//! gce_MakeSphere which provides functions for more <br>
//! complex sphere constructions <br>
//! Geom_SphericalSurface which provides additional <br>
//! functions for constructing spheres and works, in <br>
//! particular, with the parametric equations of spheres. <br>
class gp_Sphere  {

public:

  DEFINE_STANDARD_ALLOC

  //! Creates an indefinite sphere. <br>
      gp_Sphere();
  
//! Constructs a sphere with radius Radius, centered on the origin <br>
//!   of A3.  A3 is the local coordinate system of the sphere. <br>
//!  Warnings : <br>
//!  It is not forbidden to create a sphere with null radius. <br>
//! Raises ConstructionError if Radius < 0.0 <br>
      gp_Sphere(const gp_Ax3& A3,const Standard_Real Radius);
  //! Changes the center of the sphere. <br>
        void SetLocation(const gp_Pnt& Loc) ;
  //! Changes the local coordinate system of the sphere. <br>
        void SetPosition(const gp_Ax3& A3) ;
  //! Assigns R the radius of the Sphere. <br>
//! Warnings : <br>
//!  It is not forbidden to create a sphere with null radius. <br>
//! Raises ConstructionError if R < 0.0 <br>
        void SetRadius(const Standard_Real R) ;
  
//! Computes the aera of the sphere. <br>
        Standard_Real Area() const;
  
//!  Computes the coefficients of the implicit equation of the quadric <br>
//!  in the absolute cartesian coordinates system : <br>
//!  A1.X**2 + A2.Y**2 + A3.Z**2 + 2.(B1.X.Y + B2.X.Z + B3.Y.Z) + <br>
//!  2.(C1.X + C2.Y + C3.Z) + D = 0.0 <br>
  Standard_EXPORT     void Coefficients(Standard_Real& A1,Standard_Real& A2,Standard_Real& A3,Standard_Real& B1,Standard_Real& B2,Standard_Real& B3,Standard_Real& C1,Standard_Real& C2,Standard_Real& C3,Standard_Real& D) const;
  //! Reverses the   U   parametrization of   the sphere <br>
//!          reversing the YAxis. <br>
        void UReverse() ;
  //! Reverses the   V   parametrization of   the  sphere <br>
//!          reversing the ZAxis. <br>
        void VReverse() ;
  //! Returns true if the local coordinate system of this sphere <br>
//! is right-handed. <br>
        Standard_Boolean Direct() const;
  //!--- Purpose ; <br>
//!  Returns the center of the sphere. <br>
       const gp_Pnt& Location() const;
  
//!  Returns the local coordinates system of the sphere. <br>
       const gp_Ax3& Position() const;
  //! Returns the radius of the sphere. <br>
        Standard_Real Radius() const;
  //! Computes the volume of the sphere <br>
        Standard_Real Volume() const;
  //! Returns the axis X of the sphere. <br>
        gp_Ax1 XAxis() const;
  //! Returns the axis Y of the sphere. <br>
        gp_Ax1 YAxis() const;
  
  Standard_EXPORT     void Mirror(const gp_Pnt& P) ;
  
//!  Performs the symmetrical transformation of a sphere <br>
//!  with respect to the point P which is the center of the <br>
//!  symmetry. <br>
  Standard_EXPORT     gp_Sphere Mirrored(const gp_Pnt& P) const;
  
  Standard_EXPORT     void Mirror(const gp_Ax1& A1) ;
  
//!  Performs the symmetrical transformation of a sphere with <br>
//!  respect to an axis placement which is the axis of the <br>
//!  symmetry. <br>
  Standard_EXPORT     gp_Sphere Mirrored(const gp_Ax1& A1) const;
  
  Standard_EXPORT     void Mirror(const gp_Ax2& A2) ;
  
//!  Performs the symmetrical transformation of a sphere with respect <br>
//!  to a plane. The axis placement A2 locates the plane of the <br>
//!  of the symmetry : (Location, XDirection, YDirection). <br>
  Standard_EXPORT     gp_Sphere Mirrored(const gp_Ax2& A2) const;
  
        void Rotate(const gp_Ax1& A1,const Standard_Real Ang) ;
  
//!  Rotates a sphere. A1 is the axis of the rotation. <br>
//!  Ang is the angular value of the rotation in radians. <br>
        gp_Sphere Rotated(const gp_Ax1& A1,const Standard_Real Ang) const;
  
        void Scale(const gp_Pnt& P,const Standard_Real S) ;
  
//!  Scales a sphere. S is the scaling value. <br>
//!  The absolute value of S is used to scale the sphere <br>
        gp_Sphere Scaled(const gp_Pnt& P,const Standard_Real S) const;
  
        void Transform(const gp_Trsf& T) ;
  
//!  Transforms a sphere with the transformation T from class Trsf. <br>
        gp_Sphere Transformed(const gp_Trsf& T) const;
  
        void Translate(const gp_Vec& V) ;
  
//!  Translates a sphere in the direction of the vector V. <br>
//!  The magnitude of the translation is the vector's magnitude. <br>
        gp_Sphere Translated(const gp_Vec& V) const;
  
        void Translate(const gp_Pnt& P1,const gp_Pnt& P2) ;
  
//!  Translates a sphere from the point P1 to the point P2. <br>
        gp_Sphere Translated(const gp_Pnt& P1,const gp_Pnt& P2) const;
    const gp_Ax3& _CSFDB_Getgp_Spherepos() const { return pos; }
    Standard_Real _CSFDB_Getgp_Sphereradius() const { return radius; }
    void _CSFDB_Setgp_Sphereradius(const Standard_Real p) { radius = p; }



protected:




private: 


gp_Ax3 pos;
Standard_Real radius;


};


#include <gp_Sphere.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
