#include "portable.h"

#include <stdio.h>

#include <ac/ctype.h>
#include <ac/socket.h>
#include <ac/string.h>
#include <ac/time.h>
#include <ac/regex.h>

#include <pwd.h>

#include "slap.h"
#include "external.h"
#include <ldap_pvt.h>
#include "nws_back_cache.h"
#include "nws_back.h"

#include "portable.h"

#include <stdio.h>

AttributeDescription *ad_objectClass = NULL;
AttributeDescription *ad_forecast = NULL;
AttributeDescription *ad_timeStamp = NULL;
AttributeDescription *ad_value = NULL; 
AttributeDescription *ad_mse_forecast = NULL;
AttributeDescription *ad_mae_forecast = NULL;
AttributeDescription *ad_mse_error = NULL;
AttributeDescription *ad_mae_error = NULL;
AttributeDescription *ad_measurement = NULL;
AttributeDescription *ad_index0 = NULL;
AttributeDescription *ad_index1 = NULL;
AttributeDescription *ad_event = NULL;
AttributeDescription *ad_series = NULL;
AttributeDescription *ad_daemon = NULL;
AttributeDescription *ad_skill = NULL;
AttributeDescription *ad_skillName = NULL;
AttributeDescription *ad_activity = NULL;
AttributeDescription *ad_control = NULL;
AttributeDescription *ad_controlName = NULL;
AttributeDescription *ad_fqdn_port = NULL;
AttributeDescription *ad_daemonType = NULL; 
AttributeDescription *ad_ipAddress = NULL;
AttributeDescription *ad_memory = NULL;
AttributeDescription *ad_host = NULL;
AttributeDescription *ad_label = NULL;
AttributeDescription *ad_option = NULL;
AttributeDescription *ad_resource = NULL;
AttributeDescription *ad_buffer = NULL;
AttributeDescription *ad_message = NULL;
AttributeDescription *ad_size = NULL;
AttributeDescription *ad_target = NULL;
AttributeDescription *ad_nice = NULL;
AttributeDescription *ad_period = NULL;
AttributeDescription *ad_member = NULL;
AttributeDescription *ad_type = NULL;
AttributeDescription *ad_hostname = NULL;
AttributeDescription *ad_owner = NULL;
AttributeDescription *ad_port = NULL;
AttributeDescription *ad_started = NULL;
AttributeDescription *ad_version = NULL;
AttributeDescription *ad_path = NULL;

int 
nwsLdapInit(nwsBackConfig *nbc) {

  int rc;
  const char *text;

  Debug(LDAP_DEBUG_TRACE, "==>nwsLdapInit()\n",0,0,0);

  /*   rc = slap_str2ad( "objectClass", &ad_objectClass, &text ); */
  /*   if(rc != LDAP_SUCCESS) return -1; */

  /* use the server's copy */
  ad_objectClass = slap_schema.si_ad_objectClass;

  rc = slap_str2ad( "timestamp", &ad_timeStamp, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"timestamp\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "value", &ad_value, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"value\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "measurement", &ad_measurement, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"measurement\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "forecast", &ad_forecast, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"forecast\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "mse-forecast", &ad_mse_forecast, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"mse-forecast\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "mae-forecast", &ad_mae_forecast, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"mae-forecast\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "mse-error", &ad_mse_error, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"mse-error\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "mae-error", &ad_mae_error, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"mae-error\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "event", &ad_event, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"event\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "index0", &ad_index0, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"index0\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "index1", &ad_index1, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"index1\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "series", &ad_series, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"series\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "daemon", &ad_daemon, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"daemon\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "activity", &ad_activity, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"activity\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "skill", &ad_skill, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"skill\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "skillName", &ad_skillName, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"skillName\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "control", &ad_control, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"control\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad( "controlName", &ad_controlName, &text );
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"controlName\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("fqdn-port", &ad_fqdn_port, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"fqdn-port\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("daemonType", &ad_daemonType, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"daemonType\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("ipAddress", &ad_ipAddress, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"ipAddress\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("memory", &ad_memory, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"memory\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("host", &ad_host, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"host\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("label", &ad_label, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"label\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("option", &ad_option, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"option\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("resource", &ad_resource, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"resource\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("buffer", &ad_buffer, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"buffer\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("message", &ad_message, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"message\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("size", &ad_size, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"size\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("target", &ad_target, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"target\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("nice", &ad_nice, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"nice\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("period", &ad_period, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"period\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("member", &ad_member, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"member\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("type", &ad_type, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"type\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("hostname", &ad_hostname, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"hostname\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("owner", &ad_owner, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"owner\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("port", &ad_port, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"port\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("started", &ad_started, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"started\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("version", &ad_version, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"version\",...) failed.\n");
	return(-1);
  }

  rc = slap_str2ad("path", &ad_path, &text);
  if(rc != LDAP_SUCCESS) {
	printf("slap_str2ad(\"path\",...) failed.\n");
	return(-1);
  }

  /* ad_free(ad_objectClass, 1); */

  Debug(LDAP_DEBUG_TRACE, "<==nwsLdapInit()\n",0,0,0);

  return(0);
}

Entry *
nwsBaseEntry(Backend *be, char *rdn, const char *base) 
{
  Entry *e;
  int rc;
  int err = LDAP_SUCCESS;
  const char *text;
  char *type;
  char *s;
  struct berval val, *vals[2];
  AttributeDescription *ad_desc = NULL;

  Debug(LDAP_DEBUG_TRACE, "==>nwsBaseEntry()\n",0,0,0);
  
  vals[0] = &val;
  vals[1] = NULL;

  /* Create an entry corresponding to the base DN */
  e = (Entry *) ch_calloc(1, sizeof(Entry));
  e->e_attrs = NULL;
  e->e_dn = ch_strdup(base);


  val.bv_val = (char *)"GridService";
  val.bv_len = sizeof("GridService")-1;
  attr_merge(e, ad_objectClass, vals);
	
  /* Use the first attribute of the DN
   * as an attribute within the entry itself.
   */
  rdn = dn_rdn(NULL, base);

  if( rdn == NULL || (s = strchr(rdn, '=')) == NULL ) { 
 	  err = LDAP_INVALID_DN_SYNTAX; 
 	  free(rdn);
	  entry_free(e);
 	  return(NULL);
  } 

  val.bv_val = rdn_attr_value(rdn);
  val.bv_len = strlen(val.bv_val);

  type = rdn_attr_type(rdn);

  rc = slap_str2ad(type, &ad_desc, &text); 
  if( rc != LDAP_SUCCESS ) { 
 	err = LDAP_NO_SUCH_OBJECT;
	if(type != NULL) free(type);
	if(val.bv_val != NULL) free(val.bv_val);
 	free(rdn);
	entry_free(e);
 	return NULL; 
  } 

  attr_merge(e, ad_desc, vals);

  if(type != NULL) free(type);
  if(val.bv_val != NULL) free(val.bv_val);
  free(rdn);
  rdn = NULL;

  Debug(LDAP_DEBUG_TRACE, "<==nwsBaseEntry()\n",0,0,0);
  return(e);
}  

Entry *
nws2entry(Backend *be, NWSobj *nobj, char *rdn)
{
    Entry		*e;
	char		buf[256];
	struct berval	val;
	struct berval	*vals[2];

	Debug(LDAP_DEBUG_TRACE, "==>nws2entry()\n",0,0,0);

	vals[0] = &val;
	vals[1] = NULL;

	e = (Entry *) ch_calloc(1, sizeof(Entry));
	e->e_attrs = NULL;

	/* objectclasses should be configurable items */
	val.bv_val = (char *)"top";
	val.bv_len = sizeof("top")-1;
	attr_merge(e, ad_objectClass, vals);

	val.bv_val = (char *)"service";
	val.bv_len = sizeof("service")-1;
	attr_merge(e, ad_objectClass, vals);

	if (!strcmp("nwsHost", nobj->type)) {
	  val.bv_val = (char *)"GridDaemon";
	  val.bv_len = sizeof("GridDaemon")-1;
	  attr_merge(e, ad_objectClass, vals);

	  sprintf(buf, "daemon=%s,%s", nobj->name, be->be_suffix[0]);
	  e->e_dn = ch_strdup(buf);
	  e->e_ndn = ch_strdup(buf);
	  (void) dn_normalize(e->e_ndn);

	  val.bv_val = nobj->name;
	  val.bv_len = strlen(nobj->name);
	  attr_merge(e, ad_daemon, vals);
 	  attr_merge(e, ad_fqdn_port, vals);

	  if (nobj->at.nd.hostname != NULL) {
		val.bv_val = nobj->at.nd.hostname;
		val.bv_len = strlen(nobj->at.nd.hostname);
		attr_merge(e, ad_hostname, vals);
	  }

	  if (nobj->at.nd.daemonType != NULL) {
		val.bv_val = nobj->at.nd.daemonType;
		val.bv_len = strlen(nobj->at.nd.daemonType);
		attr_merge(e, ad_daemonType, vals);
	  }

	  if (nobj->at.nd.ipAddress != NULL) {
		val.bv_val = nobj->at.nd.ipAddress;
		val.bv_len = strlen(nobj->at.nd.ipAddress);
		attr_merge(e, ad_ipAddress, vals);
	  }

	  if (nobj->at.nd.owner != NULL) {
		val.bv_val = nobj->at.nd.owner;
		val.bv_len = strlen(nobj->at.nd.owner);
		attr_merge(e, ad_owner, vals);
	  }

	  if (nobj->at.nd.port != NULL) {
		val.bv_val = nobj->at.nd.port;
		val.bv_len = strlen(nobj->at.nd.port);
		attr_merge(e, ad_port, vals);
	  }

	  if (nobj->at.nd.started != NULL) {
		val.bv_val = nobj->at.nd.started;
		val.bv_len = strlen(nobj->at.nd.started);
		attr_merge(e, ad_started, vals);
	  }

	  if (nobj->at.nd.version != NULL) {
		val.bv_val = nobj->at.nd.version;
		val.bv_len = strlen(nobj->at.nd.version);
		attr_merge(e, ad_version, vals);
	  }
	}
	else if (!strcmp("nwsSeries", nobj->type)) {
	  val.bv_val = (char *)"GridSeries";
	  val.bv_len = sizeof("GridSeries")-1;
	  attr_merge(e, ad_objectClass, vals);

	  sprintf(buf, "series=%s,%s", nobj->name, be->be_suffix[0]);
	  e->e_dn = ch_strdup(buf);
	  e->e_ndn = ch_strdup(buf);
	  (void) dn_normalize(e->e_ndn);

	  val.bv_val = nobj->name;
	  val.bv_len = strlen(nobj->name);
	  attr_merge(e, ad_series, vals);

	  if (nobj->at.ns.memory != NULL) {
		val.bv_val = nobj->at.ns.memory;
		val.bv_len = strlen(nobj->at.ns.memory);
		attr_merge(e, ad_memory, vals);
	  }

	  if (nobj->at.ns.host != NULL) {
		val.bv_val = nobj->at.ns.host;
		val.bv_len = strlen(nobj->at.ns.host);
		attr_merge(e, ad_host, vals); 
	  }

	  if (nobj->at.ns.label != NULL) {
		val.bv_val = nobj->at.ns.label;
		val.bv_len = strlen(nobj->at.ns.label);
		attr_merge(e, ad_label, vals); 
	  }

	  if (nobj->at.ns.option != NULL) {
		val.bv_val = nobj->at.ns.option;
		val.bv_len = strlen(nobj->at.ns.option);
		attr_merge(e, ad_option, vals); 
	  }

	  if (nobj->at.ns.resource != NULL) {
		val.bv_val = nobj->at.ns.resource;
		val.bv_len = strlen(nobj->at.ns.resource);
		attr_merge(e, ad_resource, vals); 
	  }

	  if (nobj->at.ns.activity != NULL) {
		val.bv_val = nobj->at.ns.activity;
		val.bv_len = strlen(nobj->at.ns.activity);
		attr_merge(e, ad_activity, vals); 
	  }	  

	  if (nobj->at.ns.target != NULL) {
		val.bv_val = nobj->at.ns.target;
		val.bv_len = strlen(nobj->at.ns.target);
		attr_merge(e, ad_target, vals); 
	  }	  

	}
	else if (!strcmp("nwsActivity", nobj->type)) {
	  val.bv_val = (char *)"GridActivity";
	  val.bv_len = sizeof("GridActivity")-1;
	  attr_merge(e, ad_objectClass, vals);

	  sprintf(buf, "activity=%s,%s", nobj->name, be->be_suffix[0]);
	  e->e_dn = ch_strdup(buf);
	  e->e_ndn = ch_strdup( buf );
	  (void) dn_normalize(e->e_ndn);

	  val.bv_val = nobj->name;
	  val.bv_len = strlen(nobj->name);

	  attr_merge(e, ad_activity, vals);
	  
	  if (nobj->at.na.controlName != NULL) {
		val.bv_val = nobj->at.na.controlName;
		val.bv_len = strlen(nobj->at.na.controlName);
		attr_merge(e, ad_controlName, vals); 
	  }

	  if (nobj->at.na.host != NULL) {
		val.bv_val = nobj->at.na.host;
		val.bv_len = strlen(nobj->at.na.host);
		attr_merge(e, ad_host, vals); 
	  }

	  if (nobj->at.na.option != NULL) {
		val.bv_val = nobj->at.na.option;
		val.bv_len = strlen(nobj->at.na.option);
		attr_merge(e, ad_option, vals); 
	  }
	  
	  if (nobj->at.na.resource != NULL) {
		val.bv_val = nobj->at.na.resource;
		val.bv_len = strlen(nobj->at.na.resource);
		attr_merge(e, ad_resource, vals); 
	  }
	  
	  if (nobj->at.na.skillName != NULL) {
		val.bv_val = nobj->at.na.skillName;
		val.bv_len = strlen(nobj->at.na.skillName);
		attr_merge(e, ad_skillName, vals); 
	  }
	  
	  if (nobj->at.na.period != NULL) {
		val.bv_val = nobj->at.na.period;
		val.bv_len = strlen(nobj->at.na.period);
		attr_merge(e, ad_period, vals); 
	  }
	  
	  if (nobj->at.na.member != NULL) {
		val.bv_val = nobj->at.na.member;
		val.bv_len = strlen(nobj->at.na.member);
		attr_merge(e, ad_member, vals); 
	  }
	  
	  if (nobj->at.na.size != NULL) {
		val.bv_val = nobj->at.na.size;
		val.bv_len = strlen(nobj->at.na.size);
		attr_merge(e, ad_size, vals); 
	  }
	  
	  if (nobj->at.na.type != NULL) {
		val.bv_val = nobj->at.na.type;
		val.bv_len = strlen(nobj->at.na.type);
		attr_merge(e, ad_type, vals); 
	  }
	  
	  if (nobj->at.na.buffer != NULL) {
		val.bv_val = nobj->at.na.buffer;
		val.bv_len = strlen(nobj->at.na.buffer);
		attr_merge(e, ad_buffer, vals); 
	  }

	  if (nobj->at.na.message != NULL) {
		val.bv_val = nobj->at.na.message;
		val.bv_len = strlen(nobj->at.na.message);
		attr_merge(e, ad_message, vals); 
	  }

	}
	else if (!strcmp("nwsControl", nobj->type)) {
	  val.bv_val = (char *)"GridControl";
	  val.bv_len = sizeof("GridControl")-1;
	  attr_merge(e, ad_objectClass, vals);

	  sprintf(buf, "control=%s,%s", nobj->name, be->be_suffix[0]);
	  e->e_dn = ch_strdup(buf);
	  e->e_ndn = ch_strdup(buf);
	  (void) dn_normalize(e->e_ndn);

	  val.bv_val = nobj->name;
	  val.bv_len = strlen(nobj->name);
	  attr_merge(e, ad_control, vals);

	  if (nobj->at.nc.controlName != NULL) {
		val.bv_val = nobj->at.nc.controlName;
		val.bv_len = strlen(nobj->at.nc.controlName);
		attr_merge(e, ad_controlName, vals);
	  }

	  if (nobj->at.nc.host != NULL) {
		val.bv_val = nobj->at.nc.host;
		val.bv_len = strlen(nobj->at.nc.host);
		attr_merge(e, ad_host, vals);
	  }

	  if (nobj->at.nc.option != NULL) {
		val.bv_val = nobj->at.nc.option;
		val.bv_len = strlen(nobj->at.nc.option);
		attr_merge(e, ad_option, vals);
	  }

	  if (nobj->at.nc.skillName != NULL) {
		val.bv_val = nobj->at.nc.skillName;
		val.bv_len = strlen(nobj->at.nc.skillName);
		attr_merge(e, ad_skillName, vals);
	  }

	  if (nobj->at.nc.member != NULL) {
		val.bv_val = nobj->at.nc.member;
		val.bv_len = strlen(nobj->at.nc.member);
		attr_merge(e, ad_member, vals);
	  }

	  if (nobj->at.nc.period != NULL) {
		val.bv_val = nobj->at.nc.period;
		val.bv_len = strlen(nobj->at.nc.period);
		attr_merge(e, ad_period, vals);
	  }

	}
	else if (!strcmp("nwsSkill", nobj->type)) {
	  val.bv_val = (char *)"GridSkill";
	  val.bv_len = sizeof("GridSkill")-1;
	  attr_merge(e, ad_objectClass, vals);

	  sprintf(buf, "skill=%s,%s", nobj->name, be->be_suffix[0]);
	  e->e_dn = ch_strdup(buf);
	  e->e_ndn = ch_strdup(buf);
	  (void) dn_normalize(e->e_ndn);

	  val.bv_val = nobj->name;
	  val.bv_len = strlen(nobj->name);
	  attr_merge(e, ad_skill, vals);

	  if (nobj->at.nk.host != NULL) {
		val.bv_val = nobj->at.nk.host;
		val.bv_len = strlen(nobj->at.nk.host);
		attr_merge(e, ad_host, vals);
	  }

	  if (nobj->at.nk.option != NULL) {
		val.bv_val = nobj->at.nk.option;
		val.bv_len = strlen(nobj->at.nk.option);
		attr_merge(e, ad_option, vals);
	  }

	  if (nobj->at.nk.skillName != NULL) {
		val.bv_val = nobj->at.nk.skillName;
		val.bv_len = strlen(nobj->at.nk.skillName);
		attr_merge(e, ad_skillName, vals);
	  }

	  if (nobj->at.nk.path != NULL) {
		val.bv_val = nobj->at.nk.path;
		val.bv_len = strlen(nobj->at.nk.path);
		attr_merge(e, ad_path, vals);
	  }

	  if (nobj->at.nk.nice != NULL) {
		val.bv_val = nobj->at.nk.nice;
		val.bv_len = strlen(nobj->at.nk.nice);
		attr_merge(e, ad_nice, vals);
	  }

	  if (nobj->at.nk.type != NULL) {
		val.bv_val = nobj->at.nk.type;
		val.bv_len = strlen(nobj->at.nk.type);
		attr_merge(e, ad_type, vals);
	  }

	  if (nobj->at.nk.target != NULL) {
		val.bv_val = nobj->at.nk.target;
		val.bv_len = strlen(nobj->at.nk.target);
		attr_merge(e, ad_target, vals);
	  }

	  if (nobj->at.nk.buffer != NULL) {
		val.bv_val = nobj->at.nk.buffer;
		val.bv_len = strlen(nobj->at.nk.buffer);
		attr_merge(e, ad_buffer, vals);
	  }

	  if (nobj->at.nk.message != NULL) {
		val.bv_val = nobj->at.nk.message;
		val.bv_len = strlen(nobj->at.nk.message);
		attr_merge(e, ad_message, vals);
	  }

	  if (nobj->at.nk.size != NULL) {
		val.bv_val = nobj->at.nk.size;
		val.bv_len = strlen(nobj->at.nk.size);
		attr_merge(e, ad_size, vals);
	  }
	}
	else {
	  Debug(LDAP_DEBUG_TRACE,"nws2entry(): unknown nobj->type:%s (name: %s)\n",
			nobj->type, nobj->name,0);
	  
	  entry_free(e);
	  return(NULL);
	}

	Debug(LDAP_DEBUG_TRACE, "<==nws2entry()\n",0,0,0);	
	return(e);
}

Entry *
nwsMeas2entry(Backend *be, nwsSeriesCache *nser, char *rdn) {

  Entry		*e;
  char		buf[256];
  struct berval	val;
  struct berval	*vals[2];

  Debug(LDAP_DEBUG_TRACE, "==>nwsMeas2entry()\n",0,0,0);

  vals[0] = &val;
  vals[1] = NULL;

  e = (Entry *) ch_calloc(1, sizeof(Entry));
  e->e_attrs = NULL;

  val.bv_val = (char *)"top";
  val.bv_len = sizeof("top")-1;
  attr_merge(e, ad_objectClass, vals);

  val.bv_val = (char *)"service";
  val.bv_len = sizeof("service")-1;
  attr_merge(e, ad_objectClass, vals);

  val.bv_val = (char *)"GridEvent";
  val.bv_len = sizeof("GridEvent")-1;
  attr_merge(e, ad_objectClass, vals);

  /*
  sprintf(buf, "event=%s,%s", nser->name, be->be_suffix[1]);
  e->e_dn = ch_strdup(buf);
  e->e_ndn = ch_strdup(buf);
  (void) dn_normalize(e->e_ndn);

  val.bv_val = nser->name;
  val.bv_len = strlen(nser->name);
  attr_merge(e, ad_event, vals);
  */

  sprintf(buf, "forecast=%s,%s", nser->name, be->be_suffix[1]);
  e->e_dn = ch_strdup(buf);
  e->e_ndn = ch_strdup(buf);
  (void) dn_normalize(e->e_ndn);

  val.bv_val = nser->name;
  val.bv_len = strlen(nser->name);
  attr_merge(e, ad_forecast, vals);  

  if(nser->exper != NULL) {
	sprintf(buf, "%d", (int)nser->exper[0].timeStamp);
	val.bv_val = buf;
	val.bv_len = strlen(buf);
	attr_merge(e, ad_timeStamp, vals);

	sprintf(buf, "%f", nser->exper[0].value);
	val.bv_val = buf; 
	val.bv_len = strlen(buf); 
	attr_merge(e, ad_value, vals);
  }
  else {
	val.bv_val = (char *)"-1";
	val.bv_len = sizeof("-1")-1;
	attr_merge(e, ad_timeStamp, vals);

	val.bv_val = (char *)"-1";
	val.bv_len = sizeof("-1")-1;
	attr_merge(e, ad_value, vals);
  }



  Debug(LDAP_DEBUG_TRACE, "<==nwsMeas2entry()\n",0,0,0);
  return(e);
}

Entry *
nwsForc2entry(Backend *be, nwsSeriesCache *nser, char *rdn) {

  Entry		*e;
  char		buf[256];
  struct berval	val;
  struct berval	*vals[2];

  Debug(LDAP_DEBUG_TRACE, "==>nwsForc2entry()\n",0,0,0);

  vals[0] = &val;
  vals[1] = NULL;

  e = (Entry *) ch_calloc(1, sizeof(Entry));
  e->e_attrs = NULL;

  val.bv_val = (char *)"top";
  val.bv_len = sizeof("top")-1;
  attr_merge(e, ad_objectClass, vals);

  val.bv_val = (char *)"service";
  val.bv_len = sizeof("service")-1;
  attr_merge(e, ad_objectClass, vals);

  val.bv_val = (char *)"GridForecast";
  val.bv_len = sizeof("GridForecast")-1;
  attr_merge(e, ad_objectClass, vals);

  sprintf(buf, "forecast=%s,%s", nser->name, be->be_suffix[1]);
  e->e_dn = ch_strdup(buf);
  e->e_ndn = ch_strdup(buf);
  (void) dn_normalize(e->e_ndn);

  val.bv_val = nser->name;
  val.bv_len = strlen(nser->name);
  attr_merge(e, ad_forecast, vals);

  if(nser->forc != NULL) {
	sprintf(buf, "%d", (int)nser->forc[0].measurement.timeStamp);
	val.bv_val = buf;
	val.bv_len = strlen(buf);
	attr_merge(e, ad_timeStamp, vals);

	snprintf(buf, 255, "%.6f", nser->forc[0].forecasts[1].forecast);
	val.bv_val = buf; 
	val.bv_len = strlen(buf); 
	attr_merge(e, ad_mse_forecast, vals);

	snprintf(buf, 255, "%.6f", nser->forc[0].forecasts[1].error);
	val.bv_val = buf; 
	val.bv_len = strlen(buf); 
	attr_merge(e, ad_mse_error, vals);

	snprintf(buf, 255, "%.6f", nser->forc[0].forecasts[0].forecast);
	val.bv_val = buf; 
	val.bv_len = strlen(buf); 
	attr_merge(e, ad_mae_forecast, vals);

	snprintf(buf, 255, "%.6f", nser->forc[0].forecasts[0].error);
	val.bv_val = buf; 
	val.bv_len = strlen(buf); 
	attr_merge(e, ad_mae_error, vals);

/* 	sprintf(buf, "%f", (int)nser->forc[0].measurement.measurement); */
/* 	val.bv_val = buf; */
/* 	val.bv_len = strlen(buf); */
/* 	attr_merge(e, ad_measurement, vals); */
  }
  else if ((nser->forecast_state != NULL) &&
		   (nser->lastupdate.tv_sec > 0) 
		   ){
	sprintf(buf, "%d", (int)nser->exper[0].timeStamp);
	val.bv_val = buf;
	val.bv_len = strlen(buf);
	attr_merge(e, ad_timeStamp, vals);

	sprintf(buf, "%f", nser->exper[0].value);
	val.bv_val = buf; 
	val.bv_len = strlen(buf); 
	attr_merge(e, ad_value, vals);

	snprintf(buf, 255, "%.6f", MSEForecast(nser->forecast_state));
	val.bv_val = buf; 
	val.bv_len = strlen(buf); 
	attr_merge(e, ad_mse_forecast, vals);

	snprintf(buf, 255, "%.6f", MSEError(nser->forecast_state));
	val.bv_val = buf; 
	val.bv_len = strlen(buf); 
	attr_merge(e, ad_mse_error, vals);
	
	snprintf(buf, 255, "%.6f", MAEForecast(nser->forecast_state));
	val.bv_val = buf; 
	val.bv_len = strlen(buf); 
	attr_merge(e, ad_mae_forecast, vals);

	snprintf(buf, 255, "%.6f", MAEError(nser->forecast_state));
	val.bv_val = buf; 
	val.bv_len = strlen(buf); 
	attr_merge(e, ad_mae_error, vals);
  }

  else {
 	val.bv_val = (char *)"-1"; 
 	val.bv_len = sizeof("-1")-1; 
 	attr_merge(e, ad_timeStamp, vals); 

  	val.bv_val = (char *)"-1";  
  	val.bv_len = sizeof("-1")-1;  
  	attr_merge(e, ad_value, vals); 
  }

  Debug(LDAP_DEBUG_TRACE, "<==nwsForc2entry()\n",0,0,0);
  return(e);
}


Entry *
nwsColl2entry(Backend *be, nwsSeriesCache2Coll *nser_c2c,
			  nwsSeriesCache *nser, char *rdn) {

  Entry		*e;
  char		buf[256];
  struct berval	val;
  struct berval	*vals[2];

  Debug(LDAP_DEBUG_TRACE, "==>nwsColl2entry()\n",0,0,0);

  vals[0] = &val;
  vals[1] = NULL;

  e = (Entry *) ch_calloc(1, sizeof(Entry));
  e->e_attrs = NULL;

  val.bv_val = (char *)"top";
  val.bv_len = sizeof("top")-1;
  attr_merge(e, ad_objectClass, vals);

  val.bv_val = (char *)"service";
  val.bv_len = sizeof("service")-1;
  attr_merge(e, ad_objectClass, vals);

  val.bv_val = (char *)"GridForecast";
  val.bv_len = sizeof("GridForecast")-1;
  attr_merge(e, ad_objectClass, vals);

  sprintf(buf, "forecast=%s,%s", nser->name, be->be_suffix[1]);
  e->e_dn = ch_strdup(buf);
  e->e_ndn = ch_strdup(buf);
  (void) dn_normalize(e->e_ndn);

  val.bv_val = nser->name;
  val.bv_len = strlen(nser->name);
  attr_merge(e, ad_forecast, vals);

  sprintf(buf, "%d", nser_c2c->index0);
  val.bv_val = buf;
  val.bv_len = strlen(buf);
  attr_merge(e, ad_index0, vals);

  sprintf(buf, "%d", nser_c2c->index1);
  val.bv_val = buf;
  val.bv_len = strlen(buf);
  attr_merge(e, ad_index1, vals);

  if ((nser->forecast_state != NULL) &&
	  (nser->lastupdate.tv_sec > 0) 
	  ){
	sprintf(buf, "%d", (int)nser->exper[0].timeStamp);
	val.bv_val = buf;
	val.bv_len = strlen(buf);
	attr_merge(e, ad_timeStamp, vals);

	sprintf(buf, "%f", nser->exper[0].value);
	val.bv_val = buf; 
	val.bv_len = strlen(buf); 
	attr_merge(e, ad_value, vals);

	snprintf(buf, 255, "%.6f", MSEForecast(nser->forecast_state));
	val.bv_val = buf; 
	val.bv_len = strlen(buf); 
	attr_merge(e, ad_mse_forecast, vals);

	snprintf(buf, 255, "%.6f", MSEError(nser->forecast_state));
	val.bv_val = buf; 
	val.bv_len = strlen(buf); 
	attr_merge(e, ad_mse_error, vals);
	
	snprintf(buf, 255, "%.6f", MAEForecast(nser->forecast_state));
	val.bv_val = buf; 
	val.bv_len = strlen(buf); 
	attr_merge(e, ad_mae_forecast, vals);

	snprintf(buf, 255, "%.6f", MAEError(nser->forecast_state));
	val.bv_val = buf; 
	val.bv_len = strlen(buf); 
	attr_merge(e, ad_mae_error, vals);
  }

  else {
 	val.bv_val = (char *)"-1"; 
 	val.bv_len = sizeof("-1")-1; 
 	attr_merge(e, ad_timeStamp, vals); 

  	val.bv_val = (char *)"-1";  
  	val.bv_len = sizeof("-1")-1;  
  	attr_merge(e, ad_value, vals); 
  }

  Debug(LDAP_DEBUG_TRACE, "<==nwsColl2entry()\n",0,0,0);
  return(e);
}
